/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.file.common;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.keycloak.models.map.common.CastUtils;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.storage.file.common.WritingMechanism;

public interface BlockContext<V> {
    public void writeValue(V var1, WritingMechanism var2);

    public BlockContext<?> getContext(String var1);

    default public void add(String name, Object value) {
    }

    default public void add(Object value) {
    }

    public V getResult();

    public Class<?> getScalarType();

    public static class DefaultMapContext<T>
    implements BlockContext<Map<String, T>> {
        private final Map<String, T> result = new LinkedHashMap<String, T>();
        protected final Class<T> itemClass;

        public static DefaultMapContext<Object> newDefaultMapContext() {
            return new DefaultMapContext<Object>(Object.class);
        }

        public DefaultMapContext(Class<T> itemClass) {
            this.itemClass = itemClass;
        }

        @Override
        public Class<T> getScalarType() {
            return this.itemClass;
        }

        @Override
        public void add(String name, Object value) {
            this.result.put(name, value);
        }

        @Override
        public Map<String, T> getResult() {
            return this.result;
        }

        @Override
        public void writeValue(Map<String, T> value, WritingMechanism mech) {
            if (UndefinedValuesUtils.isUndefined(value)) {
                return;
            }
            mech.writeMapping(() -> {
                TreeMap<String, Object> sortedMap = new TreeMap<String, Object>(value);
                sortedMap.forEach((key, val) -> mech.writePair((String)key, () -> this.getContext((String)key, val).writeValue(val, mech)));
            });
        }

        @Override
        public BlockContext<T> getContext(String nameOfSubcontext) {
            return null;
        }

        private BlockContext getContext(String nameOfSubcontext, Object value) {
            BlockContext<T> res = this.getContext(nameOfSubcontext);
            if (res != null) {
                return res;
            }
            if (value instanceof Collection) {
                return new DefaultListContext<T>(this.itemClass);
            }
            if (value instanceof Map) {
                return DefaultMapContext.newDefaultMapContext();
            }
            return new DefaultObjectContext<T>(this.itemClass);
        }
    }

    public static class DefaultListContext<T>
    implements BlockContext<Collection<T>> {
        private final List<T> result = new LinkedList<T>();
        protected final Class<T> itemClass;

        public static DefaultListContext<Object> newDefaultListContext() {
            return new DefaultListContext<Object>(Object.class);
        }

        public DefaultListContext(Class<T> itemClass) {
            this.itemClass = itemClass;
        }

        @Override
        public Class<T> getScalarType() {
            return this.itemClass;
        }

        @Override
        public void add(Object value) {
            this.result.add(CastUtils.cast((Object)value, this.itemClass));
        }

        @Override
        public List<T> getResult() {
            return this.result;
        }

        @Override
        public void writeValue(Collection<T> value, WritingMechanism mech) {
            if (UndefinedValuesUtils.isUndefined(value)) {
                return;
            }
            mech.writeSequence(() -> value.forEach(v -> this.getContextByValue(v).writeValue(v, mech)));
        }

        @Override
        public BlockContext<?> getContext(String nameOfSubcontext) {
            return null;
        }

        private BlockContext getContextByValue(Object value) {
            BlockContext<?> res = this.getContext("$@[]@$");
            if (res != null) {
                return res;
            }
            if (value instanceof Collection) {
                return new DefaultListContext<T>(this.itemClass);
            }
            if (value instanceof Map) {
                return DefaultMapContext.newDefaultMapContext();
            }
            return new DefaultObjectContext<T>(this.itemClass);
        }
    }

    public static class DefaultObjectContext<T>
    implements BlockContext<T> {
        private final Class<T> objectType;
        private T result;

        public DefaultObjectContext(Class<T> objectType) {
            this.objectType = objectType;
        }

        public static DefaultObjectContext<Object> newDefaultObjectContext() {
            return new DefaultObjectContext<Object>(Object.class);
        }

        @Override
        public Class<T> getScalarType() {
            return this.objectType;
        }

        @Override
        public void add(Object value) {
            this.result = value;
        }

        @Override
        public T getResult() {
            return this.result;
        }

        @Override
        public void writeValue(Object value, WritingMechanism mech) {
            if (UndefinedValuesUtils.isUndefined((Object)value)) {
                return;
            }
            mech.writeObject(value);
        }

        @Override
        public BlockContext<?> getContext(String nameOfSubcontext) {
            return null;
        }
    }
}

