/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.mysql.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.utility.DockerImageName;

public class MySQLDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(MySQLDevServicesProcessor.class);
    public static final String MY_CNF_CONFIG_OVERRIDE_PARAM_NAME = "TC_MY_CNF";

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupMysql(final List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem) {
        return new DevServicesDatasourceProviderBuildItem("mysql", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, DevServicesDatasourceContainerConfig containerConfig, LaunchMode launchMode, Optional<Duration> startupTimeout) {
                QuarkusMySQLContainer container = new QuarkusMySQLContainer(containerConfig.getImageName(), containerConfig.getFixedExposedPort(), !devServicesSharedNetworkBuildItem.isEmpty());
                startupTimeout.ifPresent(arg_0 -> ((QuarkusMySQLContainer)container).withStartupTimeout(arg_0));
                String effectiveUsername = containerConfig.getUsername().orElse(username.orElse("quarkus"));
                String effectivePassword = containerConfig.getPassword().orElse(password.orElse("quarkus"));
                String effectiveDbName = containerConfig.getDbName().orElse(datasourceName.orElse("quarkus"));
                container.withUsername(effectiveUsername).withPassword(effectivePassword).withDatabaseName(effectiveDbName).withReuse(true);
                if (containerConfig.getContainerProperties().containsKey(MySQLDevServicesProcessor.MY_CNF_CONFIG_OVERRIDE_PARAM_NAME)) {
                    container.withConfigurationOverride((String)containerConfig.getContainerProperties().get(MySQLDevServicesProcessor.MY_CNF_CONFIG_OVERRIDE_PARAM_NAME));
                }
                containerConfig.getAdditionalJdbcUrlProperties().forEach((arg_0, arg_1) -> ((QuarkusMySQLContainer)container).withUrlParam(arg_0, arg_1));
                containerConfig.getCommand().ifPresent(arg_0 -> ((QuarkusMySQLContainer)container).setCommand(arg_0));
                container.start();
                LOG.info((Object)"Dev Services for MySQL started.");
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getContainerId(), container.getEffectiveJdbcUrl(), container.getReactiveUrl(), container.getUsername(), container.getPassword(), (Closeable)new ContainerShutdownCloseable((GenericContainer)container, "MySQL"));
            }
        });
    }

    private static class QuarkusMySQLContainer
    extends MySQLContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusMySQLContainer(Optional<String> imageName, OptionalInt fixedExposedPort, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName.orElseGet(() -> ConfigureUtil.getDefaultImageNameFor((String)"mysql"))).asCompatibleSubstituteFor(DockerImageName.parse((String)"mysql")));
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"mssql");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), MySQLContainer.MYSQL_PORT);
            } else {
                this.addExposedPort(MYSQL_PORT);
            }
        }

        public String getEffectiveJdbcUrl() {
            if (this.useSharedNetwork) {
                String additionalUrlParams = this.constructUrlParameters("?", "&");
                return "jdbc:mysql://" + this.hostName + ":" + MYSQL_PORT + "/" + this.getDatabaseName() + additionalUrlParams;
            }
            return super.getJdbcUrl();
        }

        public String getReactiveUrl() {
            return this.getEffectiveJdbcUrl().replaceFirst("jdbc:", "vertx-reactive:");
        }
    }
}

