/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.sql.Datum;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public abstract class OracleNamedType
extends OracleType
implements Serializable {
    transient OracleConnection connection;
    SQLName sqlName = null;
    transient OracleTypeADT parent = null;
    transient int idx;
    transient TypeDescriptor descriptor = null;
    String typeNameByUser;
    static String getUserTypeTreeSql = "select level depth, parent_type, child_type, ATTR_NO, child_type_owner from  (select TYPE_NAME parent_type, ELEM_TYPE_NAME child_type, 0 ATTR_NO,       ELEM_TYPE_OWNER child_type_owner     from USER_COLL_TYPES  union   select TYPE_NAME parent_type, ATTR_TYPE_NAME child_type, ATTR_NO,       ATTR_TYPE_OWNER child_type_owner     from USER_TYPE_ATTRS  ) start with parent_type  = ?  connect by prior  child_type = parent_type";
    String sqlHint = null;
    static String getAllTypeTreeSql = "select parent_type, parent_type_owner, child_type, ATTR_NO, child_type_owner from ( select TYPE_NAME parent_type,  OWNER parent_type_owner,     ELEM_TYPE_NAME child_type, 0 ATTR_NO,     ELEM_TYPE_OWNER child_type_owner   from ALL_COLL_TYPES union   select TYPE_NAME parent_type, OWNER parent_type_owner,     ATTR_TYPE_NAME child_type, ATTR_NO,     ATTR_TYPE_OWNER child_type_owner   from ALL_TYPE_ATTRS ) start with parent_type  = ?  and parent_type_owner = ? connect by prior child_type = parent_type   and ( child_type_owner = parent_type_owner or child_type_owner is null )";

    protected OracleNamedType() {
    }

    public OracleNamedType(String string, OracleConnection oracleConnection) throws SQLException {
        this.setConnectionInternal(oracleConnection);
        this.typeNameByUser = string;
        this.sqlName = new SQLName(string, oracleConnection);
    }

    protected OracleNamedType(OracleTypeADT oracleTypeADT, int n2, OracleConnection oracleConnection) {
        this.setConnectionInternal(oracleConnection);
        this.parent = oracleTypeADT;
        this.idx = n2;
    }

    public String getFullName() throws SQLException {
        return this.getFullName(false);
    }

    public String getFullName(boolean bl) throws SQLException {
        String string = null;
        if (bl || this.sqlName == null) {
            if (this.parent != null && (string = this.parent.getAttributeType(this.idx)) != null) {
                this.sqlName = new SQLName(string, this.connection);
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to resolve name").fillInStackTrace();
            }
        }
        return this.sqlName.getName();
    }

    public String getSchemaName() throws SQLException {
        if (this.sqlName == null) {
            this.getFullName();
        }
        return this.sqlName.getSchema();
    }

    public String getSimpleName() throws SQLException {
        if (this.sqlName == null) {
            this.getFullName();
        }
        return this.sqlName.getSimpleName();
    }

    public boolean hasName() throws SQLException {
        return this.sqlName != null;
    }

    public OracleTypeADT getParent() throws SQLException {
        return this.parent;
    }

    public void setParent(OracleTypeADT oracleTypeADT) throws SQLException {
        this.parent = oracleTypeADT;
    }

    public int getOrder() throws SQLException {
        return this.idx;
    }

    public void setOrder(int n2) throws SQLException {
        this.idx = n2;
    }

    public OracleConnection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.setConnectionInternal(oracleConnection);
    }

    public void setConnectionInternal(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    public Datum unlinearize(byte[] byArray, long l2, Datum datum, int n2, Map map) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    public Datum unlinearize(byte[] byArray, long l2, Datum datum, long l3, int n2, int n3, Map map) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    public byte[] linearize(Datum datum) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    public TypeDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    public void setDescriptor(TypeDescriptor typeDescriptor) throws SQLException {
        this.descriptor = typeDescriptor;
    }

    public int getTypeVersion() {
        return 1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.writeUTF(this.getFullName());
        }
        catch (SQLException sQLException) {
            throw (IOException)DatabaseError.createIOException(sQLException).fillInStackTrace();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = objectInputStream.readUTF();
        try {
            this.sqlName = new SQLName(string, null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.parent = null;
        this.idx = -1;
    }

    public void fixupConnection(OracleConnection oracleConnection) throws SQLException {
        if (this.connection == null) {
            this.setConnection(oracleConnection);
        }
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        this.printXML(printWriter, n2, false);
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        for (int i2 = 0; i2 < n2; ++i2) {
            printWriter.print("  ");
        }
        printWriter.println("<OracleNamedType/>");
    }

    @Override
    public void initNamesRecursively() throws SQLException {
        Map map = this.createTypesTreeMap();
        if (map.size() > 0) {
            this.initChildNamesRecursively(map);
        }
    }

    @Override
    public void setNames(String string, String string2) throws SQLException {
        this.sqlName = new SQLName(string, string2, this.connection);
    }

    public void setSqlName(SQLName sQLName) {
        this.sqlName = sQLName;
    }

    public Map createTypesTreeMap() throws SQLException {
        Map map = null;
        String string = this.connection.getDefaultSchemaNameForNamedTypes();
        if (this.sqlName.getSchema().equals(string)) {
            map = this.getNodeMapFromUserTypes();
        }
        if (map == null) {
            map = this.getNodeMapFromAllTypes();
        }
        return map;
    }

    String getSqlHint() throws SQLException {
        if (this.sqlHint == null) {
            this.sqlHint = this.connection.getVersionNumber() >= 11000 ? "" : "/*+RULE*/";
        }
        return this.sqlHint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getNodeMapFromUserTypes() throws SQLException {
        HashMap<SQLName, TypeTreeElement> hashMap = new HashMap<SQLName, TypeTreeElement>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        this.connection.beginNonRequestCalls();
        try {
            preparedStatement = this.connection.prepareStatement(this.getSqlHint() + getUserTypeTreeSql);
            preparedStatement.setString(1, this.sqlName.getSimpleName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                int n3 = resultSet.getInt(4);
                String string3 = resultSet.getString(5);
                if (string3 != null && !string3.equals(this.sqlName.getSchema())) {
                    hashMap = null;
                    break;
                }
                if (string.length() <= 0) continue;
                SQLName sQLName = new SQLName(this.sqlName.getSchema(), string, this.connection);
                TypeTreeElement typeTreeElement = null;
                if (hashMap.containsKey(sQLName)) {
                    typeTreeElement = (TypeTreeElement)hashMap.get(sQLName);
                } else {
                    typeTreeElement = new TypeTreeElement(this.sqlName.getSchema(), string);
                    hashMap.put(sQLName, typeTreeElement);
                }
                typeTreeElement.putChild(this.sqlName.getSchema(), string2, n3);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            this.connection.endNonRequestCalls();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getNodeMapFromAllTypes() throws SQLException {
        HashMap<SQLName, TypeTreeElement> hashMap = new HashMap<SQLName, TypeTreeElement>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        this.connection.beginNonRequestCalls();
        try {
            preparedStatement = this.connection.prepareStatement(this.getSqlHint() + getAllTypeTreeSql);
            preparedStatement.setString(1, this.sqlName.getSimpleName());
            preparedStatement.setString(2, this.sqlName.getSchema());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                int n2 = resultSet.getInt(4);
                String string4 = resultSet.getString(5);
                if (string4 == null) {
                    string4 = "SYS";
                }
                if (string.length() <= 0) continue;
                SQLName sQLName = new SQLName(string2, string, this.connection);
                TypeTreeElement typeTreeElement = null;
                if (hashMap.containsKey(sQLName)) {
                    typeTreeElement = (TypeTreeElement)hashMap.get(sQLName);
                } else {
                    typeTreeElement = new TypeTreeElement(string2, string);
                    hashMap.put(sQLName, typeTreeElement);
                }
                typeTreeElement.putChild(string4, string3, n2);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            this.connection.endNonRequestCalls();
        }
        return hashMap;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

