/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SAMLEncryptionAlgorithms {
    RSA_OAEP("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "RSA-OAEP"),
    RSA1_5("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "RSA1_5");

    private String xmlEncIdentifier;
    private String keycloakIdentifier;
    private static final Map<String, SAMLEncryptionAlgorithms> forXMLEncIdentifier;
    private static final Map<String, SAMLEncryptionAlgorithms> forKeycloakIdentifier;

    private SAMLEncryptionAlgorithms(String xmlEncIdentifier, String keycloakIdentifier) {
        this.xmlEncIdentifier = xmlEncIdentifier;
        this.keycloakIdentifier = keycloakIdentifier;
    }

    public String getXmlEncIdentifier() {
        return this.xmlEncIdentifier;
    }

    public String getKeycloakIdentifier() {
        return this.keycloakIdentifier;
    }

    public static SAMLEncryptionAlgorithms forXMLEncIdentifier(String xmlEncIdentifier) {
        return forXMLEncIdentifier.get(xmlEncIdentifier);
    }

    public static SAMLEncryptionAlgorithms forKeycloakIdentifier(String keycloakIdentifier) {
        return forKeycloakIdentifier.get(keycloakIdentifier);
    }

    static {
        forXMLEncIdentifier = Arrays.stream(SAMLEncryptionAlgorithms.values()).collect(Collectors.toMap(SAMLEncryptionAlgorithms::getXmlEncIdentifier, Function.identity()));
        forKeycloakIdentifier = Arrays.stream(SAMLEncryptionAlgorithms.values()).collect(Collectors.toMap(SAMLEncryptionAlgorithms::getKeycloakIdentifier, Function.identity()));
    }
}

