/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.build;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.build.IBuildRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class BuildRequest
extends KubernetesResource
implements IBuildRequest {
    private static final String COMMIT = "commit";
    private static final String GIT = "git";
    private static final String BIGGIT = "Git";
    private static final String TYPE = "type";
    private static final String REVISION = "revision";
    private static final String REVISION_GIT_COMMIT = "revision.git.commit";
    private static final String REVISION_TYPE = "revision.type";
    private static final String TRIGGERED_BY = "triggeredBy";
    private static final String MESSAGE = "message";
    private static final String ENV = "env";

    public BuildRequest(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public void setCommitId(String commitId) {
        this.set(REVISION_TYPE, BIGGIT);
        this.set(REVISION_GIT_COMMIT, commitId);
    }

    @Override
    public void addBuildCause(String cause) {
        ModelNode triggeredBys = this.get(TRIGGERED_BY);
        triggeredBys.add(MESSAGE, cause);
    }

    @Override
    public String getCommitId() {
        return this.get(REVISION_GIT_COMMIT).asString();
    }

    @Override
    public List<String> getBuildCauses() {
        List causes = this.get(TRIGGERED_BY).asList();
        ArrayList<String> ret = new ArrayList<String>();
        for (ModelNode cause : causes) {
            ret.add(cause.asString());
        }
        return ret;
    }

    @Override
    public void setEnvironmentVariable(String name, String value) {
        ModelNode envs = this.get(ENV);
        ModelNode entry = envs.add();
        entry.get("name").set(name);
        entry.get("value").set(value);
    }
}

