/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.wildfly.security.http.oidc.ClientCredentialsProvider;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcJsonConfiguration;
import org.wildfly.security.http.oidc.OidcProviderMetadata;
import org.wildfly.security.http.oidc.PublicKeyLocator;
import org.wildfly.security.jose.util.JsonSerialization;

public class OidcClientConfiguration {
    protected RelativeUrlsUsed relativeUrls;
    protected String realm;
    protected PublicKeyLocator publicKeyLocator;
    protected String authServerBaseUrl;
    protected String providerUrl;
    protected String authUrl;
    protected String tokenUrl;
    protected String logoutUrl;
    protected String accountUrl;
    protected String registerNodeUrl;
    protected String unregisterNodeUrl;
    protected String jwksUrl;
    protected String issuerUrl;
    protected String principalAttribute = "sub";
    protected String resource;
    protected String clientId;
    protected boolean bearerOnly;
    protected boolean autodetectBearerOnly;
    protected boolean enableBasicAuth;
    protected boolean publicClient;
    protected Map<String, Object> resourceCredentials = new HashMap<String, Object>();
    protected ClientCredentialsProvider clientAuthenticator;
    protected Callable<HttpClient> client;
    protected String scope;
    protected Oidc.SSLRequired sslRequired = Oidc.SSLRequired.ALL;
    protected int confidentialPort = -1;
    protected Oidc.TokenStore tokenStore = Oidc.TokenStore.SESSION;
    protected String oidcStateCookiePath = "";
    protected String stateCookieName = "OAuth_Token_Request_State";
    protected boolean useResourceRoleMappings;
    protected boolean useRealmRoleMappings;
    protected boolean cors;
    protected int corsMaxAge = -1;
    protected String corsAllowedHeaders;
    protected String corsAllowedMethods;
    protected String corsExposedHeaders;
    protected boolean exposeToken;
    protected boolean alwaysRefreshToken;
    protected boolean registerNodeAtStartup;
    protected int registerNodePeriod;
    protected boolean turnOffChangeSessionIdOnLogin;
    protected volatile int notBefore;
    protected int tokenMinimumTimeToLive;
    protected int minTimeBetweenJwksRequests;
    protected int publicKeyCacheTtl;
    protected boolean pkce = false;
    protected boolean ignoreOAuthQueryParameter;
    protected Map<String, String> redirectRewriteRules;
    protected boolean delegateBearerErrorResponseSending = false;
    protected boolean verifyTokenAudience = false;
    protected String tokenSignatureAlgorithm = "RS256";

    public boolean isConfigured() {
        return this.getResourceName() != null && this.getPublicKeyLocator() != null && (this.isBearerOnly() || this.getAuthServerBaseUrl() != null || this.getProviderUrl() != null);
    }

    public String getResourceName() {
        return this.resource != null ? this.resource : this.clientId;
    }

    public String getResource() {
        return this.resource;
    }

    public String getClientId() {
        return this.clientId != null ? this.clientId : this.resource;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public PublicKeyLocator getPublicKeyLocator() {
        return this.publicKeyLocator;
    }

    public void setPublicKeyLocator(PublicKeyLocator publicKeyLocator) {
        this.publicKeyLocator = publicKeyLocator;
    }

    public String getAuthServerBaseUrl() {
        return this.authServerBaseUrl;
    }

    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
        this.resetUrls();
    }

    public void setAuthServerBaseUrl(OidcJsonConfiguration config) {
        this.authServerBaseUrl = config.getAuthServerUrl();
        this.resetUrls();
    }

    protected void resetUrls() {
        this.authUrl = null;
        this.tokenUrl = null;
        this.logoutUrl = null;
        this.accountUrl = null;
        this.registerNodeUrl = null;
        this.unregisterNodeUrl = null;
        this.jwksUrl = null;
        this.relativeUrls = null;
        if (this.providerUrl != null || this.authServerBaseUrl != null) {
            try {
                URI uri = URI.create(this.providerUrl != null ? this.providerUrl : this.authServerBaseUrl);
                this.relativeUrls = uri.getHost() == null ? RelativeUrlsUsed.ALWAYS : RelativeUrlsUsed.NEVER;
            }
            catch (Exception e) {
                ElytronMessages.log.invalidAuthServerUrlOrProviderUrl(this.providerUrl != null ? this.providerUrl : this.authServerBaseUrl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveUrls() {
        if (this.authUrl == null) {
            OidcClientConfiguration oidcClientConfiguration = this;
            synchronized (oidcClientConfiguration) {
                String discoveryUrl = this.getDiscoveryUrl();
                try {
                    ElytronMessages.log.debug("Loading OpenID provider metadata from " + discoveryUrl);
                    OidcProviderMetadata config = this.getOidcProviderMetadata(discoveryUrl);
                    this.authUrl = config.getAuthorizationEndpoint();
                    this.issuerUrl = config.getIssuer();
                    this.tokenUrl = config.getTokenEndpoint();
                    this.logoutUrl = config.getLogoutEndpoint();
                    this.jwksUrl = config.getJwksUri();
                    if (this.authServerBaseUrl != null) {
                        this.accountUrl = OidcClientConfiguration.getUrl(this.issuerUrl, "account");
                        this.registerNodeUrl = OidcClientConfiguration.getUrl(this.authServerBaseUrl, "realms/" + this.getRealm(), "clients-managements/register-node");
                        this.unregisterNodeUrl = OidcClientConfiguration.getUrl(this.authServerBaseUrl, "realms/" + this.getRealm(), "clients-managements/unregister-node");
                    }
                    ElytronMessages.log.loadedOpenIdProviderMetadata(discoveryUrl);
                }
                catch (Exception e) {
                    ElytronMessages.log.unableToLoadOpenIdProviderMetadata(discoveryUrl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OidcProviderMetadata getOidcProviderMetadata(String discoveryUrl) throws Exception {
        HttpGet request = new HttpGet(discoveryUrl);
        request.addHeader("Accept", "application/json");
        try {
            HttpResponse response = this.getClient().execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw new Exception(response.getStatusLine().getReasonPhrase());
            }
            OidcProviderMetadata oidcProviderMetadata = (OidcProviderMetadata)JsonSerialization.readValue((InputStream)response.getEntity().getContent(), OidcProviderMetadata.class);
            return oidcProviderMetadata;
        }
        finally {
            request.releaseConnection();
        }
    }

    private String getDiscoveryUrl() {
        if (this.providerUrl != null) {
            return OidcClientConfiguration.getUrl(this.providerUrl, ".well-known/openid-configuration");
        }
        if (this.authServerBaseUrl != null) {
            return OidcClientConfiguration.getUrl(this.authServerBaseUrl, "realms/" + this.getRealm(), ".well-known/openid-configuration");
        }
        throw ElytronMessages.log.providerUrlOrAuthServerUrlNeedsToBeConfigured();
    }

    private static String getUrl(String baseUrl, String ... paths) {
        StringBuilder sb = new StringBuilder(baseUrl);
        if (!baseUrl.endsWith("/")) {
            sb.append("/");
        }
        for (int i = 0; i < paths.length; ++i) {
            sb.append(paths[i]);
            if (i == paths.length - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    public RelativeUrlsUsed getRelativeUrls() {
        return this.relativeUrls;
    }

    public String getProviderUrl() {
        if (this.providerUrl == null) {
            this.resolveUrls();
        }
        return this.providerUrl;
    }

    public String getAuthUrl() {
        this.resolveUrls();
        return this.authUrl;
    }

    public String getTokenUrl() {
        this.resolveUrls();
        return this.tokenUrl;
    }

    public String getLogoutUrl() {
        this.resolveUrls();
        return this.logoutUrl;
    }

    public String getAccountUrl() {
        this.resolveUrls();
        return this.accountUrl;
    }

    public String getRegisterNodeUrl() {
        this.resolveUrls();
        return this.registerNodeUrl;
    }

    public String getUnregisterNodeUrl() {
        this.resolveUrls();
        return this.unregisterNodeUrl;
    }

    public String getJwksUrl() {
        this.resolveUrls();
        return this.jwksUrl;
    }

    public String getIssuerUrl() {
        this.resolveUrls();
        return this.issuerUrl;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isBearerOnly() {
        return this.bearerOnly;
    }

    public void setBearerOnly(boolean bearerOnly) {
        this.bearerOnly = bearerOnly;
    }

    public boolean isAutodetectBearerOnly() {
        return this.autodetectBearerOnly;
    }

    public void setAutodetectBearerOnly(boolean autodetectBearerOnly) {
        this.autodetectBearerOnly = autodetectBearerOnly;
    }

    public boolean isEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public void setEnableBasicAuth(boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public void setPublicClient(boolean publicClient) {
        this.publicClient = publicClient;
    }

    public Map<String, Object> getResourceCredentials() {
        return this.resourceCredentials;
    }

    public void setResourceCredentials(Map<String, Object> resourceCredentials) {
        this.resourceCredentials = resourceCredentials;
    }

    public ClientCredentialsProvider getClientAuthenticator() {
        return this.clientAuthenticator;
    }

    public void setClientAuthenticator(ClientCredentialsProvider clientAuthenticator) {
        this.clientAuthenticator = clientAuthenticator;
    }

    public HttpClient getClient() {
        try {
            return this.client.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setClient(final HttpClient client) {
        this.client = new Callable<HttpClient>(){

            @Override
            public HttpClient call() {
                return client;
            }
        };
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Oidc.SSLRequired getSSLRequired() {
        return this.sslRequired;
    }

    public void setSSLRequired(Oidc.SSLRequired sslRequired) {
        this.sslRequired = sslRequired;
    }

    public boolean isSSLEnabled() {
        return Oidc.SSLRequired.NONE != this.sslRequired;
    }

    public int getConfidentialPort() {
        return this.confidentialPort;
    }

    public void setConfidentialPort(int confidentialPort) {
        this.confidentialPort = confidentialPort;
    }

    public Oidc.TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public void setTokenStore(Oidc.TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public String getOidcStateCookiePath() {
        return this.oidcStateCookiePath;
    }

    public void setOidcStateCookiePath(String oidcStateCookiePath) {
        this.oidcStateCookiePath = oidcStateCookiePath;
    }

    public String getStateCookieName() {
        return this.stateCookieName;
    }

    public void setStateCookieName(String stateCookieName) {
        this.stateCookieName = stateCookieName;
    }

    public boolean isUseResourceRoleMappings() {
        return this.useResourceRoleMappings;
    }

    public void setUseResourceRoleMappings(boolean useResourceRoleMappings) {
        this.useResourceRoleMappings = useResourceRoleMappings;
    }

    public boolean isUseRealmRoleMappings() {
        return this.useRealmRoleMappings;
    }

    public void setUseRealmRoleMappings(boolean useRealmRoleMappings) {
        this.useRealmRoleMappings = useRealmRoleMappings;
    }

    public boolean isCors() {
        return this.cors;
    }

    public void setCors(boolean cors) {
        this.cors = cors;
    }

    public int getCorsMaxAge() {
        return this.corsMaxAge;
    }

    public void setCorsMaxAge(int corsMaxAge) {
        this.corsMaxAge = corsMaxAge;
    }

    public String getCorsAllowedHeaders() {
        return this.corsAllowedHeaders;
    }

    public void setCorsAllowedHeaders(String corsAllowedHeaders) {
        this.corsAllowedHeaders = corsAllowedHeaders;
    }

    public String getCorsAllowedMethods() {
        return this.corsAllowedMethods;
    }

    public void setCorsAllowedMethods(String corsAllowedMethods) {
        this.corsAllowedMethods = corsAllowedMethods;
    }

    public String getCorsExposedHeaders() {
        return this.corsExposedHeaders;
    }

    public void setCorsExposedHeaders(String corsExposedHeaders) {
        this.corsExposedHeaders = corsExposedHeaders;
    }

    public boolean isExposeToken() {
        return this.exposeToken;
    }

    public void setExposeToken(boolean exposeToken) {
        this.exposeToken = exposeToken;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(int notBefore) {
        this.notBefore = notBefore;
    }

    public void updateNotBefore(int notBefore) {
        this.notBefore = notBefore;
        this.getPublicKeyLocator().reset(this);
    }

    public boolean isAlwaysRefreshToken() {
        return this.alwaysRefreshToken;
    }

    public void setAlwaysRefreshToken(boolean alwaysRefreshToken) {
        this.alwaysRefreshToken = alwaysRefreshToken;
    }

    public boolean isRegisterNodeAtStartup() {
        return this.registerNodeAtStartup;
    }

    public void setRegisterNodeAtStartup(boolean registerNodeAtStartup) {
        this.registerNodeAtStartup = registerNodeAtStartup;
    }

    public int getRegisterNodePeriod() {
        return this.registerNodePeriod;
    }

    public void setRegisterNodePeriod(int registerNodePeriod) {
        this.registerNodePeriod = registerNodePeriod;
    }

    public String getPrincipalAttribute() {
        return this.principalAttribute;
    }

    public void setPrincipalAttribute(String principalAttribute) {
        this.principalAttribute = principalAttribute;
    }

    public boolean isTurnOffChangeSessionIdOnLogin() {
        return this.turnOffChangeSessionIdOnLogin;
    }

    public void setTurnOffChangeSessionIdOnLogin(boolean turnOffChangeSessionIdOnLogin) {
        this.turnOffChangeSessionIdOnLogin = turnOffChangeSessionIdOnLogin;
    }

    public int getTokenMinimumTimeToLive() {
        return this.tokenMinimumTimeToLive;
    }

    public void setTokenMinimumTimeToLive(int tokenMinimumTimeToLive) {
        this.tokenMinimumTimeToLive = tokenMinimumTimeToLive;
    }

    public int getMinTimeBetweenJwksRequests() {
        return this.minTimeBetweenJwksRequests;
    }

    public void setMinTimeBetweenJwksRequests(int minTimeBetweenJwksRequests) {
        this.minTimeBetweenJwksRequests = minTimeBetweenJwksRequests;
    }

    public int getPublicKeyCacheTtl() {
        return this.publicKeyCacheTtl;
    }

    public void setPublicKeyCacheTtl(int publicKeyCacheTtl) {
        this.publicKeyCacheTtl = publicKeyCacheTtl;
    }

    public boolean isPkce() {
        return this.pkce;
    }

    public void setPkce(boolean pkce) {
        this.pkce = pkce;
    }

    public void setIgnoreOAuthQueryParameter(boolean ignoreOAuthQueryParameter) {
        this.ignoreOAuthQueryParameter = ignoreOAuthQueryParameter;
    }

    public boolean isOAuthQueryParameterEnabled() {
        return !this.ignoreOAuthQueryParameter;
    }

    public Map<String, String> getRedirectRewriteRules() {
        return this.redirectRewriteRules;
    }

    public void setRewriteRedirectRules(Map<String, String> redirectRewriteRules) {
        this.redirectRewriteRules = redirectRewriteRules;
    }

    public boolean isDelegateBearerErrorResponseSending() {
        return this.delegateBearerErrorResponseSending;
    }

    public void setDelegateBearerErrorResponseSending(boolean delegateBearerErrorResponseSending) {
        this.delegateBearerErrorResponseSending = delegateBearerErrorResponseSending;
    }

    public boolean isVerifyTokenAudience() {
        return this.verifyTokenAudience;
    }

    public void setVerifyTokenAudience(boolean verifyTokenAudience) {
        this.verifyTokenAudience = verifyTokenAudience;
    }

    public void setClient(Callable<HttpClient> callable) {
        this.client = callable;
    }

    public void setTokenSignatureAlgorithm(String tokenSignatureAlgorithm) {
        this.tokenSignatureAlgorithm = tokenSignatureAlgorithm;
    }

    public String getTokenSignatureAlgorithm() {
        return this.tokenSignatureAlgorithm;
    }

    public static enum RelativeUrlsUsed {
        ALWAYS,
        NEVER;

    }
}

