/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.MessageContext;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.UnknownFieldSet;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.EnumMarshallerDelegate;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.infinispan.protostream.impl.TagReaderImpl;
import org.infinispan.protostream.impl.UnknownFieldSetImpl;
import org.jboss.logging.Logger;

final class ProtoStreamReaderImpl
implements MessageMarshaller.ProtoStreamReader {
    private static final Log log = Log.LogFactory.getLog(ProtoStreamReaderImpl.class);
    private static final EnumSet<Type> primitiveTypes = EnumSet.of(Type.DOUBLE, new Type[]{Type.FLOAT, Type.INT32, Type.INT64, Type.UINT32, Type.UINT64, Type.FIXED32, Type.FIXED64, Type.BOOL, Type.STRING, Type.BYTES, Type.SFIXED32, Type.SFIXED64, Type.SINT32, Type.SINT64});
    private final boolean logOutOfSequenceReads;
    private final TagReaderImpl ctx;
    private final SerializationContextImpl serCtx;
    private ReadMessageContext messageContext;

    ProtoStreamReaderImpl(TagReaderImpl ctx, SerializationContextImpl serCtx) {
        this.ctx = ctx;
        this.serCtx = serCtx;
        this.logOutOfSequenceReads = serCtx.getConfiguration().logOutOfSequenceReads();
    }

    ReadMessageContext enterContext(FieldDescriptor fd, Descriptor messageDescriptor, TagReaderImpl in) {
        this.messageContext = new ReadMessageContext(this.messageContext, fd, messageDescriptor, in);
        return this.messageContext;
    }

    void exitContext() {
        this.messageContext = (ReadMessageContext)this.messageContext.getParentContext();
    }

    UnknownFieldSet getUnknownFieldSet() {
        return this.messageContext.unknownFieldSet;
    }

    private Object readPrimitive(String fieldName, JavaType javaType) throws IOException {
        int tag;
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        Type type = fd.getType();
        if (type == Type.ENUM || type == Type.GROUP || type == Type.MESSAGE) {
            throw new IllegalArgumentException("Declared field type is not a primitive : " + fd.getFullName());
        }
        if (fd.getJavaType() != javaType) {
            throw new IllegalArgumentException("Declared field type is not of the expected type : " + fd.getFullName());
        }
        this.checkFieldRead(fd, false);
        int expectedTag = fd.getWireTag();
        Object o = this.messageContext.unknownFieldSet.consumeTag(expectedTag);
        if (o != null) {
            return this.convertWireTypeToJavaType(type, o);
        }
        TagReaderImpl in = this.messageContext.in;
        while ((tag = in.readTag()) != 0) {
            if (tag == expectedTag) {
                switch (type) {
                    case DOUBLE: {
                        return in.readDouble();
                    }
                    case FLOAT: {
                        return Float.valueOf(in.readFloat());
                    }
                    case BOOL: {
                        return in.readBool();
                    }
                    case STRING: {
                        return in.readString();
                    }
                    case BYTES: {
                        return in.readByteArray();
                    }
                    case INT32: {
                        return in.readInt32();
                    }
                    case SFIXED32: {
                        return in.readSFixed32();
                    }
                    case FIXED32: {
                        return in.readFixed32();
                    }
                    case UINT32: {
                        return in.readUInt32();
                    }
                    case SINT32: {
                        return in.readSInt32();
                    }
                    case INT64: {
                        return in.readInt64();
                    }
                    case UINT64: {
                        return in.readUInt64();
                    }
                    case FIXED64: {
                        return in.readFixed64();
                    }
                    case SFIXED64: {
                        return in.readSFixed64();
                    }
                    case SINT64: {
                        return in.readSInt64();
                    }
                }
                throw new IOException("Unexpected field type : " + (Object)((Object)type));
            }
            this.messageContext.unknownFieldSet.readSingleField(tag, in);
        }
        if (fd.hasDefaultValue()) {
            return fd.getDefaultValue();
        }
        if (fd.isRequired()) {
            throw new IOException("Field " + fd.getFullName() + " is required but is not present in the stream");
        }
        return null;
    }

    private Object convertWireTypeToJavaType(Type type, Object o) {
        switch (type) {
            case STRING: {
                o = new String((byte[])o, StandardCharsets.UTF_8);
                break;
            }
            case BYTES: {
                o = (byte[])o;
                break;
            }
            case INT32: 
            case UINT32: 
            case SINT32: {
                o = ((Long)o).intValue();
                break;
            }
            case SFIXED32: 
            case FIXED32: {
                o = (Integer)o;
                break;
            }
            case INT64: 
            case UINT64: 
            case FIXED64: 
            case SFIXED64: 
            case SINT64: {
                o = (Long)o;
                break;
            }
            case BOOL: {
                o = (Long)o != 0L;
                break;
            }
            case FLOAT: {
                o = Float.valueOf(Float.intBitsToFloat((Integer)o));
                break;
            }
            case DOUBLE: {
                o = Double.longBitsToDouble((Long)o);
            }
        }
        return o;
    }

    @Override
    public ImmutableSerializationContext getSerializationContext() {
        return this.serCtx;
    }

    @Override
    public Integer readInt(String fieldName) throws IOException {
        return (Integer)this.readPrimitive(fieldName, JavaType.INT);
    }

    @Override
    public int[] readInts(String fieldName) throws IOException {
        List values = this.readCollection(fieldName, new ArrayList(), Integer.class);
        int[] result = new int[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            result[i] = (Integer)values.get(i);
        }
        return result;
    }

    @Override
    public Long readLong(String fieldName) throws IOException {
        return (Long)this.readPrimitive(fieldName, JavaType.LONG);
    }

    @Override
    public long[] readLongs(String fieldName) throws IOException {
        List values = this.readCollection(fieldName, new ArrayList(), Long.class);
        long[] result = new long[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            result[i] = (Long)values.get(i);
        }
        return result;
    }

    @Override
    public Date readDate(String fieldName) throws IOException {
        Long tstamp = this.readLong(fieldName);
        return tstamp == null ? null : new Date(tstamp);
    }

    @Override
    public Instant readInstant(String fieldName) throws IOException {
        Long tstamp = this.readLong(fieldName);
        return tstamp == null ? null : Instant.ofEpochMilli(tstamp);
    }

    @Override
    public Float readFloat(String fieldName) throws IOException {
        return (Float)this.readPrimitive(fieldName, JavaType.FLOAT);
    }

    @Override
    public float[] readFloats(String fieldName) throws IOException {
        List values = this.readCollection(fieldName, new ArrayList(), Float.class);
        float[] result = new float[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            result[i] = ((Float)values.get(i)).floatValue();
        }
        return result;
    }

    @Override
    public Double readDouble(String fieldName) throws IOException {
        return (Double)this.readPrimitive(fieldName, JavaType.DOUBLE);
    }

    @Override
    public double[] readDoubles(String fieldName) throws IOException {
        List values = this.readCollection(fieldName, new ArrayList(), Double.class);
        double[] result = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            result[i] = (Double)values.get(i);
        }
        return result;
    }

    @Override
    public Boolean readBoolean(String fieldName) throws IOException {
        return (Boolean)this.readPrimitive(fieldName, JavaType.BOOLEAN);
    }

    @Override
    public boolean[] readBooleans(String fieldName) throws IOException {
        List values = this.readCollection(fieldName, new ArrayList(), Boolean.class);
        boolean[] result = new boolean[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            result[i] = (Boolean)values.get(i);
        }
        return result;
    }

    @Override
    public String readString(String fieldName) throws IOException {
        return (String)this.readPrimitive(fieldName, JavaType.STRING);
    }

    @Override
    public byte[] readBytes(String fieldName) throws IOException {
        return (byte[])this.readPrimitive(fieldName, JavaType.BYTE_STRING);
    }

    @Override
    public InputStream readBytesAsInputStream(String fieldName) throws IOException {
        byte[] bytes = this.readBytes(fieldName);
        return bytes != null ? new ByteArrayInputStream(bytes) : null;
    }

    @Override
    public <E extends Enum<E>> E readEnum(String fieldName, Class<E> clazz) throws IOException {
        return (E)((Enum)this.readObject(fieldName, clazz));
    }

    @Override
    public <E> E readObject(String fieldName, Class<E> clazz) throws IOException {
        int tag;
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldRead(fd, false);
        if (fd.getType() == Type.ENUM) {
            return (E)this.serCtx.getMarshallerDelegate(clazz).unmarshall(this.ctx, fd);
        }
        int expectedTag = fd.getWireTag();
        Object o = this.messageContext.unknownFieldSet.consumeTag(expectedTag);
        if (o != null) {
            byte[] byteArray = (byte[])o;
            TagReaderImpl nested = TagReaderImpl.newNestedInstance((ProtobufTagMarshaller.ReadContext)this.messageContext.in, byteArray);
            return this.readNestedObject(fd, clazz, nested, byteArray.length);
        }
        while ((tag = this.messageContext.in.readTag()) != 0) {
            if (tag == expectedTag) {
                return this.readNestedObject(fd, clazz, this.messageContext.in, -1);
            }
            this.messageContext.unknownFieldSet.readSingleField(tag, this.messageContext.in);
        }
        return null;
    }

    private <A> A readNestedObject(FieldDescriptor fd, Class<A> clazz, ProtobufTagMarshaller.ReadContext ctx, int length) throws IOException {
        Class<A> a;
        BaseMarshallerDelegate<Class<A>> marshallerDelegate = this.serCtx.getMarshallerDelegate(clazz);
        TagReader in = ctx.getReader();
        if (fd.getType() == Type.GROUP) {
            a = marshallerDelegate.unmarshall(ctx, fd);
            in.checkLastTagWas(WireType.makeTag(fd.getNumber(), 4));
        } else if (fd.getType() == Type.MESSAGE) {
            if (length < 0) {
                length = in.readUInt32();
            }
            int oldLimit = in.pushLimit(length);
            a = marshallerDelegate.unmarshall(ctx, fd);
            in.checkLastTagWas(0);
            in.popLimit(oldLimit);
        } else {
            throw new IllegalArgumentException("Declared field type is not a message or an enum : " + fd.getFullName());
        }
        return (A)a;
    }

    @Override
    public <E, C extends Collection<? super E>> C readCollection(String fieldName, C collection, Class<E> elementClass) throws IOException {
        int tag;
        Object o;
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldRead(fd, true);
        if (primitiveTypes.contains((Object)fd.getType())) {
            this.readPrimitiveCollection(fd, collection, elementClass);
            return collection;
        }
        int expectedTag = fd.getWireTag();
        EnumMarshallerDelegate enumMarshallerDelegate = fd.getType() == Type.ENUM ? (EnumMarshallerDelegate)this.serCtx.getMarshallerDelegate(elementClass) : null;
        while ((o = this.messageContext.unknownFieldSet.consumeTag(expectedTag)) != null) {
            Object e;
            if (enumMarshallerDelegate != null) {
                int enumValue = ((Number)o).intValue();
                e = enumMarshallerDelegate.decode(expectedTag, enumValue, this.messageContext.unknownFieldSet);
            } else {
                byte[] nestedMessageBytes = (byte[])o;
                TagReaderImpl in = TagReaderImpl.newNestedInstance((ProtobufTagMarshaller.ReadContext)this.messageContext.in, nestedMessageBytes);
                e = this.readNestedObject(fd, elementClass, in, nestedMessageBytes.length);
            }
            collection.add(e);
        }
        while ((tag = this.messageContext.in.readTag()) != 0) {
            if (tag == expectedTag) {
                collection.add(this.readNestedObject(fd, elementClass, this.messageContext.in, -1));
                continue;
            }
            this.messageContext.unknownFieldSet.readSingleField(tag, this.messageContext.in);
        }
        return collection;
    }

    private void readPrimitiveCollection(FieldDescriptor fd, Collection<? super Object> collection, Class<?> elementClass) throws IOException {
        int tag;
        Object o;
        int expectedTag = fd.getWireTag();
        Type type = fd.getType();
        while ((o = this.messageContext.unknownFieldSet.consumeTag(expectedTag)) != null) {
            collection.add(this.convertWireTypeToJavaType(type, o));
        }
        while ((tag = this.messageContext.in.readTag()) != 0) {
            if (tag == expectedTag) {
                Object value;
                switch (type) {
                    case DOUBLE: {
                        value = this.messageContext.in.readDouble();
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(this.messageContext.in.readFloat());
                        break;
                    }
                    case BOOL: {
                        value = this.messageContext.in.readBool();
                        break;
                    }
                    case STRING: {
                        value = this.messageContext.in.readString();
                        break;
                    }
                    case BYTES: {
                        value = this.messageContext.in.readByteArray();
                        break;
                    }
                    case INT64: {
                        value = this.messageContext.in.readInt64();
                        break;
                    }
                    case UINT64: {
                        value = this.messageContext.in.readUInt64();
                        break;
                    }
                    case FIXED64: {
                        value = this.messageContext.in.readFixed64();
                        break;
                    }
                    case SFIXED64: {
                        value = this.messageContext.in.readSFixed64();
                        break;
                    }
                    case SINT64: {
                        value = this.messageContext.in.readSInt64();
                        break;
                    }
                    case INT32: {
                        value = this.messageContext.in.readInt32();
                        break;
                    }
                    case FIXED32: {
                        value = this.messageContext.in.readFixed32();
                        break;
                    }
                    case UINT32: {
                        value = this.messageContext.in.readUInt32();
                        break;
                    }
                    case SFIXED32: {
                        value = this.messageContext.in.readSFixed32();
                        break;
                    }
                    case SINT32: {
                        value = this.messageContext.in.readSInt32();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected field type : " + (Object)((Object)type));
                    }
                }
                collection.add(value);
                continue;
            }
            this.messageContext.unknownFieldSet.readSingleField(tag, this.messageContext.in);
        }
    }

    @Override
    public <E> E[] readArray(String fieldName, Class<? extends E> elementClass) throws IOException {
        List values = this.readCollection(fieldName, new ArrayList(), elementClass);
        return values.toArray((Object[])Array.newInstance(elementClass, values.size()));
    }

    private void checkFieldRead(FieldDescriptor fd, boolean expectRepeated) {
        if (expectRepeated) {
            if (!fd.isRepeated()) {
                throw new IllegalArgumentException("This field is not repeated and cannot be read with the methods intended for collections or arrays: " + fd.getFullName());
            }
        } else if (fd.isRepeated()) {
            throw new IllegalArgumentException("A repeated field should be read with one of the methods intended for collections or arrays: " + fd.getFullName());
        }
        if (!this.messageContext.markField(fd.getNumber())) {
            throw new IllegalStateException("A field cannot be read twice : " + fd.getFullName());
        }
        if (this.logOutOfSequenceReads && log.isEnabled(Logger.Level.WARN) && this.messageContext.getMaxSeenFieldNumber() > fd.getNumber()) {
            log.fieldReadOutOfSequence(fd.getFullName());
        }
    }

    static final class ReadMessageContext
    extends MessageContext<ReadMessageContext> {
        final TagReaderImpl in;
        final UnknownFieldSet unknownFieldSet = new UnknownFieldSetImpl();

        ReadMessageContext(ReadMessageContext parent, FieldDescriptor fieldDescriptor, Descriptor messageDescriptor, TagReaderImpl in) {
            super(parent, fieldDescriptor, messageDescriptor);
            this.in = in;
        }
    }
}

