/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.keycloak.utils.StringUtil;
import picocli.CommandLine;

public class OptionRenderer
implements CommandLine.Help.IOptionRenderer {
    private static final String OPTION_NAME_SEPARATOR = ", ";
    private static final CommandLine.Help.Ansi.Text EMPTY_TEXT = CommandLine.Help.Ansi.OFF.text("");

    public CommandLine.Help.Ansi.Text[][] render(CommandLine.Model.OptionSpec option, CommandLine.Help.IParamLabelRenderer paramLabelRenderer, CommandLine.Help.ColorScheme scheme) {
        String[] names = option.names();
        if (names.length > 2) {
            throw new CommandLine.PicocliException("Options should have 2 names at most.");
        }
        CommandLine.Help.Ansi.Text shortName = names.length > 1 ? scheme.optionText(names[0]) : EMPTY_TEXT;
        CommandLine.Help.Ansi.Text longName = this.createLongName(option, scheme);
        CommandLine.Help.Ansi.Text[][] result = new CommandLine.Help.Ansi.Text[1][];
        String[] descriptions = option.description();
        if (descriptions.length > 1) {
            throw new CommandLine.PicocliException("Option[" + option + "] description should have a single line.");
        }
        CommandLine.Help.Ansi.Text description = this.formatDescription(descriptions, option, scheme);
        result[0] = EMPTY_TEXT.equals((Object)shortName) ? new CommandLine.Help.Ansi.Text[]{longName, description} : new CommandLine.Help.Ansi.Text[]{shortName.concat(OPTION_NAME_SEPARATOR).concat(longName), description};
        return result;
    }

    private CommandLine.Help.Ansi.Text formatDescription(String[] descriptions, CommandLine.Model.OptionSpec option, CommandLine.Help.ColorScheme scheme) {
        List expectedValues;
        Object description = descriptions[0];
        String defaultValue = option.defaultValue();
        Iterable completionCandidates = option.completionCandidates();
        if (!option.type().equals(Boolean.class) && completionCandidates != null && !(expectedValues = StreamSupport.stream(completionCandidates.spliterator(), false).collect(Collectors.toList())).isEmpty()) {
            description = (String)description + " Possible values are: " + String.join((CharSequence)OPTION_NAME_SEPARATOR, expectedValues) + ".";
        }
        if (defaultValue != null) {
            description = (String)description + " Default: " + defaultValue + ".";
        }
        return scheme.text((String)description);
    }

    private CommandLine.Help.Ansi.Text createLongName(CommandLine.Model.OptionSpec option, CommandLine.Help.ColorScheme scheme) {
        CommandLine.Help.Ansi.Text name = scheme.optionText(option.longestName());
        String paramLabel = this.formatParamLabel(option);
        if (StringUtil.isNotBlank((String)paramLabel) && !"none".equals(paramLabel) && !option.usageHelp() && !option.versionHelp()) {
            name = name.concat(" ").concat(paramLabel);
        }
        return name;
    }

    private String formatParamLabel(CommandLine.Model.OptionSpec option) {
        String label = option.paramLabel();
        if (label.startsWith("<") || "none".equals(label)) {
            return label;
        }
        return "<" + label + ">";
    }
}

