/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.logging;

import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.infinispan.commons.util.Util;
import org.infinispan.server.hotrod.AccessLoggingHeader;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.util.logging.LogFactory;
import org.jboss.logging.Logger;
import org.jboss.logging.MDC;

public class HotRodAccessLogging {
    private static final Logger log = LogFactory.getLogger((String)"HOTROD_ACCESS_LOG");

    public static boolean isEnabled() {
        return log.isTraceEnabled();
    }

    public void logOK(ChannelFuture future, AccessLoggingHeader header, int responseBytes) {
        this.logAfterComplete(future, header, responseBytes, "OK");
    }

    public void logException(ChannelFuture future, AccessLoggingHeader header, String exception, int responseBytes) {
        this.logAfterComplete(future, header, responseBytes, exception);
    }

    private void logAfterComplete(ChannelFuture future, AccessLoggingHeader header, int responseBytes, String status) {
        String remoteAddress = ((InetSocketAddress)future.channel().remoteAddress()).getHostString();
        future.addListener(f -> {
            long duration = header.requestStart == null ? -1L : ChronoUnit.MILLIS.between(header.requestStart, Instant.now());
            MDC.clear();
            MDC.put((String)"address", (Object)remoteAddress);
            MDC.put((String)"user", (Object)this.checkForNull(header.principalName));
            MDC.put((String)"method", (Object)this.checkForNull((Object)header.getOp()));
            MDC.put((String)"protocol", (Object)this.checkForNull((Object)HotRodVersion.forVersion(header.getVersion())));
            MDC.put((String)"status", (Object)this.checkForNull(status));
            MDC.put((String)"responseSize", (Object)responseBytes);
            MDC.put((String)"requestSize", (Object)header.requestBytes);
            MDC.put((String)"duration", (Object)duration);
            log.tracef("/%s/%s", (Object)this.checkForNull(header.getCacheName()), (Object)this.checkForNull(header.key));
        });
    }

    String checkForNull(Object obj) {
        if (obj == null || obj instanceof String && ((String)obj).isEmpty()) {
            return "-";
        }
        if (obj instanceof byte[]) {
            return Util.printArray((byte[])((byte[])obj));
        }
        return obj.toString();
    }
}

