/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jitsimeet;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceIq;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Domainpart;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.stringprep.XmppStringprepException;

public class ConferenceIqProvider
extends IqProvider<ConferenceIq> {
    public ConferenceIqProvider() {
        ProviderManager.addIQProvider("conference", "http://jitsi.org/protocol/focus", this);
    }

    @Override
    public ConferenceIq parse(XmlPullParser parser, int initialDepth, IqData data2, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ConferenceIq iq;
        String namespace = parser.getNamespace();
        if (!"http://jitsi.org/protocol/focus".equals(namespace)) {
            return null;
        }
        String rootElement = parser.getName();
        if ("conference".equals(rootElement)) {
            String identity;
            String machineUID;
            String sessionId;
            String focusJid;
            String ready;
            iq = new ConferenceIq();
            EntityBareJid room = this.getRoomJid(parser.getAttributeValue("", "room"));
            iq.setRoom(room);
            String vnode = parser.getAttributeValue("", "vnode");
            if (StringUtils.isNotEmpty(vnode)) {
                iq.setVnode(vnode);
            }
            if (StringUtils.isNotEmpty(ready = parser.getAttributeValue("", "ready"))) {
                iq.setReady(Boolean.valueOf(ready));
            }
            if (StringUtils.isNotEmpty(focusJid = parser.getAttributeValue("", "focusjid"))) {
                iq.setFocusJid(focusJid);
            }
            if (StringUtils.isNotEmpty(sessionId = parser.getAttributeValue("", "session-id"))) {
                iq.setSessionId(sessionId);
            }
            if (StringUtils.isNotEmpty(machineUID = parser.getAttributeValue("", "machine-uid"))) {
                iq.setMachineUID(machineUID);
            }
            if (StringUtils.isNotEmpty(identity = parser.getAttributeValue("", "identity"))) {
                iq.setIdentity(identity);
            }
        } else {
            return null;
        }
        ConferenceIq.Property property = null;
        boolean done = false;
        while (!done) {
            switch (parser.next()) {
                case END_ELEMENT: {
                    String name = parser.getName();
                    if (rootElement.equals(name)) {
                        done = true;
                        break;
                    }
                    if (!"property".equals(name) || property == null) break;
                    iq.addProperty(property);
                    property = null;
                    break;
                }
                case START_ELEMENT: {
                    String propValue;
                    String name = parser.getName();
                    if (!"property".equals(name)) break;
                    property = new ConferenceIq.Property();
                    String propName = parser.getAttributeValue("", "name");
                    if (StringUtils.isNotEmpty(propName)) {
                        property.setName(propName);
                    }
                    if (!StringUtils.isNotEmpty(propValue = parser.getAttributeValue("", "value"))) break;
                    property.setValue(propValue);
                }
            }
        }
        return iq;
    }

    private EntityBareJid getRoomJid(String unescapedValue) throws XmppStringprepException {
        int ix = unescapedValue.lastIndexOf("@");
        if (ix == -1) {
            throw new XmppStringprepException(unescapedValue, "wrong room name jid format");
        }
        String domainPart = unescapedValue.substring(ix + 1);
        String localPart = unescapedValue.substring(0, ix);
        if (localPart.contains("@")) {
            throw new XmppStringprepException(unescapedValue, "Localpart must not contain '@'");
        }
        return JidCreate.entityBareFrom(Localpart.from(localPart), Domainpart.from(domainPart));
    }
}

