/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_hu extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "janu\u00e1r",
               "febru\u00e1r",
               "m\u00e1rcius",
               "\u00e1prilis",
               "m\u00e1jus",
               "j\u00fanius",
               "j\u00falius",
               "augusztus",
               "szeptember",
               "okt\u00f3ber",
               "november",
               "december",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "jan.",
               "febr.",
               "m\u00e1rc.",
               "\u00e1pr.",
               "m\u00e1j.",
               "j\u00fan.",
               "j\u00fal.",
               "aug.",
               "szept.",
               "okt.",
               "nov.",
               "dec.",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "J",
               "F",
               "M",
               "\u00c1",
               "M",
               "J",
               "J",
               "A",
               "Sz",
               "O",
               "N",
               "D",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "vas\u00e1rnap",
               "h\u00e9tf\u0151",
               "kedd",
               "szerda",
               "cs\u00fct\u00f6rt\u00f6k",
               "p\u00e9ntek",
               "szombat",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "V",
               "H",
               "K",
               "Sze",
               "Cs",
               "P",
               "Szo",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "V",
               "H",
               "K",
               "Sz",
               "Cs",
               "P",
               "Sz",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "I. negyed\u00e9v",
               "II. negyed\u00e9v",
               "III. negyed\u00e9v",
               "IV. negyed\u00e9v",
            };
        final String[] metaValue_QuarterAbbreviations = new String[] {
               "I. n.\u00e9v",
               "II. n.\u00e9v",
               "III. n.\u00e9v",
               "IV. n.\u00e9v",
            };
        final String[] metaValue_QuarterNarrows = new String[] {
               "I.",
               "II.",
               "III.",
               "IV.",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "de.",
               "du.",
               "\u00e9jf\u00e9l",
               "d\u00e9l",
               "reggel",
               "d\u00e9lel\u0151tt",
               "d\u00e9lut\u00e1n",
               "",
               "este",
               "",
               "\u00e9jjel",
               "hajnal",
            };
        final String[] metaValue_narrow_AmPmMarkers = new String[] {
               "de.",
               "du.",
               "\u00e9jf\u00e9l",
               "d\u00e9l",
               "reggel",
               "de.",
               "du.",
               "",
               "este",
               "",
               "\u00e9jjel",
               "hajnal",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "H:mm:ss zzzz",
               "H:mm:ss z",
               "H:mm:ss",
               "H:mm",
            };
        final String[] metaValue_java_time_buddhist_long_Eras = new String[] {
               "BC",
               "BK",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "G y. MMMM d., EEEE",
               "G y. MMMM d.",
               "G y. MMM d.",
               "GGGGG y. M. d.",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "GGGG y. MMMM d., EEEE",
               "GGGG y. MMMM d.",
               "GGGG y. MMM d.",
               "G y. M. d.",
            };
        final String[] metaValue_java_time_roc_long_Eras = new String[] {
               "R.O.C. el\u0151tt",
               "R.O.C.",
            };
        final String[] metaValue_java_time_islamic_long_Eras = new String[] {
               "",
               "MF",
            };
        final String metaValue_calendarname_gregorian = "Gergely-napt\u00e1r";
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\u00e9v" },
            { "calendarname.islamic-umalqura", "Iszl\u00e1m Umm al-Qura napt\u00e1r" },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.narrow.Eras", metaValue_java_time_buddhist_long_Eras },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.japanese.DatePatterns",
                new String[] {
                    "G y. MMMM d., EEEE",
                    "G y. MMMM d.",
                    "G y.MM.dd.",
                    "GGGGG y.MM.dd.",
                }
            },
            { "standalone.QuarterAbbreviations",
                new String[] {
                    "1. n.\u00e9v",
                    "2. n.\u00e9v",
                    "3. n.\u00e9v",
                    "4. n.\u00e9v",
                }
            },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "calendarname.islamic-civil", "Iszl\u00e1m civil napt\u00e1r" },
            { "islamic.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "narrow.Eras",
                new String[] {
                    "ie.",
                    "isz.",
                }
            },
            { "abbreviated.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "timezone.regionFormat.standard", "{0} z\u00f3naid\u0151" },
            { "japanese.abbreviated.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "calendarname.japanese", "Jap\u00e1n napt\u00e1r" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "java.time.islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "long.Eras",
                new String[] {
                    "Krisztus el\u0151tt",
                    "id\u0151sz\u00e1m\u00edt\u00e1sunk szerint",
                }
            },
            { "roc.QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ",",
                    "\u00a0",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns",
                new String[] {
                    "GGGG y. MMMM d., EEEE",
                    "GGGG y. MMMM d.",
                    "GGGG y.MM.dd.",
                    "G y.MM.dd.",
                }
            },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "perc" },
            { "field.era", "\u00e9ra" },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "field.dayperiod", "napszak" },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.MonthNames",
                new String[] {
                    "Moharrem",
                    "Safar",
                    "R\u00e9bi el avvel",
                    "R\u00e9bi el accher",
                    "Dsem\u00e1di el avvel",
                    "Dsem\u00e1di el accher",
                    "Redseb",
                    "Sab\u00e1n",
                    "Ramad\u00e1n",
                    "Sevv\u00e1l",
                    "Ds\u00fcl kade",
                    "Ds\u00fcl hedse",
                    "",
                }
            },
            { "japanese.QuarterNarrows", metaValue_QuarterNarrows },
            { "calendarname.roc", "K\u00ednai k\u00f6zt\u00e1rsas\u00e1gi napt\u00e1r" },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "field.month", "h\u00f3nap" },
            { "roc.Eras", metaValue_java_time_roc_long_Eras },
            { "field.second", "m\u00e1sodperc" },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "calendarname.islamic", "Iszl\u00e1m napt\u00e1r" },
            { "java.time.roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "DayPeriodRules", "midnight:00:00;noon:12:00;night1:21:00-04:00;morning2:09:00-12:00;afternoon1:12:00-18:00;morning1:06:00-09:00;evening1:18:00-21:00;night2:04:00-06:00" },
            { "java.time.roc.narrow.Eras", metaValue_java_time_roc_long_Eras },
            { "japanese.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "timezone.regionFormat", "{0} id\u0151" },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0' 'ezer other:0' 'ezer}",
                    "{one:00' 'ezer other:00' 'ezer}",
                    "{one:000' 'ezer other:000' 'ezer}",
                    "{one:0' 'milli\u00f3 other:0' 'milli\u00f3}",
                    "{one:00' 'milli\u00f3 other:00' 'milli\u00f3}",
                    "{one:000' 'milli\u00f3 other:000' 'milli\u00f3}",
                    "{one:0' 'milli\u00e1rd other:0' 'milli\u00e1rd}",
                    "{one:00' 'milli\u00e1rd other:00' 'milli\u00e1rd}",
                    "{one:000' 'milli\u00e1rd other:000' 'milli\u00e1rd}",
                    "{one:0' 'billi\u00f3 other:0' 'billi\u00f3}",
                    "{one:00' 'billi\u00f3 other:00' 'billi\u00f3}",
                    "{one:000' 'billi\u00f3 other:000' 'billi\u00f3}",
                }
            },
            { "buddhist.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "standalone.QuarterNames",
                new String[] {
                    "1. negyed\u00e9v",
                    "2. negyed\u00e9v",
                    "3. negyed\u00e9v",
                    "4. negyed\u00e9v",
                }
            },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "standalone.DayNarrows", metaValue_DayNarrows },
            { "java.time.buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "java.time.roc.Eras", metaValue_java_time_roc_long_Eras },
            { "field.zone", "id\u0151z\u00f3na" },
            { "japanese.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.narrow.Eras", metaValue_java_time_roc_long_Eras },
            { "buddhist.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "Eras",
                new String[] {
                    "i. e.",
                    "i. sz.",
                }
            },
            { "roc.DayNames", metaValue_DayNames },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.abbreviated.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "standalone.QuarterNarrows",
                new String[] {
                    "1.",
                    "2.",
                    "3.",
                    "4.",
                }
            },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "field.weekday", "h\u00e9t napja" },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "java.time.islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "java.time.buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.MonthNames", metaValue_MonthNames },
            { "buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "field.week", "h\u00e9t" },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "short.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0\u00a0E other:0\u00a0E}",
                    "{one:00\u00a0E other:00\u00a0E}",
                    "{one:000\u00a0E other:000\u00a0E}",
                    "{one:0\u00a0M other:0\u00a0M}",
                    "{one:00\u00a0M other:00\u00a0M}",
                    "{one:000\u00a0M other:000\u00a0M}",
                    "{one:0\u00a0Mrd other:0\u00a0Mrd}",
                    "{one:00\u00a0Mrd other:00\u00a0Mrd}",
                    "{one:000\u00a0Mrd other:000\u00a0Mrd}",
                    "{one:0\u00a0B other:0\u00a0B}",
                    "{one:00\u00a0B other:00\u00a0B}",
                    "{one:000\u00a0B other:000\u00a0B}",
                }
            },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "java.time.buddhist.narrow.Eras", metaValue_java_time_buddhist_long_Eras },
            { "timezone.regionFormat.daylight", "{0} ny\u00e1ri id\u0151" },
            { "DatePatterns",
                new String[] {
                    "y. MMMM d., EEEE",
                    "y. MMMM d.",
                    "y. MMM d.",
                    "y. MM. dd.",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames", metaValue_DayNames },
            { "PluralRules", "one:n = 1" },
            { "field.hour", "\u00f3ra" },
            { "islamic.MonthAbbreviations",
                new String[] {
                    "Moh.",
                    "Saf.",
                    "R\u00e9b. 1",
                    "R\u00e9b. 2",
                    "Dsem. I",
                    "Dsem. II",
                    "Red.",
                    "Sab.",
                    "Ram.",
                    "Sev.",
                    "Ds\u00fcl k.",
                    "Ds\u00fcl h.",
                    "",
                }
            },
            { "islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "calendarname.buddhist", "Buddhista napt\u00e1r" },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "#,##0.00\u00a0\u00a4",
                    "#,##0%",
                    "#,##0.00\u00a0\u00a4",
                }
            },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "java.time.islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.abbreviated.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
