/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import org.sonatype.guice.bean.locators.ImplementationVisitor;
import org.sonatype.guice.bean.locators.QualifiedBeans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum QualifyingStrategy {
    UNRESTRICTED{

        @Override
        final Annotation qualify(Key<?> expectedKey, Binding<?> binding) {
            Key<?> key = binding.getKey();
            if (null != key.getAnnotationType()) {
                return key.getAnnotation();
            }
            return QualifiedBeans.DEFAULT_QUALIFIER;
        }
    }
    ,
    NAMED{

        @Override
        final Annotation qualify(Key<?> expectedKey, Binding<?> binding) {
            Annotation qualifier = UNRESTRICTED.qualify(expectedKey, binding);
            return qualifier instanceof Named ? qualifier : null;
        }
    }
    ,
    NAMED_WITH_ATTRIBUTES{

        @Override
        final Annotation qualify(Key<?> expectedKey, Binding<?> binding) {
            Annotation qualifier = NAMED.qualify(expectedKey, binding);
            return ((Object)expectedKey.getAnnotation()).equals(qualifier) ? qualifier : null;
        }
    }
    ,
    MARKED{

        @Override
        final Annotation qualify(Key<?> expectedKey, Binding<?> binding) {
            Class<Annotation> markerType = expectedKey.getAnnotationType();
            Class implementation = (Class)binding.acceptTargetVisitor(ImplementationVisitor.THIS);
            return null != implementation ? implementation.getAnnotation(markerType) : null;
        }
    }
    ,
    MARKED_WITH_ATTRIBUTES{

        @Override
        final Annotation qualify(Key<?> expectedKey, Binding<?> binding) {
            Annotation qualifier = MARKED.qualify(expectedKey, binding);
            return ((Object)expectedKey.getAnnotation()).equals(qualifier) ? qualifier : null;
        }
    };


    abstract Annotation qualify(Key<?> var1, Binding<?> var2);
}

