/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.delay;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.delay.Delay;
import org.pentaho.di.trans.steps.delay.DelayData;
import org.pentaho.di.trans.steps.delay.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String timeout;
    private String scaletime;
    public static String DEFAULT_SCALE_TIME = "seconds";
    public String[] ScaleTimeCode = new String[]{"milliseconds", "seconds", "minutes", "hours"};

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"timeout", (String)this.timeout));
        retval.append("    " + XMLHandler.addTagValue((String)"scaletime", (String)this.scaletime));
        return retval.toString();
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public String getScaleTime() {
        return this.scaletime;
    }

    public void setScaleTimeCode(int ScaleTimeIndex) {
        switch (ScaleTimeIndex) {
            case 0: {
                this.scaletime = this.ScaleTimeCode[0];
                break;
            }
            case 1: {
                this.scaletime = this.ScaleTimeCode[1];
                break;
            }
            case 2: {
                this.scaletime = this.ScaleTimeCode[2];
                break;
            }
            case 3: {
                this.scaletime = this.ScaleTimeCode[3];
                break;
            }
            default: {
                this.scaletime = this.ScaleTimeCode[1];
            }
        }
    }

    public int getScaleTimeCode() {
        int retval = 1;
        if (this.scaletime == null) {
            return retval;
        }
        if (this.scaletime.equals(this.ScaleTimeCode[0])) {
            retval = 0;
        } else if (this.scaletime.equals(this.ScaleTimeCode[1])) {
            retval = 1;
        } else if (this.scaletime.equals(this.ScaleTimeCode[2])) {
            retval = 2;
        } else if (this.scaletime.equals(this.ScaleTimeCode[3])) {
            retval = 3;
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.timeout = XMLHandler.getTagValue((Node)stepnode, (String)"timeout");
            this.scaletime = XMLHandler.getTagValue((Node)stepnode, (String)"scaletime");
            this.setScaleTimeCode(this.getScaleTimeCode());
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("DelayMeta.Exception.UnableToReadStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.timeout = "1";
        this.scaletime = DEFAULT_SCALE_TIME;
    }

    public String getTimeOut() {
        return this.timeout;
    }

    public void setTimeOut(String timeout) {
        this.timeout = timeout;
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.timeout = rep.getStepAttributeString(id_step, "timeout");
            this.scaletime = rep.getStepAttributeString(id_step, "scaletime");
            this.setScaleTimeCode(this.getScaleTimeCode());
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("DelayMeta.Exception.UnexpectedErrorReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "timeout", this.timeout);
            rep.saveStepAttribute(id_transformation, id_step, "scaletime", this.scaletime);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("DelayMeta.Exception.UnexpectedErrorSavingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        String error_message = "";
        if (Const.isEmpty((String)this.timeout)) {
            error_message = Messages.getString("DelayMeta.CheckResult.TimeOutMissing");
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
        } else {
            error_message = Messages.getString("DelayMeta.CheckResult.TimeOutOk");
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
        }
        remarks.add((CheckResultInterface)cr);
        cr = prev == null || prev.size() == 0 ? new CheckResult(3, Messages.getString("DelayMeta.CheckResult.NotReceivingFields"), (CheckResultSourceInterface)stepinfo) : new CheckResult(1, Messages.getString("DelayMeta.CheckResult.StepRecevingData", prev.size() + ""), (CheckResultSourceInterface)stepinfo);
        remarks.add((CheckResultInterface)cr);
        cr = input.length > 0 ? new CheckResult(1, Messages.getString("DelayMeta.CheckResult.StepRecevingData2"), (CheckResultSourceInterface)stepinfo) : new CheckResult(4, Messages.getString("DelayMeta.CheckResult.NoInputReceivedFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Delay(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DelayData();
    }
}

