/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.xmlwellformed;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.xmlwellformed.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryXMLWellFormed
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public String SUCCESS_IF_AT_LEAST_X_FILES_WELL_FORMED = "success_when_at_least";
    public String SUCCESS_IF_BAD_FORMED_FILES_LESS = "success_if_bad_formed_files_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    public String ADD_ALL_FILENAMES = "all_filenames";
    public String ADD_WELL_FORMED_FILES_ONLY = "only_well_formed_filenames";
    public String ADD_BAD_FORMED_FILES_ONLY = "only_bad_formed_filenames";
    public boolean arg_from_previous;
    public boolean include_subfolders;
    public String[] source_filefolder;
    public String[] wildcard;
    private String nr_errors_less_than;
    private String success_condition;
    private String resultfilenames;
    int NrAllErrors = 0;
    int NrBadFormed = 0;
    int NrWellFormed = 0;
    int limitFiles = 0;
    int NrErrors = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;

    public JobEntryXMLWellFormed(String n) {
        super(n, "");
        this.resultfilenames = this.ADD_ALL_FILENAMES;
        this.arg_from_previous = false;
        this.source_filefolder = null;
        this.wildcard = null;
        this.include_subfolders = false;
        this.nr_errors_less_than = "10";
        this.success_condition = this.SUCCESS_IF_NO_ERRORS;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.XML_WELL_FORMED);
    }

    public JobEntryXMLWellFormed() {
        this("");
    }

    public JobEntryXMLWellFormed(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryXMLWellFormed je = (JobEntryXMLWellFormed)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.arg_from_previous));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.include_subfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_less_than", (String)this.nr_errors_less_than));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"resultfilenames", (String)this.resultfilenames));
        retval.append("      <fields>").append(Const.CR);
        if (this.source_filefolder != null) {
            for (int i = 0; i < this.source_filefolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"source_filefolder", (String)this.source_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.arg_from_previous = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.include_subfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.nr_errors_less_than = XMLHandler.getTagValue((Node)entrynode, (String)"nr_errors_less_than");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.resultfilenames = XMLHandler.getTagValue((Node)entrynode, (String)"resultfilenames");
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.source_filefolder = new String[nrFields];
            this.wildcard = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.source_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.wildcard[i] = XMLHandler.getTagValue((Node)fnode, (String)"wildcard");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobXMLWellFormed.Error.Exception.UnableLoadXML"), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.arg_from_previous = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.include_subfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.nr_errors_less_than = rep.getJobEntryAttributeString(id_jobentry, "nr_errors_less_than");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            this.resultfilenames = rep.getJobEntryAttributeString(id_jobentry, "resultfilenames");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "source_filefolder");
            this.source_filefolder = new String[argnr];
            this.wildcard = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.source_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "source_filefolder");
                this.wildcard[a] = rep.getJobEntryAttributeString(id_jobentry, a, "wildcard");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobXMLWellFormed.Error.Exception.UnableLoadRep") + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "arg_from_previous", this.arg_from_previous);
            rep.saveJobEntryAttribute(id_job, this.getID(), "include_subfolders", this.include_subfolders);
            rep.saveJobEntryAttribute(id_job, this.getID(), "nr_errors_less_than", this.nr_errors_less_than);
            rep.saveJobEntryAttribute(id_job, this.getID(), "success_condition", this.success_condition);
            rep.saveJobEntryAttribute(id_job, this.getID(), "resultfilenames", this.resultfilenames);
            if (this.source_filefolder != null) {
                for (int i = 0; i < this.source_filefolder.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "source_filefolder", this.source_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "wildcard", this.wildcard[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobXMLWellFormed.Error.Exception.UnableSaveRep") + id_job, (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) throws KettleException {
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        this.NrErrors = 0;
        this.NrWellFormed = 0;
        this.NrBadFormed = 0;
        this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getNrErrorsLessThan()), (int)10);
        this.successConditionBroken = false;
        this.successConditionBrokenExit = false;
        String[] vsourcefilefolder = this.source_filefolder;
        String[] vwildcard = this.wildcard;
        if (this.arg_from_previous && log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobXMLWellFormed.Log.ArgFromPrevious.Found", (rows != null ? rows.size() : 0) + ""), new Object[0]);
        }
        if (this.arg_from_previous && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !parentJob.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        log.logError(this.toString(), Messages.getString("JobXMLWellFormed.Error.SuccessConditionbroken", "" + this.NrAllErrors), new Object[0]);
                        this.successConditionBrokenExit = true;
                    }
                    result.setEntryNr((long)this.NrAllErrors);
                    result.setNrLinesRejected((long)this.NrBadFormed);
                    result.setNrLinesWritten((long)this.NrWellFormed);
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(iteration);
                String vsourcefilefolder_previous = resultRow.getString(0, null);
                String vwildcard_previous = resultRow.getString(1, null);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobXMLWellFormed.Log.ProcessingRow", vsourcefilefolder_previous, vwildcard_previous), new Object[0]);
                }
                this.ProcessFileFolder(vsourcefilefolder_previous, vwildcard_previous, parentJob, result);
            }
        } else if (vsourcefilefolder != null) {
            for (int i = 0; i < vsourcefilefolder.length && !parentJob.isStopped(); ++i) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        log.logError(this.toString(), Messages.getString("JobXMLWellFormed.Error.SuccessConditionbroken", "" + this.NrAllErrors), new Object[0]);
                        this.successConditionBrokenExit = true;
                    }
                    result.setEntryNr((long)this.NrAllErrors);
                    result.setNrLinesRejected((long)this.NrBadFormed);
                    result.setNrLinesWritten((long)this.NrWellFormed);
                    return result;
                }
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobXMLWellFormed.Log.ProcessingRow", vsourcefilefolder[i], vwildcard[i]), new Object[0]);
                }
                this.ProcessFileFolder(vsourcefilefolder[i], vwildcard[i], parentJob, result);
            }
        }
        result.setNrErrors((long)this.NrAllErrors);
        result.setNrLinesRejected((long)this.NrBadFormed);
        result.setNrLinesWritten((long)this.NrWellFormed);
        if (this.getSuccessStatus()) {
            result.setNrErrors(0L);
            result.setResult(true);
        }
        this.displayResults(log);
        return result;
    }

    private void displayResults(LogWriter log) {
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), "=======================================", new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobXMLWellFormed.Log.Info.FilesInError", "" + this.NrErrors), new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobXMLWellFormed.Log.Info.FilesInBadFormed", "" + this.NrBadFormed), new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobXMLWellFormed.Log.Info.FilesInWellFormed", "" + this.NrWellFormed), new Object[0]);
            log.logDetailed(this.toString(), "=======================================", new Object[0]);
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrAllErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrBadFormed >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_BAD_FORMED_FILES_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrAllErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrWellFormed >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_WELL_FORMED) || this.NrBadFormed < this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_BAD_FORMED_FILES_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateErrors() {
        ++this.NrErrors;
        this.updateAllErrors();
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private void updateAllErrors() {
        this.NrAllErrors = this.NrErrors + this.NrBadFormed;
    }

    private boolean CheckWellFormed(FileObject file, LogWriter log) {
        boolean retval = false;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLTreeHandler handler = new XMLTreeHandler();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(KettleVFS.getFilename((FileObject)file)), (DefaultHandler)handler);
            retval = true;
        }
        catch (Exception e) {
            log.logError(this.toString(), Messages.getString("JobXMLWellFormed.Log.ErrorCheckingFile", file.toString(), e.getMessage()), new Object[0]);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ProcessFileFolder(String sourcefilefoldername, String wildcard, Job parentJob, Result result) {
        log = LogWriter.getInstance();
        entrystatus = false;
        sourcefilefolder = null;
        CurrentFile = null;
        realSourceFilefoldername = this.environmentSubstitute(sourcefilefoldername);
        if (Const.isEmpty((String)realSourceFilefoldername)) {
            log.logError(this.toString(), Messages.getString("JobXMLWellFormed.log.FileFolderEmpty", sourcefilefoldername), new Object[0]);
            this.updateErrors();
            return entrystatus;
        }
        realWildcard = this.environmentSubstitute(wildcard);
        try {
            block29: {
                block27: {
                    try {
                        sourcefilefolder = KettleVFS.getFileObject((String)realSourceFilefoldername);
                        if (sourcefilefolder.exists()) {
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobXMLWellFormed.Log.FileExists", sourcefilefolder.toString()), new Object[0]);
                            }
                            if (sourcefilefolder.getType() == FileType.FILE) {
                                entrystatus = this.checkOneFile(sourcefilefolder, log, result, parentJob);
                                break block27;
                            }
                            if (sourcefilefolder.getType() == FileType.FOLDER) {
                                fileObjects = sourcefilefolder.findFiles((FileSelector)new AllFileSelector(){

                                    public boolean traverseDescendents(FileSelectInfo info) {
                                        return true;
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     * Unable to fully structure code
                                     * Enabled aggressive block sorting
                                     * Enabled unnecessary exception pruning
                                     * Enabled aggressive exception aggregation
                                     */
                                    public boolean includeFile(FileSelectInfo info) {
                                        block14: {
                                            block15: {
                                                block13: {
                                                    fileObject = info.getFile();
                                                    try {
                                                        try {
                                                            if (fileObject == null) {
                                                                var3_3 = false;
                                                                var6_6 = null;
                                                                if (fileObject == null) return var3_3;
                                                                break block13;
                                                            }
                                                            if (fileObject.getType() == FileType.FILE) break block14;
                                                            var3_4 = false;
                                                            break block15;
                                                        }
                                                        catch (Exception ex) {
                                                            var4_16 = false;
                                                            var6_9 = null;
                                                            if (fileObject == null) return var4_16;
                                                            try {
                                                                fileObject.close();
                                                                return var4_16;
                                                            }
                                                            catch (IOException ex) {
                                                                // empty catch block
                                                            }
                                                            return var4_16;
                                                        }
                                                    }
                                                    catch (Throwable var5_17) {
                                                        var6_10 = null;
                                                        if (fileObject == null) throw var5_17;
                                                        ** try [egrp 2[TRYBLOCK] [7 : 67->76)] { 
lbl30:
                                                        // 1 sources

                                                        fileObject.close();
                                                        throw var5_17;
lbl32:
                                                        // 1 sources

                                                        catch (IOException ex) {
                                                            // empty catch block
                                                        }
                                                        throw var5_17;
                                                    }
                                                }
                                                ** try [egrp 2[TRYBLOCK] [7 : 67->76)] { 
lbl37:
                                                // 1 sources

                                                fileObject.close();
                                                return var3_3;
lbl39:
                                                // 1 sources

                                                catch (IOException ex) {
                                                    // empty catch block
                                                }
                                                return var3_3;
                                            }
                                            var6_7 = null;
                                            if (fileObject == null) return var3_4;
                                            try {}
                                            catch (IOException ex) {
                                                // empty catch block
                                                return var3_4;
                                            }
                                            fileObject.close();
                                            return var3_4;
                                        }
                                        var6_8 = null;
                                        if (fileObject == null) return true;
                                        try {}
                                        catch (IOException ex) {}
                                        fileObject.close();
                                        return true;
                                        return true;
                                    }
                                });
                                if (fileObjects == null) break block27;
                                for (j = 0; j < fileObjects.length && !parentJob.isStopped(); ++j) {
                                    if (this.successConditionBroken) {
                                        if (!this.successConditionBrokenExit) {
                                            log.logError(this.toString(), Messages.getString("JobXMLWellFormed.Error.SuccessConditionbroken", "" + this.NrAllErrors), new Object[0]);
                                            this.successConditionBrokenExit = true;
                                        }
                                        var13_14 = false;
                                        var15_15 = null;
                                        if (sourcefilefolder != null) {
                                            try {
                                                sourcefilefolder.close();
                                            }
                                            catch (IOException ex) {
                                                // empty catch block
                                            }
                                        }
                                        if (CurrentFile == null) return var13_14;
                                        try {
                                            CurrentFile.close();
                                            return var13_14;
                                        }
                                        catch (IOException ex) {
                                            // empty catch block
                                        }
                                        return var13_14;
                                    }
                                    CurrentFile = fileObjects[j];
                                    if (!CurrentFile.getParent().toString().equals(sourcefilefolder.toString())) {
                                        if (!this.include_subfolders || !this.GetFileWildcard(CurrentFile.toString(), realWildcard)) continue;
                                        this.checkOneFile(CurrentFile, log, result, parentJob);
                                        continue;
                                    }
                                    if (!this.GetFileWildcard(CurrentFile.toString(), realWildcard)) continue;
                                    this.checkOneFile(CurrentFile, log, result, parentJob);
                                }
                                break block27;
                            }
                            log.logError(this.toString(), Messages.getString("JobXMLWellFormed.Error.UnknowFileFormat", sourcefilefolder.toString()), new Object[0]);
                            this.updateErrors();
                            break block27;
                        }
                        log.logError(this.toString(), Messages.getString("JobXMLWellFormed.Error.SourceFileNotExists", realSourceFilefoldername), new Object[0]);
                        this.updateErrors();
                    }
                    catch (IOException e) {
                        block30: {
                            log.logError(this.toString(), Messages.getString("JobXMLWellFormed.Error.Exception.Processing", realSourceFilefoldername.toString(), e.getMessage()), new Object[0]);
                            this.updateErrors();
                            var15_17 = null;
                            if (sourcefilefolder != null) {
                                ** try [egrp 2[TRYBLOCK] [6 : 474->484)] { 
lbl68:
                                // 1 sources

                                sourcefilefolder.close();
                                break block30;
lbl70:
                                // 1 sources

                                catch (IOException ex) {
                                    // empty catch block
                                }
                            }
                        }
                        if (CurrentFile == null) return entrystatus;
                        try {}
                        catch (IOException ex) {
                            return entrystatus;
                        }
                        CurrentFile.close();
                        return entrystatus;
                    }
                }
                var15_16 = null;
                if (sourcefilefolder != null) {
                    ** try [egrp 2[TRYBLOCK] [6 : 474->484)] { 
lbl83:
                    // 1 sources

                    sourcefilefolder.close();
                    break block29;
lbl85:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            if (CurrentFile == null) return entrystatus;
            try {}
            catch (IOException ex) {
                return entrystatus;
            }
            CurrentFile.close();
            return entrystatus;
        }
        catch (Throwable var14_23) {
            block31: {
                var15_18 = null;
                if (sourcefilefolder != null) {
                    ** try [egrp 2[TRYBLOCK] [6 : 474->484)] { 
lbl99:
                    // 1 sources

                    sourcefilefolder.close();
                    break block31;
lbl101:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            if (CurrentFile == null) throw var14_23;
            ** try [egrp 3[TRYBLOCK] [7 : 491->501)] { 
lbl106:
            // 1 sources

            CurrentFile.close();
            throw var14_23;
lbl108:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            throw var14_23;
        }
    }

    private boolean checkOneFile(FileObject file, LogWriter log, Result result, Job parentJob) {
        boolean retval = false;
        try {
            boolean retformed = this.CheckWellFormed(file, log);
            if (!retformed) {
                log.logError(this.toString(), Messages.getString("JobXMLWellFormed.Error.FileBadFormed", file.toString()), new Object[0]);
                this.updateBadFormed();
                if (this.resultfilenames.equals(this.ADD_ALL_FILENAMES) || this.resultfilenames.equals(this.ADD_BAD_FORMED_FILES_ONLY)) {
                    this.addFileToResultFilenames(KettleVFS.getFilename((FileObject)file), log, result, parentJob);
                }
            } else {
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), "---------------------------", new Object[0]);
                    log.logDetailed(this.toString(), Messages.getString("JobXMLWellFormed.Error.FileWellFormed", file.toString()), new Object[0]);
                }
                this.updateWellFormed();
                if (this.resultfilenames.equals(this.ADD_ALL_FILENAMES) || this.resultfilenames.equals(this.ADD_WELL_FORMED_FILES_ONLY)) {
                    this.addFileToResultFilenames(KettleVFS.getFilename((FileObject)file), log, result, parentJob);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return retval;
    }

    private void updateWellFormed() {
        ++this.NrWellFormed;
    }

    private void updateBadFormed() {
        ++this.NrBadFormed;
        this.updateAllErrors();
    }

    private void addFileToResultFilenames(String fileaddentry, LogWriter log, Result result, Job parentJob) {
        try {
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)fileaddentry), parentJob.getName(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobXMLWellFormed.Log.FileAddedToResultFilesName", fileaddentry), new Object[0]);
            }
        }
        catch (Exception e) {
            log.logError(this.toString(), Messages.getString("JobXMLWellFormed.Error.AddingToFilenameResult", fileaddentry, e.getMessage()), new Object[0]);
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setIncludeSubfolders(boolean include_subfoldersin) {
        this.include_subfolders = include_subfoldersin;
    }

    public void setArgFromPrevious(boolean argfrompreviousin) {
        this.arg_from_previous = argfrompreviousin;
    }

    public void setNrErrorsLessThan(String nr_errors_less_than) {
        this.nr_errors_less_than = nr_errors_less_than;
    }

    public String getNrErrorsLessThan() {
        return this.nr_errors_less_than;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public void setResultFilenames(String resultfilenames) {
        this.resultfilenames = resultfilenames;
    }

    public String getResultFilenames() {
        return this.resultfilenames;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.source_filefolder.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    public static class XMLTreeHandler
    extends DefaultHandler {
    }
}

