/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class NavtelecomProtocolDecoder
extends BaseProtocolDecoder {
    private static final Map<Integer, Integer> ITEM_LENGTH_MAP = new HashMap<Integer, Integer>();
    private BitSet bits;

    public NavtelecomProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public static int getItemLength(int id) {
        Integer length = ITEM_LENGTH_MAP.get(id);
        if (length == null) {
            throw new IllegalArgumentException(String.format("Unknown item: %d", id));
        }
        return length;
    }

    public BitSet getBits() {
        return this.bits;
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int receiver, int sender, ByteBuf content) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeCharSequence((CharSequence)"@NTC", StandardCharsets.US_ASCII);
            response.writeIntLE(sender);
            response.writeIntLE(receiver);
            response.writeShortLE(content.readableBytes());
            response.writeByte(Checksum.xor(content.nioBuffer()));
            response.writeByte(Checksum.xor(response.nioBuffer()));
            response.writeBytes(content);
            content.release();
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getByte(buf.readerIndex()) == 64) {
            buf.skipBytes(4);
            int receiver = buf.readIntLE();
            int sender = buf.readIntLE();
            int length = buf.readUnsignedShortLE();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            String type = buf.toString(buf.readerIndex(), 6, StandardCharsets.US_ASCII);
            if (type.startsWith("*>S")) {
                String sentence = buf.readCharSequence(length, StandardCharsets.US_ASCII).toString();
                this.getDeviceSession(channel, remoteAddress, sentence.substring(4));
                ByteBuf payload = Unpooled.copiedBuffer((CharSequence)"*<S", (Charset)StandardCharsets.US_ASCII);
                this.sendResponse(channel, remoteAddress, receiver, sender, payload);
            } else if (type.startsWith("*>FLEX")) {
                buf.skipBytes(6);
                ByteBuf payload = Unpooled.buffer();
                payload.writeCharSequence((CharSequence)"*<FLEX", StandardCharsets.US_ASCII);
                payload.writeByte((int)buf.readUnsignedByte());
                payload.writeByte((int)buf.readUnsignedByte());
                payload.writeByte((int)buf.readUnsignedByte());
                int bitCount = buf.readUnsignedByte();
                this.bits = new BitSet((bitCount + 7) / 8);
                short currentByte = 0;
                for (int i = 0; i < bitCount; ++i) {
                    if (i % 8 == 0) {
                        currentByte = buf.readUnsignedByte();
                    }
                    this.bits.set(i, BitUtil.check(currentByte, 7 - i % 8));
                }
                this.sendResponse(channel, remoteAddress, receiver, sender, payload);
            }
        } else {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            String type = buf.readCharSequence(2, StandardCharsets.US_ASCII).toString();
            if (type.equals("~A")) {
                int count = buf.readUnsignedByte();
                LinkedList<Position> positions = new LinkedList<Position>();
                for (int i = 0; i < count; ++i) {
                    Position position = new Position(this.getProtocolName());
                    position.setDeviceId(deviceSession.getDeviceId());
                    block27: for (int j = 0; j < this.bits.length(); ++j) {
                        if (!this.bits.get(j)) continue;
                        switch (j + 1) {
                            case 1: {
                                position.set("index", buf.readUnsignedIntLE());
                                continue block27;
                            }
                            case 2: {
                                position.set("event", buf.readUnsignedShortLE());
                                continue block27;
                            }
                            case 3: {
                                position.setDeviceTime(new Date(buf.readUnsignedIntLE() * 1000L));
                                continue block27;
                            }
                            case 8: {
                                int value = buf.readUnsignedByte();
                                position.setValid(BitUtil.check(value, 1));
                                position.set("sat", BitUtil.from(value, 2));
                                continue block27;
                            }
                            case 9: {
                                position.setFixTime(new Date(buf.readUnsignedIntLE() * 1000L));
                                continue block27;
                            }
                            case 10: {
                                position.setLatitude((double)buf.readIntLE() * 1.0E-4 / 60.0);
                                continue block27;
                            }
                            case 11: {
                                position.setLongitude((double)buf.readIntLE() * 1.0E-4 / 60.0);
                                continue block27;
                            }
                            case 12: {
                                position.setAltitude((double)buf.readIntLE() * 0.1);
                                continue block27;
                            }
                            case 13: {
                                position.setSpeed(UnitsConverter.knotsFromKph(buf.readFloatLE()));
                                continue block27;
                            }
                            case 14: {
                                position.setCourse(buf.readUnsignedShortLE());
                                continue block27;
                            }
                            case 15: {
                                position.set("odometer", Float.valueOf(buf.readFloatLE()));
                                continue block27;
                            }
                            case 19: {
                                position.set("power", (double)buf.readShortLE() * 0.001);
                                continue block27;
                            }
                            case 20: {
                                position.set("battery", (double)buf.readShortLE() * 0.001);
                                continue block27;
                            }
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: 
                            case 26: {
                                position.set("adc" + (j + 2 - 21), (double)buf.readUnsignedShortLE() * 0.001);
                                continue block27;
                            }
                            case 29: {
                                int k;
                                int value = buf.readUnsignedByte();
                                for (k = 0; k <= 7; ++k) {
                                    position.set("in" + (k + 1), BitUtil.check(value, k));
                                }
                                continue block27;
                            }
                            case 31: {
                                int k;
                                int value = buf.readUnsignedByte();
                                for (k = 0; k <= 3; ++k) {
                                    position.set("out" + (k + 1), BitUtil.check(value, k));
                                }
                                continue block27;
                            }
                            case 33: 
                            case 34: {
                                position.set("count" + (j + 2 - 33), buf.readUnsignedIntLE());
                                continue block27;
                            }
                            case 35: 
                            case 36: {
                                position.set("freq" + (j + 2 - 35), buf.readUnsignedShortLE());
                                continue block27;
                            }
                            case 37: {
                                position.set("hours", buf.readUnsignedIntLE());
                                continue block27;
                            }
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: {
                                int value = buf.readUnsignedShortLE();
                                position.set("fuel" + (j + 2 - 38), value < 65500 ? Integer.valueOf(value) : null);
                                continue block27;
                            }
                            case 44: {
                                int value = buf.readUnsignedShortLE();
                                position.set("fuel", value < 65500 ? Integer.valueOf(value) : null);
                                continue block27;
                            }
                            case 45: 
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: {
                                int value = buf.readByte();
                                position.set("temp" + (j + 2 - 45), value != -128 ? Integer.valueOf(value) : null);
                                continue block27;
                            }
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: {
                                position.set("fuelTemp" + (j + 2 - 78), Integer.valueOf(buf.readByte()));
                                continue block27;
                            }
                            default: {
                                buf.skipBytes(NavtelecomProtocolDecoder.getItemLength(j + 1));
                            }
                        }
                    }
                    if (position.getFixTime() == null) {
                        this.getLastLocation(position, position.getDeviceTime());
                    }
                    positions.add(position);
                }
                if (channel != null) {
                    ByteBuf response = Unpooled.buffer();
                    response.writeCharSequence((CharSequence)type, StandardCharsets.US_ASCII);
                    response.writeByte(count);
                    response.writeByte(Checksum.crc8(Checksum.CRC8_EGTS, response.nioBuffer()));
                    channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
                }
                return positions;
            }
        }
        return null;
    }

    static {
        int[] l1 = new int[]{4, 5, 6, 7, 8, 29, 30, 31, 32, 45, 46, 47, 48, 49, 50, 51, 52, 56, 63, 64, 65, 69, 72, 78, 79, 80, 81, 82, 83, 98, 99, 101, 104, 118, 122, 123, 124, 125, 126, 139, 140, 144, 145, 167, 168, 169, 170, 199, 202, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222};
        int[] l2 = new int[]{2, 14, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 35, 36, 38, 39, 40, 41, 42, 43, 44, 53, 55, 58, 59, 60, 61, 62, 66, 68, 71, 75, 100, 106, 108, 110, 111, 112, 113, 114, 115, 116, 117, 119, 120, 121, 133, 134, 135, 136, 137, 138, 141, 143, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 171, 175, 177, 178, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 200, 201, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237};
        int[] l3 = new int[]{84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 142, 146, 198};
        int[] l4 = new int[]{1, 3, 9, 10, 11, 12, 13, 15, 16, 33, 34, 37, 54, 57, 67, 74, 76, 102, 103, 105, 127, 128, 129, 130, 131, 132, 172, 173, 174, 176, 179, 193, 194, 195, 196, 203, 205, 206, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252};
        for (int i : l1) {
            ITEM_LENGTH_MAP.put(i, 1);
        }
        for (int i : l2) {
            ITEM_LENGTH_MAP.put(i, 2);
        }
        for (int i : l3) {
            ITEM_LENGTH_MAP.put(i, 3);
        }
        for (int i : l4) {
            ITEM_LENGTH_MAP.put(i, 4);
        }
        ITEM_LENGTH_MAP.put(70, 8);
        ITEM_LENGTH_MAP.put(73, 16);
        ITEM_LENGTH_MAP.put(77, 37);
        ITEM_LENGTH_MAP.put(94, 6);
        ITEM_LENGTH_MAP.put(95, 12);
        ITEM_LENGTH_MAP.put(96, 24);
        ITEM_LENGTH_MAP.put(97, 48);
        ITEM_LENGTH_MAP.put(107, 6);
        ITEM_LENGTH_MAP.put(109, 6);
        ITEM_LENGTH_MAP.put(197, 6);
        ITEM_LENGTH_MAP.put(204, 5);
        ITEM_LENGTH_MAP.put(253, 8);
        ITEM_LENGTH_MAP.put(254, 8);
        ITEM_LENGTH_MAP.put(255, 8);
    }
}

