/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.model.Event;
import org.traccar.model.Maintenance;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

@Singleton
@ChannelHandler.Sharable
public class MaintenanceEventHandler
extends BaseEventHandler {
    private final CacheManager cacheManager;

    @Inject
    public MaintenanceEventHandler(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        Position lastPosition = this.cacheManager.getPosition(position.getDeviceId());
        if (lastPosition == null || position.getFixTime().compareTo(lastPosition.getFixTime()) < 0) {
            return null;
        }
        HashMap<Event, Position> events = new HashMap<Event, Position>();
        for (Maintenance maintenance : this.cacheManager.getDeviceObjects(position.getDeviceId(), Maintenance.class)) {
            if (maintenance.getPeriod() == 0.0) continue;
            double oldValue = lastPosition.getDouble(maintenance.getType());
            double newValue = position.getDouble(maintenance.getType());
            if (oldValue == 0.0 || newValue == 0.0 || !(newValue >= maintenance.getStart()) || !(oldValue < maintenance.getStart()) && (long)((oldValue - maintenance.getStart()) / maintenance.getPeriod()) >= (long)((newValue - maintenance.getStart()) / maintenance.getPeriod())) continue;
            Event event = new Event("maintenance", position);
            event.setMaintenanceId(maintenance.getId());
            event.set(maintenance.getType(), newValue);
            events.put(event, position);
        }
        return events;
    }
}

