/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Device;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
public class DeviceLookupService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceLookupService.class);
    private static final long INFO_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(60L);
    private static final long THROTTLE_MIN_MS = TimeUnit.MINUTES.toMillis(1L);
    private static final long THROTTLE_MAX_MS = TimeUnit.MINUTES.toMillis(30L);
    private final Storage storage;
    private final Timer timer;
    private final boolean throttlingEnabled;
    private final Map<String, IdentifierInfo> identifierMap = new ConcurrentHashMap<String, IdentifierInfo>();

    @Inject
    public DeviceLookupService(Config config, Storage storage, Timer timer) {
        this.storage = storage;
        this.timer = timer;
        this.throttlingEnabled = config.getBoolean(Keys.DATABASE_THROTTLE_UNKNOWN);
    }

    private synchronized boolean isThrottled(String uniqueId) {
        if (this.throttlingEnabled) {
            IdentifierInfo info = this.identifierMap.get(uniqueId);
            return info != null && System.currentTimeMillis() < info.lastQuery + info.delay;
        }
        return false;
    }

    private synchronized void lookupSucceeded(String uniqueId) {
        IdentifierInfo info;
        if (this.throttlingEnabled && (info = this.identifierMap.remove(uniqueId)) != null) {
            info.timeout.cancel();
        }
    }

    private synchronized void lookupFailed(String uniqueId) {
        if (this.throttlingEnabled) {
            IdentifierInfo info = this.identifierMap.get(uniqueId);
            if (info != null) {
                info.timeout.cancel();
                info.delay = Math.min(info.delay * 2L, THROTTLE_MAX_MS);
            } else {
                info = new IdentifierInfo();
                this.identifierMap.put(uniqueId, info);
                info.delay = THROTTLE_MIN_MS;
            }
            info.lastQuery = System.currentTimeMillis();
            info.timeout = this.timer.newTimeout((TimerTask)new IdentifierTask(uniqueId), INFO_TIMEOUT_MS, TimeUnit.MILLISECONDS);
            LOGGER.debug("Device lookup {} throttled for {} ms", (Object)uniqueId, (Object)info.delay);
        }
    }

    public Device lookup(String[] uniqueIds) {
        Device device = null;
        try {
            for (String uniqueId : uniqueIds) {
                if (!this.isThrottled(uniqueId)) {
                    device = this.storage.getObject(Device.class, new Request((Columns)new Columns.All(), new Condition.Equals("uniqueId", uniqueId)));
                    if (device != null) {
                        this.lookupSucceeded(uniqueId);
                        break;
                    }
                    this.lookupFailed(uniqueId);
                    continue;
                }
                LOGGER.debug("Device lookup throttled {}", (Object)uniqueId);
            }
        }
        catch (StorageException e) {
            LOGGER.warn("Find device error", (Throwable)e);
        }
        return device;
    }

    private static class IdentifierInfo {
        private long lastQuery;
        private long delay;
        private Timeout timeout;

        private IdentifierInfo() {
        }
    }

    private final class IdentifierTask
    implements TimerTask {
        private final String uniqueId;

        private IdentifierTask(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Timeout timeout) {
            LOGGER.debug("Device lookup expired {}", (Object)this.uniqueId);
            DeviceLookupService deviceLookupService = DeviceLookupService.this;
            synchronized (deviceLookupService) {
                DeviceLookupService.this.identifierMap.remove(this.uniqueId);
            }
        }
    }
}

