/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.report.projects.future;

import au.com.trgtd.tr.report.projects.future.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.view.JasperViewer;
import tr.extract.Extract;
import tr.extract.ExtractProjectOutline;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamList;
import tr.extract.ParamTopic;
import tr.extract.ParamsDialog;
import tr.model.Data;
import tr.model.project.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportImpl
extends Extract {
    private ParamTopic paramTopic;
    private ParamBoolean paramActions;
    private ParamList paramSort;

    public String getID() {
        return "au.com.trgtd.tr.report.projects.future";
    }

    public String getName() {
        return this.getString("CTL_ReportAction");
    }

    public List<Param> getParams() {
        this.paramTopic = new ParamTopic("paramTopic", this.getString("param-topic"), Extract.FormatType.XML);
        this.paramActions = new ParamBoolean("paramActions", this.getString("param-actions"));
        Vector<Param.Item> sortItems = new Vector<Param.Item>();
        sortItems.add(new Param.Item(this.getString("param-sort-none"), "none"));
        sortItems.add(new Param.Item(this.getString("param-sort-descr"), "descr"));
        sortItems.add(new Param.Item(this.getString("param-sort-priority"), "priority"));
        sortItems.add(new Param.Item(this.getString("param-sort-date"), "date"));
        this.paramSort = new ParamList("paramSort", this.getString("param-sort"), sortItems);
        Vector<Param> params = new Vector<Param>();
        params.add((Param)this.paramTopic);
        params.add((Param)this.paramActions);
        params.add((Param)this.paramSort);
        return params;
    }

    public void process(Data data) throws Exception {
        String title = this.getDialogTitleReport(this.getName());
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), this.getParams());
        if (dlg.showDialog() == 2) {
            return;
        }
        HashMap<String, String> rparams = new HashMap<String, String>();
        rparams.put("paramTopic", this.paramTopic.getValue());
        if (!this.paramSort.getValue().equals("none")) {
            rparams.put("paramSortText", this.getString("param-sort-" + this.paramSort.getValue()));
        }
        FileInputStream reportStream = new FileInputStream(Resources.FILE_REPORT);
        File xmlfile = ReportImpl.getTmpFile((String)"FutureProjects.xml");
        List projects = data.getRootFutures().getChildren(Project.class);
        boolean includeActions = Boolean.parseBoolean(this.paramActions.getValue());
        ExtractProjectOutline.process((File)xmlfile, (List)projects, (String)this.paramTopic.getValue(), (String)"all", (String)"all", (boolean)includeActions, (String)this.paramSort.getValue());
        JRXmlDataSource xmlDataSource = new JRXmlDataSource(xmlfile, "/data/item");
        JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)reportStream, rparams, (JRDataSource)xmlDataSource);
        JasperViewer.viewReport((JasperPrint)jasperPrint, (boolean)false);
    }
}

