/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.join.FiltersQParser;
import org.apache.solr.search.join.ScoreModeParser;

public class BlockJoinParentQParser
extends FiltersQParser {
    public static final String CACHE_NAME = "perSegFilter";

    protected String getParentFilterLocalParamName() {
        return "which";
    }

    @Override
    protected String getFiltersParamName() {
        return "filters";
    }

    BlockJoinParentQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    protected Query parseParentFilter() throws SyntaxError {
        String filter = this.localParams.get(this.getParentFilterLocalParamName());
        QParser parentParser = this.subQuery(filter, null);
        Query parentQ = parentParser.getQuery();
        return parentQ;
    }

    @Override
    protected Query wrapSubordinateClause(Query subordinate) throws SyntaxError {
        String scoreMode = this.localParams.get("score", ScoreMode.None.name());
        Query parentQ = this.parseParentFilter();
        return this.createQuery(parentQ, subordinate, scoreMode);
    }

    @Override
    protected Query noClausesQuery() throws SyntaxError {
        return new BitSetProducerQuery(this.getBitSetProducer(this.parseParentFilter()));
    }

    protected Query createQuery(Query parentList, Query query, String scoreMode) throws SyntaxError {
        return new AllParentsAware(query, this.getBitSetProducer(parentList), ScoreModeParser.parse(scoreMode), parentList);
    }

    BitSetProducer getBitSetProducer(Query query) {
        return BlockJoinParentQParser.getCachedBitSetProducer(this.req, query);
    }

    public static BitSetProducer getCachedBitSetProducer(SolrQueryRequest request, Query query) {
        SolrCache parentCache = request.getSearcher().getCache(CACHE_NAME);
        if (parentCache != null) {
            try {
                return parentCache.computeIfAbsent(query, QueryBitSetProducer::new);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new QueryBitSetProducer(query);
    }

    static class BitSetProducerQuery
    extends ExtendedQueryBase {
        final BitSetProducer bitSetProducer;

        public BitSetProducerQuery(BitSetProducer bitSetProducer) {
            this.bitSetProducer = bitSetProducer;
            this.setCache(false);
        }

        @Override
        public String toString(String field) {
            return this.getClass().getSimpleName() + "(" + this.bitSetProducer + ")";
        }

        public boolean equals(Object other) {
            return this.sameClassAs(other) && Objects.equals(this.bitSetProducer, ((BitSetProducerQuery)this.getClass().cast((Object)other)).bitSetProducer);
        }

        public int hashCode() {
            return this.classHash() + this.bitSetProducer.hashCode();
        }

        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf((Query)this);
        }

        public Weight createWeight(IndexSearcher searcher, final org.apache.lucene.search.ScoreMode scoreMode, final float boost) throws IOException {
            return new ConstantScoreWeight(this, boost){

                public Scorer scorer(LeafReaderContext context) throws IOException {
                    BitSet bitSet = bitSetProducer.getBitSet(context);
                    if (bitSet == null) {
                        return null;
                    }
                    BitSetIterator disi = new BitSetIterator(bitSet, (long)bitSet.approximateCardinality());
                    return new ConstantScoreScorer((Weight)this, boost, scoreMode, (DocIdSetIterator)disi);
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    return this.getCache();
                }
            };
        }
    }

    static final class AllParentsAware
    extends ToParentBlockJoinQuery {
        private final Query parentQuery;

        private AllParentsAware(Query childQuery, BitSetProducer parentsFilter, ScoreMode scoreMode, Query parentList) {
            super(childQuery, parentsFilter, scoreMode);
            this.parentQuery = parentList;
        }

        public Query getParentQuery() {
            return this.parentQuery;
        }
    }
}

