/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.ReloadCollectionPayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/c/{collection}", "/collections/{collection}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
public class ReloadCollectionAPI {
    private static final String V2_RELOAD_COLLECTION_CMD = "reload";
    private final CollectionsHandler collectionsHandler;

    public ReloadCollectionAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @Command(name="reload")
    public void reloadCollection(PayloadObj<ReloadCollectionPayload> obj) throws Exception {
        ReloadCollectionPayload v2Body = obj.get();
        Map v1Params = v2Body.toMap(new HashMap());
        v1Params.put("action", CollectionParams.CollectionAction.RELOAD.toLower());
        v1Params.put("name", obj.getRequest().getPathTemplateValues().get("collection"));
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }
}

