/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.facet.compare;

import java.util.Collection;
import java.util.Iterator;
import org.apache.solr.analytics.facet.SortableFacet;
import org.apache.solr.analytics.facet.compare.FacetResultsComparator;
import org.apache.solr.common.SolrException;

public class DelegatingComparator
extends FacetResultsComparator {
    private final Iterable<FacetResultsComparator> comparators;

    private DelegatingComparator(Iterable<FacetResultsComparator> comparators) {
        this.comparators = comparators;
    }

    public static FacetResultsComparator joinComparators(Collection<FacetResultsComparator> comparators) throws SolrException {
        if (comparators.size() == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "A sort must have at least 1 comparator criteria.");
        }
        if (comparators.size() == 1) {
            return comparators.iterator().next();
        }
        return new DelegatingComparator(comparators);
    }

    @Override
    public int compare(SortableFacet.FacetBucket b1, SortableFacet.FacetBucket b2) {
        FacetResultsComparator comparator;
        int val = 0;
        Iterator<FacetResultsComparator> iterator = this.comparators.iterator();
        while (iterator.hasNext() && (val = (comparator = iterator.next()).compare(b1, b2)) == 0) {
        }
        return val;
    }
}

