/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.Compact64bitInt;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitReader;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitWriter;

public class StreamObjectHeaderStart32bit
extends StreamObjectHeaderStart {
    public Compact64bitInt largeLength;

    public StreamObjectHeaderStart32bit(StreamObjectTypeHeaderStart type, int length) {
        this.headerType = 2;
        this.type = type;
        int n = this.compound = StreamObject.getCompoundTypes().contains((Object)this.type) ? 1 : 0;
        if (length >= Short.MAX_VALUE) {
            this.length = Short.MAX_VALUE;
            this.largeLength = new Compact64bitInt(length);
        } else {
            this.length = length;
            this.largeLength = null;
        }
    }

    public StreamObjectHeaderStart32bit() {
    }

    public StreamObjectHeaderStart32bit(StreamObjectTypeHeaderStart streamObjectTypeHeaderStart) {
        this.type = streamObjectTypeHeaderStart;
    }

    @Override
    public List<Byte> serializeToByteList() throws IOException {
        BitWriter bitFieldWriter = new BitWriter(4);
        bitFieldWriter.appendInit32(this.headerType, 2);
        bitFieldWriter.appendInit32(this.compound, 1);
        bitFieldWriter.appendUInit32(this.type.getIntVal(), 14);
        bitFieldWriter.appendInit32(this.length, 15);
        List<Byte> listByte = bitFieldWriter.getByteList();
        if (this.largeLength != null) {
            listByte.addAll(this.largeLength.serializeToByteList());
        }
        return listByte;
    }

    @Override
    protected int doDeserializeFromByteArray(byte[] byteArray, int startIndex) throws IOException, TikaException {
        BitReader bitReader = new BitReader(byteArray, startIndex);
        this.headerType = bitReader.readInt32(2);
        if (this.headerType != 2) {
            throw new TikaException(String.format(Locale.US, "Failed to get the StreamObjectHeaderStart32bit header type value, expect value %s, but actual value is %s", 2, this.headerType));
        }
        this.compound = bitReader.readInt32(1);
        int typeValue = bitReader.readInt32(14);
        this.type = StreamObjectTypeHeaderStart.fromIntVal(typeValue);
        if (this.type == null) {
            throw new TikaException(String.format(Locale.US, "Failed to get the StreamObjectHeaderStart32bit type value, the value %s is not defined", typeValue));
        }
        if (StreamObject.getCompoundTypes().contains((Object)this.type) && this.compound != 1) {
            throw new TikaException(String.format(Locale.US, "Failed to parse the StreamObjectHeaderStart32bit header. If the type value is %s then the compound value should 1, but actual value is 0", typeValue));
        }
        this.length = bitReader.readInt32(15);
        AtomicInteger index = new AtomicInteger(startIndex);
        index.addAndGet(4);
        if (this.length == Short.MAX_VALUE) {
            this.largeLength = BasicObject.parse(byteArray, index, Compact64bitInt.class);
        }
        return index.get() - startIndex;
    }
}

