/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.ChangesBunch;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesNavigation;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.BunchFactory;
import org.jetbrains.idea.svn.history.CachedProvider;
import org.jetbrains.idea.svn.history.Fragment;
import org.jetbrains.idea.svn.history.LiveProvider;
import org.jetbrains.idea.svn.history.LoadedRevisionsCache;
import org.jetbrains.idea.svn.history.Origin;
import org.jetbrains.idea.svn.history.SvnLogUtil;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.info.Info;

public class SvnRevisionsNavigationMediator
implements CommittedChangesNavigation {
    private static final Logger LOG = Logger.getInstance(SvnRevisionsNavigationMediator.class);
    public static final int CHUNK_SIZE = 50;
    private final InternallyCachedProvider myInternallyCached;
    private final VisuallyCachedProvider myVisuallyCached;
    private final List<List<Fragment>> myChunks;
    private boolean myCanNotGoBack;
    private int myCurrentIdx;
    private final BunchFactory myChunkFactory;
    private final Project myProject;

    public SvnRevisionsNavigationMediator(SvnRepositoryLocation location, Project project, VirtualFile vcsRoot) throws VcsException {
        this.myProject = project;
        SvnVcs vcs = SvnVcs.getInstance(project);
        this.myChunks = new LinkedList<List<Fragment>>();
        VcsException[] exception = new VcsException[1];
        Ref infoRef = new Ref();
        Runnable process2 = () -> {
            try {
                infoRef.set((Object)vcs.getInfo(location.toSvnUrl(), Revision.HEAD));
            }
            catch (SvnBindException e) {
                exception[0] = e;
            }
        };
        this.underProgress(exception, process2);
        Info info2 = (Info)infoRef.get();
        if (info2 == null || !info2.getRevision().isValid() || info2.getRepositoryRootUrl() == null) {
            throw new VcsException(SvnBundle.message("error.could.not.get.head.info.for.url", location));
        }
        Iterator visualIterator = project.isDefault() ? null : CommittedChangesCache.getInstance((Project)project).getBackBunchedIterator((AbstractVcs)vcs, vcsRoot, (RepositoryLocation)location, 50);
        Iterator<ChangesBunch> internalIterator = project.isDefault() ? null : LoadedRevisionsCache.getInstance(project).iterator(location.getURL());
        this.myInternallyCached = internalIterator == null ? null : new InternallyCachedProvider(internalIterator, this.myProject);
        this.myVisuallyCached = visualIterator == null ? null : new VisuallyCachedProvider(visualIterator, this.myProject, location);
        this.myChunkFactory = new BunchFactory(this.myInternallyCached, this.myVisuallyCached, new LiveProvider(vcs, location, info2.getRevision().getNumber(), new SvnLogUtil(this.myProject, vcs, location, info2.getRepositoryRootUrl()), info2.getRepositoryRootUrl()));
        this.myCurrentIdx = -1;
        this.underProgress(exception, () -> {
            try {
                this.goBack();
            }
            catch (VcsException e) {
                exception[0] = e;
            }
        });
    }

    private void underProgress(VcsException[] exception, Runnable process2) throws VcsException {
        boolean succeeded = ProgressManager.getInstance().runProcessWithProgressSynchronously(process2, SvnBundle.message("progress.title.getting.latest.repository.revision", new Object[0]), true, this.myProject);
        if (exception[0] != null) {
            throw exception[0];
        }
        if (!succeeded) {
            throw new ProcessCanceledException();
        }
    }

    public boolean canGoBack() {
        return this.myCurrentIdx + 1 < this.myChunks.size() || !this.myCanNotGoBack;
    }

    public boolean canGoForward() {
        return this.myCurrentIdx > 0;
    }

    public void goBack() throws VcsException {
        if (this.myCurrentIdx + 1 < this.myChunks.size()) {
            ++this.myCurrentIdx;
            return;
        }
        Ref canNotGoBackRef = new Ref();
        List<Fragment> fragments = this.myChunkFactory.goBack(50, (Ref<Boolean>)canNotGoBackRef);
        this.myCanNotGoBack = (Boolean)canNotGoBackRef.get();
        if (!fragments.isEmpty()) {
            ++this.myCurrentIdx;
            this.myChunks.add(fragments);
        }
    }

    public void goForward() {
        --this.myCurrentIdx;
    }

    public List<CommittedChangeList> getCurrent() {
        this.debugPrinting();
        return this.myChunks.isEmpty() ? Collections.emptyList() : this.fragmentsToLists(this.myChunks.get(this.myCurrentIdx));
    }

    private void debugPrinting() {
        LOG.debug("== showing screen (" + this.myCurrentIdx + "): ==");
        if (!this.myChunks.isEmpty()) {
            for (Fragment fragment : this.myChunks.get(this.myCurrentIdx)) {
                LOG.debug(fragment.getOrigin().toString() + " from: " + fragment.getList().get(0).getNumber() + " to: " + fragment.getList().get(fragment.getList().size() - 1).getNumber());
            }
        }
        LOG.debug("== end of screen ==");
    }

    private List<CommittedChangeList> fragmentsToLists(List<Fragment> fragments) {
        ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        for (Fragment fragment : fragments) {
            result.addAll(fragment.getList());
        }
        return result;
    }

    public void onBeforeClose() {
        if (this.myVisuallyCached != null && this.myVisuallyCached.hadBeenSuccessfullyAccessed()) {
            this.myVisuallyCached.doCacheUpdate(this.myChunks);
            InternallyCachedProvider.initCache(this.myChunks, this.myProject);
        } else if (this.myInternallyCached != null) {
            this.myInternallyCached.doCacheUpdate(this.myChunks);
        } else {
            InternallyCachedProvider.initCache(this.myChunks, this.myProject);
        }
    }

    private static final class InternallyCachedProvider
    extends CachedProvider {
        private final Project myProject;
        private boolean myHolesDetected;

        private InternallyCachedProvider(Iterator<ChangesBunch> iterator, Project project) {
            super(iterator, Origin.INTERNAL);
            this.myProject = project;
        }

        @Override
        protected void addToLoaded(ChangesBunch loaded) {
            this.myHolesDetected |= !loaded.isConsistentWithPrevious();
            super.addToLoaded(loaded);
        }

        public static void initCache(List<List<Fragment>> fragmentListList, Project project) {
            List<CommittedChangeList> lists = InternallyCachedProvider.getAllBeforeVisuallyCached(fragmentListList);
            if (!lists.isEmpty()) {
                LoadedRevisionsCache.getInstance(project).put(lists, false, null);
            }
        }

        @Override
        public void doCacheUpdate(List<List<Fragment>> fragmentsListList) {
            ArrayList<CommittedChangeList> lists = new ArrayList<CommittedChangeList>();
            LoadedRevisionsCache.Bunch bindAddress = null;
            boolean consistent = false;
            if (this.myHolesDetected) {
                boolean liveMet = false;
                block0: for (int i = 0; i < fragmentsListList.size(); ++i) {
                    List<Fragment> fragmentList = fragmentsListList.get(i);
                    for (int j = 0; j < fragmentList.size(); ++j) {
                        Fragment fragment = fragmentList.get(j);
                        liveMet |= Origin.LIVE.equals((Object)fragment.getOrigin());
                        if (Origin.INTERNAL.equals((Object)fragment.getOrigin())) {
                            bindAddress = ((LoadedRevisionsCache.Bunch)fragment.getOriginBunch()).getNext();
                            if (i == fragmentsListList.size() - 1 && j == fragmentList.size() - 1) {
                                lists.addAll(fragment.getOriginBunch().getList());
                                consistent = fragment.getOriginBunch().isConsistentWithPrevious();
                                continue block0;
                            }
                        }
                        lists.addAll(fragment.getList());
                    }
                }
                if (!liveMet) {
                    return;
                }
            } else {
                block2: for (List<Fragment> fragmentList : fragmentsListList) {
                    for (Fragment fragment : fragmentList) {
                        if (Origin.INTERNAL.equals((Object)fragment.getOrigin())) {
                            bindAddress = (LoadedRevisionsCache.Bunch)fragment.getOriginBunch();
                            consistent = true;
                            continue block2;
                        }
                        lists.addAll(fragment.getList());
                    }
                }
            }
            if (!lists.isEmpty()) {
                LoadedRevisionsCache.getInstance(this.myProject).put(lists, consistent, bindAddress);
            }
        }
    }

    private static final class VisuallyCachedProvider
    extends CachedProvider {
        private final Project myProject;
        private final RepositoryLocation myLocation;

        private VisuallyCachedProvider(Iterator<ChangesBunch> iterator, Project project, RepositoryLocation location) {
            super(iterator, Origin.VISUAL);
            this.myProject = project;
            this.myLocation = location;
        }

        @Override
        public void doCacheUpdate(List<List<Fragment>> fragmentsListList) {
            List<CommittedChangeList> lists = VisuallyCachedProvider.getAllBeforeVisuallyCached(fragmentsListList);
            CommittedChangesCache.getInstance((Project)this.myProject).submitExternallyLoaded(this.myLocation, ((CommittedChangeList)this.myAlreadyReaded.getList().get(0)).getNumber(), lists);
        }
    }
}

