/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.visiting;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.MethodVisitingFilter;
import com.intellij.rt.coverage.instrumentation.kotlin.KotlinUtils;
import java.util.HashSet;
import org.jetbrains.coverage.gnu.trove.TIntHashSet;
import org.jetbrains.coverage.gnu.trove.TIntProcedure;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class DeprecatedMethodFilter
extends MethodVisitingFilter {
    private static final String DEPRECATED_METHODS = "DEPRECATED_METHODS_SET";
    private boolean myShouldIgnoreMethod = false;
    private TIntHashSet myMethodLines;
    private String myName;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinUtils.isKotlinClass(context);
    }

    public void initFilter(MethodVisitor methodVisitor, Instrumenter context, String name, String desc) {
        Object property;
        super.initFilter(methodVisitor, context, name, desc);
        this.myName = name;
        if (name.endsWith("$default") && (property = this.myContext.getProperty(DEPRECATED_METHODS)) != null) {
            HashSet deprecatedMethods = (HashSet)property;
            String originalName = name.substring(0, name.length() - "$default".length());
            this.myShouldIgnoreMethod |= deprecatedMethods.contains(originalName);
        }
    }

    public void visitLineNumber(int line, Label start) {
        if (this.myShouldIgnoreMethod && this.myContext.getLineData(line) == null) {
            if (this.myMethodLines == null) {
                this.myMethodLines = new TIntHashSet();
            }
            this.myMethodLines.add(line);
        }
        super.visitLineNumber(line, start);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(descriptor, visible);
        if (!"Lkotlin/Deprecated;".equals(descriptor)) {
            return av;
        }
        return new AnnotationVisitor(589824, av){

            public void visitEnum(String name, String descriptor, String value) {
                super.visitEnum(name, descriptor, value);
                if (!"Lkotlin/DeprecationLevel;".equals(descriptor)) {
                    return;
                }
                DeprecatedMethodFilter.this.myShouldIgnoreMethod = DeprecatedMethodFilter.this.myShouldIgnoreMethod | ("ERROR".equals(value) || "HIDDEN".equals(value));
            }
        };
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.myShouldIgnoreMethod) {
            HashSet property = this.myContext.getProperty(DEPRECATED_METHODS);
            if (property == null) {
                property = new HashSet();
                this.myContext.addProperty(DEPRECATED_METHODS, property);
            }
            HashSet deprecatedMethods = property;
            deprecatedMethods.add(this.myName);
        }
        if (!this.myShouldIgnoreMethod || this.myMethodLines == null) {
            return;
        }
        this.myMethodLines.forEach(new TIntProcedure(){

            public boolean execute(int line) {
                DeprecatedMethodFilter.this.myContext.removeLine(line);
                return true;
            }
        });
    }
}

