/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation;

import gnu.trove.THashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.tagging.disambiguation.AbstractDisambiguator;
import org.languagetool.tools.StringTools;

public class MultiWordChunker
extends AbstractDisambiguator {
    private final String filename;
    private final boolean allowFirstCapitalized;
    private final boolean allowAllUppercase;
    private volatile boolean initialized;
    private Map<String, Integer> mStartSpace;
    private Map<String, Integer> mStartNoSpace;
    private Map<String, AnalyzedToken> mFull;
    private static final int MAX_TOKENS_IN_MULTIWORD = 20;
    private static final String DEFAULT_SEPARATOR = "\t";
    private String separator;

    public MultiWordChunker(String filename) {
        this(filename, false, false);
    }

    public MultiWordChunker(String filename, boolean allowFirstCapitalized, boolean allowAllUppercase) {
        this.filename = filename;
        this.allowFirstCapitalized = allowFirstCapitalized;
        this.allowAllUppercase = allowAllUppercase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.initialized) {
            return;
        }
        MultiWordChunker multiWordChunker = this;
        synchronized (multiWordChunker) {
            if (this.initialized) {
                return;
            }
            THashMap mStartSpace = new THashMap();
            THashMap mStartNoSpace = new THashMap();
            THashMap mFull = new THashMap();
            this.fillMaps((Map<String, Integer>)mStartSpace, (Map<String, Integer>)mStartNoSpace, (Map<String, AnalyzedToken>)mFull);
            mStartSpace.trimToSize();
            mStartNoSpace.trimToSize();
            mFull.trimToSize();
            this.mStartSpace = mStartSpace;
            this.mStartNoSpace = mStartNoSpace;
            this.mFull = mFull;
            this.initialized = true;
        }
    }

    private void fillMaps(Map<String, Integer> mStartSpace, Map<String, Integer> mStartNoSpace, Map<String, AnalyzedToken> mFull) {
        HashMap interner = new HashMap();
        try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(this.filename);){
            List<String> posTokens = this.loadWords(stream);
            for (String posToken : posTokens) {
                String tokenAllUppercase;
                String tokenFirstCapitalized;
                String[] tokenAndTag = posToken.split(this.separator);
                if (tokenAndTag.length != 2) {
                    throw new RuntimeException("Invalid format in " + this.filename + ": '" + posToken + "', expected two tab-separated parts");
                }
                ArrayList<String> tokens = new ArrayList<String>();
                String originalToken = (String)interner.computeIfAbsent(tokenAndTag[0], Function.identity());
                String tag = (String)interner.computeIfAbsent(tokenAndTag[1], Function.identity());
                tokens.add(originalToken);
                if (this.allowFirstCapitalized && !mFull.containsKey(tokenFirstCapitalized = StringTools.uppercaseFirstChar(originalToken)) && !originalToken.equals(tokenFirstCapitalized)) {
                    tokens.add(tokenFirstCapitalized);
                }
                if (this.allowAllUppercase && !mFull.containsKey(tokenAllUppercase = originalToken.toUpperCase()) && !originalToken.equals(tokenAllUppercase)) {
                    tokens.add(tokenAllUppercase);
                }
                for (String token : tokens) {
                    String firstToken;
                    String[] firstTokens;
                    boolean containsSpace;
                    boolean bl = containsSpace = token.indexOf(32) > 0;
                    if (!containsSpace) {
                        firstTokens = new String[tokenAndTag[0].length()];
                        firstToken = token.substring(0, 1);
                        for (int i2 = 1; i2 < token.length(); ++i2) {
                            firstTokens[i2] = token.substring(i2 - 1, i2);
                        }
                        if (mStartNoSpace.containsKey(firstToken)) {
                            if (mStartNoSpace.get(firstToken) < firstTokens.length) {
                                mStartNoSpace.put(firstToken, firstTokens.length);
                            }
                        } else {
                            mStartNoSpace.put(firstToken, firstTokens.length);
                        }
                    } else {
                        firstTokens = token.split(" ");
                        firstToken = firstTokens[0];
                        if (mStartSpace.containsKey(firstToken)) {
                            if (mStartSpace.get(firstToken) < firstTokens.length) {
                                mStartSpace.put(firstToken, firstTokens.length);
                            }
                        } else {
                            mStartSpace.put(firstToken, firstTokens.length);
                        }
                    }
                    mFull.put(token, new AnalyzedToken(token, tag, originalToken));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AnalyzedSentence disambiguate(AnalyzedSentence input2) throws IOException {
        return this.disambiguate(input2, null);
    }

    @Override
    public final AnalyzedSentence disambiguate(AnalyzedSentence input2, @Nullable JLanguageTool.CheckCancelledCallback checkCanceled) throws IOException {
        AnalyzedTokenReadings[] anTokens;
        this.lazyInit();
        AnalyzedTokenReadings[] output2 = anTokens = input2.getTokens();
        for (int i2 = 0; i2 < anTokens.length; ++i2) {
            String tok = output2[i2].getToken();
            if (tok.length() < 1) continue;
            if (i2 + 1 < anTokens.length && !anTokens[i2 + 1].isWhitespace()) {
                tok = tok + output2[i2 + 1].getToken();
            }
            if (checkCanceled != null && checkCanceled.checkCancelled()) break;
            StringBuilder tokens = new StringBuilder();
            int finalLen = 0;
            if (this.mStartSpace.containsKey(tok)) {
                int len = this.mStartSpace.get(tok);
                int j = i2;
                int lenCounter = 0;
                while (j < anTokens.length && j - i2 < 20) {
                    if (!anTokens[j].isWhitespace()) {
                        tokens.append(anTokens[j].getToken());
                        String toks = tokens.toString();
                        if (this.mFull.containsKey(toks)) {
                            output2[i2] = this.prepareNewReading(toks, output2[i2].getToken(), output2[i2], false);
                            output2[finalLen] = this.prepareNewReading(toks, anTokens[finalLen].getToken(), output2[finalLen], true);
                        }
                    } else {
                        if (j > 1 && !anTokens[j - 1].isWhitespace()) {
                            tokens.append(' ');
                            ++lenCounter;
                        }
                        if (lenCounter == len) break;
                    }
                    finalLen = ++j;
                }
            }
            if (!this.mStartNoSpace.containsKey(tok.substring(0, 1))) continue;
            for (int j = i2; j < anTokens.length && !anTokens[j].isWhitespace() && j - i2 < 20; ++j) {
                tokens.append(anTokens[j].getToken());
                String toks = tokens.toString();
                if (!this.mFull.containsKey(toks)) continue;
                output2[i2] = this.prepareNewReading(toks, anTokens[i2].getToken(), output2[i2], false);
                output2[j] = this.prepareNewReading(toks, anTokens[j].getToken(), output2[j], true);
            }
        }
        return new AnalyzedSentence(output2);
    }

    private AnalyzedTokenReadings prepareNewReading(String tokens, String tok, AnalyzedTokenReadings token, boolean isLast) {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        if (isLast) {
            sb.append('/');
        }
        sb.append(this.mFull.get(tokens).getPOSTag());
        sb.append('>');
        AnalyzedToken tokenStart = new AnalyzedToken(tok, sb.toString(), this.mFull.get(tokens).getLemma());
        return this.setAndAnnotate(token, tokenStart);
    }

    private AnalyzedTokenReadings setAndAnnotate(AnalyzedTokenReadings oldReading, AnalyzedToken newReading) {
        AnalyzedTokenReadings newAtr = oldReading;
        newAtr.addReading(newReading, "MULTIWORD_CHUNKER");
        return newAtr;
    }

    private List<String> loadWords(InputStream stream) {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            this.separator = DEFAULT_SEPARATOR;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#separatorRegExp=")) {
                    this.separator = line.replace("#separatorRegExp=", "");
                }
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                line = StringUtils.substringBefore((String)line, (String)"#").trim();
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return lines;
    }
}

