/*
 * Decompiled with CFR 0.152.
 */
package runtime.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import runtime.json.JsonObject;
import runtime.json.JsonObjectWrapper;
import runtime.json.RawJsonObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lruntime/json/JsonObjectSerializer;", "Lcom/fasterxml/jackson/databind/ser/std/StdSerializer;", "Lruntime/json/JsonObject;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "platform-runtime"})
public final class JsonObjectSerializer
extends StdSerializer<JsonObject> {
    @NotNull
    public static final JsonObjectSerializer INSTANCE = new JsonObjectSerializer();

    private JsonObjectSerializer() {
        super(JsonObject.class);
    }

    public void serialize(@NotNull JsonObject value2, @NotNull JsonGenerator gen, @NotNull SerializerProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        JsonObject jsonObject = value2;
        if (jsonObject instanceof RawJsonObject) {
            gen.writeRawValue(((RawJsonObject)value2).getSerialized());
        } else if (jsonObject instanceof JsonObjectWrapper) {
            gen.writeTree((TreeNode)((JsonObjectWrapper)value2).getNode());
        } else {
            throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Can't serialize ", (Object)value2.getClass().getCanonicalName()));
        }
    }
}

