/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.plugins.repository.vfs.VfsRepository;
import org.apache.ivy.plugins.resolver.LazyTimeoutConstraint;
import org.apache.ivy.plugins.resolver.RepositoryResolver;

public class VfsResolver
extends RepositoryResolver {
    private static final Pattern URL_PATTERN = Pattern.compile("[a-z]*://(.+):(.+)@.*");
    private static final int PASSWORD_GROUP = 2;

    public VfsResolver() {
        this.setRepository(new VfsRepository(new LazyTimeoutConstraint(this)));
    }

    @Override
    public String getTypeName() {
        return "vfs";
    }

    @Override
    public String hidePassword(String name2) {
        return VfsResolver.prepareForDisplay(name2);
    }

    public static String prepareForDisplay(String name2) {
        StringBuilder s = new StringBuilder(name2);
        Matcher m2 = URL_PATTERN.matcher(s);
        if (m2.matches()) {
            String password = m2.group(2);
            int passwordposi = s.indexOf(password);
            StringBuilder stars = new StringBuilder(password);
            for (int posi = 0; posi < password.length(); ++posi) {
                stars.setCharAt(posi, '*');
            }
            String replacement = stars.toString();
            s = s.replace(passwordposi, passwordposi + password.length(), replacement);
        }
        return s.toString();
    }
}

