/*
 * Decompiled with CFR 0.152.
 */
package libraries.collections;

import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Llibraries/collections/HashCommon;", "", "()V", "LONG_PHI", "", "arraySize", "", "expected", "f", "", "long2int", "l", "maxFill", "n", "mix", "x", "nextPowerOfTwo", "key", "libraries-collections"})
public final class HashCommon {
    @NotNull
    public static final HashCommon INSTANCE = new HashCommon();
    private static final long LONG_PHI = -7046029254386353131L;

    private HashCommon() {
    }

    public final int arraySize(int expected, float f) {
        long s = RangesKt.coerceAtLeast((long)2L, (long)this.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (!(s <= 0x40000000L)) {
            boolean bl = false;
            String string2 = "Too large (" + expected + " expected elements with load factor " + f + ')';
            throw new IllegalArgumentException(string2.toString());
        }
        return (int)s;
    }

    public final int maxFill(int n, float f) {
        return RangesKt.coerceAtMost((int)((int)Math.ceil((float)n * f)), (int)(n - 1));
    }

    public final long nextPowerOfTwo(long key2) {
        if (key2 == 0L) {
            return 1L;
        }
        long x2 = key2 - 1L;
        x2 |= x2 >> 1;
        x2 |= x2 >> 2;
        x2 |= x2 >> 4;
        x2 |= x2 >> 8;
        return (x2 | x2 >> 16) + 1L;
    }

    public final long mix(long x2) {
        long h = x2 * -7046029254386353131L;
        h ^= h >>> 32;
        return h ^ h >>> 16;
    }

    public final int long2int(long l) {
        return (int)(l ^ l >>> 32);
    }
}

