/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaSerializerBase;
import java.lang.reflect.Type;

public abstract class JodaDateSerializerBase<T>
extends JodaSerializerBase<T>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected static final int FORMAT_STRING = 1;
    protected static final int FORMAT_TIMESTAMP = 2;
    protected static final int FORMAT_ARRAY = 3;
    protected final JacksonJodaDateFormat _format;
    protected final SerializationFeature _featureForNumeric;
    protected final int _defaultNumericShape;
    protected final int _shapeOverride;

    protected JodaDateSerializerBase(Class<T> type, JacksonJodaDateFormat format2, SerializationFeature numericFeature, int defaultNumericShape, int shapeOverride) {
        super(type);
        this._format = format2;
        this._featureForNumeric = numericFeature;
        this._defaultNumericShape = defaultNumericShape;
        this._shapeOverride = shapeOverride;
    }

    public abstract JodaDateSerializerBase<T> withFormat(JacksonJodaDateFormat var1, int var2);

    public boolean isEmpty(SerializerProvider prov, T value2) {
        return value2 == null;
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property2) throws JsonMappingException {
        JsonFormat.Value ann = this.findFormatOverrides(prov, property2, this.handledType());
        if (ann != null) {
            int shapeOverride;
            Boolean useTimestamp;
            JsonFormat.Shape shape = ann.getShape();
            if (shape.isNumeric()) {
                useTimestamp = Boolean.TRUE;
                shapeOverride = 2;
            } else if (shape == JsonFormat.Shape.STRING) {
                useTimestamp = Boolean.FALSE;
                shapeOverride = 1;
            } else if (shape == JsonFormat.Shape.ARRAY) {
                useTimestamp = Boolean.TRUE;
                shapeOverride = 3;
            } else {
                useTimestamp = null;
                shapeOverride = this._shapeOverride;
            }
            JacksonJodaDateFormat format2 = this._format;
            if (useTimestamp != null) {
                format2 = format2.withUseTimestamp(useTimestamp);
            }
            if ((format2 = format2.with(ann)) != this._format || shapeOverride != this._shapeOverride) {
                return this.withFormat(format2, shapeOverride);
            }
        }
        return this;
    }

    public JsonNode getSchema(SerializerProvider provider2, Type typeHint) {
        switch (this._serializationShape(provider2)) {
            case 2: {
                return this.createSchemaNode("array", true);
            }
            case 3: {
                return this.createSchemaNode("number", true);
            }
        }
        return this.createSchemaNode("string", true);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        switch (this._serializationShape(visitor.getProvider())) {
            case 2: {
                JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
                if (v2 == null) break;
                v2.numberType(JsonParser.NumberType.LONG);
                v2.format(JsonValueFormat.UTC_MILLISEC);
                break;
            }
            case 3: {
                JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
                if (v2 == null) break;
                v2.itemsFormat(JsonFormatTypes.INTEGER);
                break;
            }
            default: {
                JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
                if (v2 == null) break;
                v2.format(JsonValueFormat.DATE_TIME);
            }
        }
    }

    protected boolean writeWithZoneId(SerializerProvider provider2) {
        return this._format.shouldWriteWithZoneId(provider2);
    }

    protected int _serializationShape(SerializerProvider provider2) {
        int shape = this._shapeOverride;
        if (shape == 0) {
            shape = this._format.useTimestamp(provider2, this._featureForNumeric) ? this._defaultNumericShape : 1;
        }
        return shape;
    }
}

