/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.floating;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 22\u00020\u0001:\u00042345B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H\u0014J\u0006\u0010(\u001a\u00020\"J\u0006\u0010)\u001a\u00020\u001cJ\b\u0010*\u001a\u00020\"H\u0002J\u0006\u0010+\u001a\u00020\"J\u0010\u0010,\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010-\u001a\u00020\"H\u0002J\u0006\u0010.\u001a\u00020\"J\u001c\u0010/\u001a\u00020\"2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"01H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0018R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "actionGroupId", "", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;)V", "<set-?>", "", "buttonSize", "getButtonSize", "()I", "setButtonSize", "(I)V", "buttonSize$delegate", "Lkotlin/properties/ReadWriteProperty;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "hint", "Lcom/intellij/ui/LightweightHint;", "keyboardListener", "Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$KeyboardListener;", "lastSelection", "mouseListener", "Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$MouseListener;", "mouseMotionListener", "Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$MouseMotionListener;", "canBeShownAtCurrentSelection", "", "createActionToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "targetComponent", "Ljavax/swing/JComponent;", "dispose", "", "getHintPosition", "Ljava/awt/Point;", "hasIgnoredParent", "element", "Lcom/intellij/psi/PsiElement;", "hideIfShown", "isShown", "registerListeners", "showIfHidden", "showOrUpdateLocation", "unregisterListeners", "updateLocationIfShown", "updateOnProbablyChangedSelection", "onSelectionChanged", "Lkotlin/Function1;", "Companion", "KeyboardListener", "MouseListener", "MouseMotionListener", "intellij.markdown.core"})
@ApiStatus.Internal
public class FloatingToolbar
implements Disposable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final MouseListener mouseListener;
    private final KeyboardListener keyboardListener;
    private final MouseMotionListener mouseMotionListener;
    private LightweightHint hint;
    private final ReadWriteProperty buttonSize$delegate;
    private String lastSelection;
    @NotNull
    private final Editor editor;
    private final String actionGroupId;
    private static final int verticalGap = 2;
    private static final List<IElementType> elementsToIgnore;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(FloatingToolbar.class, "buttonSize", "getButtonSize()I", 0))};
        Companion = new Companion(null);
        elementsToIgnore = CollectionsKt.listOf((Object[])new IElementType[]{MarkdownElementTypes.CODE_FENCE, MarkdownElementTypes.CODE_BLOCK, MarkdownElementTypes.CODE_SPAN, MarkdownElementTypes.HTML_BLOCK, MarkdownElementTypes.LINK_DESTINATION});
    }

    private final int getButtonSize() {
        return ((Number)this.buttonSize$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setButtonSize(int n) {
        this.buttonSize$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    public final boolean isShown() {
        return this.hint != null;
    }

    public final void hideIfShown() {
        block0: {
            LightweightHint lightweightHint = this.hint;
            if (lightweightHint == null) break block0;
            lightweightHint.hide();
        }
    }

    public final void showIfHidden() {
        if (this.hint != null || !this.canBeShownAtCurrentSelection()) {
            return;
        }
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.contentComponent");
        ActionToolbar actionToolbar2 = this.createActionToolbar(jComponent);
        if (actionToolbar2 == null) {
            return;
        }
        ActionToolbar toolbar2 = actionToolbar2;
        this.setButtonSize(toolbar2.getMaxButtonHeight());
        LightweightHint newHint = new LightweightHint(toolbar2.getComponent());
        newHint.setForceShowAsPopup(true);
        this.showOrUpdateLocation(newHint);
        newHint.addHintListener(new HintListener(this){
            final /* synthetic */ FloatingToolbar this$0;

            public final void hintHidden(@NotNull EventObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FloatingToolbar.access$setHint$p(this.this$0, null);
            }
            {
                this.this$0 = floatingToolbar;
            }
        });
        this.hint = newHint;
    }

    public final void updateLocationIfShown() {
        LightweightHint lightweightHint = this.hint;
        if (lightweightHint == null) {
            return;
        }
        this.showOrUpdateLocation(lightweightHint);
    }

    public void dispose() {
        this.unregisterListeners();
        this.hideIfShown();
        this.hint = null;
    }

    private final ActionToolbar createActionToolbar(JComponent targetComponent) {
        AnAction anAction = CustomActionsSchema.getInstance().getCorrectedAction(this.actionGroupId);
        if (!(anAction instanceof ActionGroup)) {
            anAction = null;
        }
        ActionGroup actionGroup = (ActionGroup)anAction;
        if (actionGroup == null) {
            return null;
        }
        ActionGroup group = actionGroup;
        ActionToolbarImpl toolbar2 = new ActionToolbarImpl(group, "EditorToolbar", group, true){
            final /* synthetic */ ActionGroup $group;

            public void addNotify() {
                super.addNotify();
                this.updateActionsImmediately(true);
            }
            {
                this.$group = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        toolbar2.setTargetComponent(targetComponent);
        toolbar2.setReservePlaceAutoPopupIcon(false);
        return (ActionToolbar)toolbar2;
    }

    private final void showOrUpdateLocation(LightweightHint hint) {
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, this.editor, this.getHintPosition(hint), 129, 0, true);
    }

    private final void registerListeners() {
        this.editor.addEditorMouseListener((EditorMouseListener)this.mouseListener);
        this.editor.addEditorMouseMotionListener((EditorMouseMotionListener)this.mouseMotionListener);
        this.editor.getContentComponent().addKeyListener(this.keyboardListener);
    }

    private final void unregisterListeners() {
        this.editor.removeEditorMouseListener((EditorMouseListener)this.mouseListener);
        this.editor.removeEditorMouseMotionListener((EditorMouseMotionListener)this.mouseMotionListener);
        this.editor.getContentComponent().removeKeyListener(this.keyboardListener);
    }

    private final boolean canBeShownAtCurrentSelection() {
        PsiFile psiFile = PsiEditorUtil.getPsiFile((Editor)this.editor);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiEditorUtil.getPsiFile(editor)");
        PsiFile file = psiFile;
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(this.editor.getDocument());
        SelectionModel selectionModel = this.editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
        SelectionModel selectionModel2 = selectionModel;
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)selectionModel2.getSelectionStart());
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiUtilCore.getElementAt\u2026tionModel.selectionStart)");
        PsiElement elementAtStart = psiElement;
        PsiElement psiElement2 = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)selectionModel2.getSelectionEnd());
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"PsiUtilCore.getElementAt\u2026ectionModel.selectionEnd)");
        PsiElement elementAtEnd = psiElement2;
        return !this.hasIgnoredParent(elementAtStart) && !this.hasIgnoredParent(elementAtEnd);
    }

    protected boolean hasIgnoredParent(@NotNull PsiElement element2) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            if (!(element2.getContainingFile() instanceof MarkdownFile)) {
                return true;
            }
            Sequence $this$any$iv = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!elementsToIgnore.contains(PsiTreeUtilKt.getElementType((PsiElement)it))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private final Point getHintPosition(LightweightHint hint) {
        Point hintPos = HintManagerImpl.getInstanceImpl().getHintPosition(hint, this.editor, (short)6);
        JComponent jComponent = hint.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"hint.component");
        int dy = -(jComponent.getPreferredSize().height + 2);
        int dx = this.getButtonSize() * -2;
        hintPos.translate(dx, dy);
        Point point = hintPos;
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"hintPos");
        return point;
    }

    private final void updateOnProbablyChangedSelection(Function1<? super String, Unit> onSelectionChanged) {
        String newSelection;
        SelectionModel selectionModel = this.editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
        String string = newSelection = selectionModel.getSelectedText();
        if (string == null) {
            this.hideIfShown();
        } else if (!Intrinsics.areEqual((Object)string, (Object)this.lastSelection)) {
            onSelectionChanged.invoke((Object)newSelection);
        }
        this.lastSelection = newSelection;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public FloatingToolbar(@NotNull Editor editor2, @NotNull String actionGroupId) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)actionGroupId, (String)"actionGroupId");
        this.editor = editor2;
        this.actionGroupId = actionGroupId;
        this.mouseListener = new MouseListener();
        this.keyboardListener = new KeyboardListener();
        this.mouseMotionListener = new MouseMotionListener();
        this.buttonSize$delegate = Delegates.INSTANCE.notNull();
        this.registerListeners();
    }

    public static final /* synthetic */ LightweightHint access$getHint$p(FloatingToolbar $this) {
        return $this.hint;
    }

    public static final /* synthetic */ void access$setHint$p(FloatingToolbar $this, LightweightHint lightweightHint) {
        $this.hint = lightweightHint;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$MouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "(Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar;)V", "mouseReleased", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.markdown.core"})
    private final class MouseListener
    implements EditorMouseListener {
        public void mouseReleased(@NotNull EditorMouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            FloatingToolbar.this.updateOnProbablyChangedSelection((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ MouseListener this$0;

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (this.this$0.FloatingToolbar.this.isShown()) {
                        this.this$0.FloatingToolbar.this.updateLocationIfShown();
                    } else {
                        this.this$0.FloatingToolbar.this.showIfHidden();
                    }
                }
                {
                    this.this$0 = mouseListener;
                    super(1);
                }
            }));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$KeyboardListener;", "Ljava/awt/event/KeyAdapter;", "(Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar;)V", "keyReleased", "", "e", "Ljava/awt/event/KeyEvent;", "intellij.markdown.core"})
    private final class KeyboardListener
    extends KeyAdapter {
        @Override
        public void keyReleased(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.keyReleased(e);
            if (Intrinsics.areEqual((Object)e.getSource(), (Object)FloatingToolbar.this.getEditor().getContentComponent()) ^ true) {
                return;
            }
            FloatingToolbar.this.updateOnProbablyChangedSelection((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ KeyboardListener this$0;

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.FloatingToolbar.this.hideIfShown();
                }
                {
                    this.this$0 = keyboardListener;
                    super(1);
                }
            }));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$MouseMotionListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "(Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar;)V", "mouseMoved", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.markdown.core"})
    private final class MouseMotionListener
    implements EditorMouseMotionListener {
        public void mouseMoved(@NotNull EditorMouseEvent e) {
            boolean hoverSelected;
            block4: {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                VisualPosition visualPosition = e.getVisualPosition();
                Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"e.visualPosition");
                VisualPosition visualPosition2 = visualPosition;
                CaretModel caretModel = FloatingToolbar.this.getEditor().getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                List list2 = caretModel.getAllCarets();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"editor.caretModel.allCarets");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Caret it = (Caret)element$iv;
                        boolean bl2 = false;
                        Caret caret = it;
                        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"it");
                        boolean beforeSelectionEnd = caret.getSelectionEndPosition().after(visualPosition2);
                        boolean afterSelectionStart = visualPosition2.after(it.getSelectionStartPosition());
                        if (!(beforeSelectionEnd && afterSelectionStart)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = hoverSelected = false;
                }
            }
            if (hoverSelected) {
                FloatingToolbar.this.showIfHidden();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$Companion;", "", "()V", "elementsToIgnore", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "verticalGap", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

