/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.suggesters;

import com.google.common.collect.EvictingQueue;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.featuresSuggester.FeatureSuggesterBundle;
import training.featuresSuggester.NoSuggestion;
import training.featuresSuggester.Suggestion;
import training.featuresSuggester.actions.Action;
import training.featuresSuggester.actions.EditorTextInsertedAction;
import training.featuresSuggester.suggesters.AbstractFeatureSuggester;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003123B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\u0019H\u0002J\u0014\u0010,\u001a\u00020-*\u00020.2\u0006\u0010/\u001a\u00020\u0014H\u0002J\u0012\u00100\u001a\u00020%*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\nR\u0014\u0010\u001c\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\nR\u0014\u0010\u001e\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\n\u00a8\u00064"}, d2={"Ltraining/featuresSuggester/suggesters/LineCommentingSuggester;", "Ltraining/featuresSuggester/suggesters/AbstractFeatureSuggester;", "()V", "commentsHistory", "Ljava/util/Queue;", "Ltraining/featuresSuggester/suggesters/LineCommentingSuggester$CommentData;", "getCommentsHistory$annotations", "id", "", "getId", "()Ljava/lang/String;", "languages", "", "getLanguages", "()Ljava/util/List;", "maxTimeMillisBetweenComments", "", "message", "getMessage", "minSuggestingIntervalDays", "", "getMinSuggestingIntervalDays", "()I", "numberOfCommentsToGetSuggestion", "prevCommentSymbolPlace", "Ltraining/featuresSuggester/suggesters/LineCommentingSuggester$CommentSymbolPlace;", "suggestingActionDisplayName", "getSuggestingActionDisplayName", "suggestingActionId", "getSuggestingActionId", "suggestingTipFileName", "getSuggestingTipFileName", "getSuggestion", "Ltraining/featuresSuggester/Suggestion;", "action", "Ltraining/featuresSuggester/actions/Action;", "isCommentSymbolAdded", "", "Ltraining/featuresSuggester/actions/EditorTextInsertedAction;", "symbol", "", "isSecondSlashAdded", "curAction", "prevSymbol", "getLineByOffset", "Ltraining/featuresSuggester/suggesters/LineCommentingSuggester$DocumentLine;", "Lcom/intellij/openapi/editor/Document;", "offset", "isLinesCommentedInARow", "CommentData", "CommentSymbolPlace", "DocumentLine", "intellij.featuresTrainer"})
public final class LineCommentingSuggester
extends AbstractFeatureSuggester {
    @NotNull
    private final String id;
    @NotNull
    private final String suggestingActionDisplayName = FeatureSuggesterBundle.INSTANCE.message("line.commenting.name", new Object[0]);
    @NotNull
    private final String message = FeatureSuggesterBundle.INSTANCE.message("line.commenting.message", new Object[0]);
    @NotNull
    private final String suggestingActionId;
    @NotNull
    private final String suggestingTipFileName;
    private final int minSuggestingIntervalDays;
    @NotNull
    private final List<String> languages = CollectionsKt.listOf((Object[])new String[]{"JAVA", "kotlin", "Python", "ECMAScript 6"});
    private final long maxTimeMillisBetweenComments;
    private final int numberOfCommentsToGetSuggestion;
    private final Queue<CommentData> commentsHistory;
    private CommentSymbolPlace prevCommentSymbolPlace;

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getSuggestingActionDisplayName() {
        return this.suggestingActionDisplayName;
    }

    @Override
    @NotNull
    protected String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    protected String getSuggestingActionId() {
        return this.suggestingActionId;
    }

    @Override
    @NotNull
    protected String getSuggestingTipFileName() {
        return this.suggestingTipFileName;
    }

    @Override
    public int getMinSuggestingIntervalDays() {
        return this.minSuggestingIntervalDays;
    }

    @Override
    @NotNull
    public List<String> getLanguages() {
        return this.languages;
    }

    private static /* synthetic */ void getCommentsHistory$annotations() {
    }

    @Override
    @NotNull
    public Suggestion getSuggestion(@NotNull Action action2) {
        block5: {
            block8: {
                block7: {
                    CommentSymbolPlace fileName2;
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                        if (!(action2 instanceof EditorTextInsertedAction)) break block5;
                        if (!this.isCommentSymbolAdded((EditorTextInsertedAction)action2, '/')) break block6;
                        Object object = ((EditorTextInsertedAction)action2).getPsiFile();
                        if (object == null || (object = object.getVirtualFile()) == null || (object = object.getPath()) == null) {
                            return NoSuggestion.INSTANCE;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"action.psiFile?.virtualF\u2026th ?: return NoSuggestion");
                        Object fileName2 = object;
                        this.prevCommentSymbolPlace = new CommentSymbolPlace(((EditorTextInsertedAction)action2).getCaretOffset(), (String)fileName2);
                        break block5;
                    }
                    CommentSymbolPlace commentSymbolPlace = this.prevCommentSymbolPlace;
                    if (commentSymbolPlace == null) break block7;
                    CommentSymbolPlace it = fileName2 = commentSymbolPlace;
                    boolean bl = false;
                    if (this.isSecondSlashAdded((EditorTextInsertedAction)action2, it)) break block8;
                }
                if (!this.isCommentSymbolAdded((EditorTextInsertedAction)action2, '#')) break block5;
            }
            Document document = ((EditorTextInsertedAction)action2).getDocument();
            CommentData commentData = new CommentData(document.getLineNumber(((EditorTextInsertedAction)action2).getCaretOffset()), new WeakReference<Document>(document), action2.getTimeMillis());
            this.commentsHistory.add(commentData);
            this.prevCommentSymbolPlace = null;
            if (this.commentsHistory.size() == this.numberOfCommentsToGetSuggestion && this.isLinesCommentedInARow(this.commentsHistory)) {
                this.commentsHistory.clear();
                return this.createSuggestion();
            }
        }
        return NoSuggestion.INSTANCE;
    }

    private final boolean isCommentSymbolAdded(EditorTextInsertedAction action2, char symbol) {
        EditorTextInsertedAction $this$with = action2;
        boolean bl = false;
        PsiFile psiFile2 = $this$with.getPsiFile();
        if (psiFile2 == null) {
            return false;
        }
        PsiFile psiFile3 = psiFile2;
        if (Intrinsics.areEqual((Object)$this$with.getText(), (Object)String.valueOf(symbol)) ^ true) {
            return false;
        }
        PsiElement psiElement = psiFile3.findElementAt($this$with.getCaretOffset());
        if (psiElement == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psiFile.findElementAt(caretOffset) ?: return false");
        PsiElement psiElement2 = psiElement;
        if (psiElement2 instanceof PsiComment || psiElement2.getNextSibling() instanceof PsiComment) {
            return false;
        }
        DocumentLine line = this.getLineByOffset($this$with.getDocument(), $this$with.getCaretOffset());
        String string = line.getText();
        int n = 0;
        int n2 = $this$with.getCaretOffset() - line.getStartOffset();
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String lineBeforeSlash = string2;
        return StringsKt.isBlank((CharSequence)lineBeforeSlash) && Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)(string = line.getText()))).toString(), (Object)String.valueOf(symbol)) ^ true;
    }

    private final boolean isSecondSlashAdded(EditorTextInsertedAction curAction, CommentSymbolPlace prevSymbol) {
        PsiFile psiFile2;
        int n;
        return Intrinsics.areEqual((Object)curAction.getText(), (Object)"/") && Math.abs(n = curAction.getCaretOffset() - prevSymbol.getOffset()) == 1 && Intrinsics.areEqual((Object)((psiFile2 = curAction.getPsiFile()) != null && (psiFile2 = psiFile2.getVirtualFile()) != null ? psiFile2.getPath() : null), (Object)prevSymbol.getFilePath());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLinesCommentedInARow(Queue<CommentData> $this$isLinesCommentedInARow) {
        boolean bl;
        List list2;
        boolean bl2;
        List list3;
        boolean bl3;
        Object next$iv;
        List list4;
        boolean bl4;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$isLinesCommentedInARow;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection = collection2;
            bl4 = false;
            Integer n = ((CommentData)receiver).getLineNumber();
            collection.add(n);
        }
        Iterable $this$zipWithNext$iv = CollectionsKt.sorted((Iterable)((List)collection2));
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list4 = CollectionsKt.emptyList();
        } else {
            List list5 = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void first;
                void second;
                next$iv = iterator$iv.next();
                int item$iv$iv = ((Number)next$iv).intValue();
                int receiver = ((Number)current$iv).intValue();
                collection = list5;
                boolean bl5 = false;
                Integer n = (int)(second - first);
                collection.add(n);
                current$iv = next$iv;
            }
            list4 = list5;
        }
        Iterable $this$any$iv = list4;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl3 = false;
        } else {
            for (Object t : $this$any$iv) {
                int it = ((Number)t).intValue();
                boolean bl6 = false;
                if (it != 1) {
                    return false;
                }
                boolean bl7 = false;
                if (!bl7) continue;
                return false;
            }
            bl3 = false;
        }
        if (bl3) return false;
        $this$map$iv = $this$isLinesCommentedInARow;
        $i$f$map = false;
        iterator$iv = $this$map$iv;
        Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CommentData first = (CommentData)item$iv$iv;
            collection = collection3;
            boolean bl8 = false;
            Document document = (Document)it.getDocumentRef().get();
            collection.add(document);
        }
        $this$zipWithNext$iv = (List)collection3;
        $i$f$zipWithNext = false;
        iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list3 = CollectionsKt.emptyList();
        } else {
            List list6 = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void second;
                void first;
                next$iv = iterator$iv.next();
                Document item$iv$iv = (Document)next$iv;
                Document it = (Document)current$iv;
                collection = list6;
                boolean bl9 = false;
                Boolean bl10 = first != null && first == second;
                collection.add(bl10);
                current$iv = next$iv;
            }
            list3 = list6;
        }
        $this$any$iv = list3;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object t : $this$any$iv) {
                boolean it = (Boolean)t;
                boolean bl11 = false;
                if (!it) {
                    return false;
                }
                boolean bl12 = false;
                if (!bl12) continue;
                return false;
            }
            bl2 = false;
        }
        if (bl2) return false;
        $this$map$iv = $this$isLinesCommentedInARow;
        $i$f$map = false;
        iterator$iv = $this$map$iv;
        Collection collection4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator bl11 = $this$mapTo$iv$iv.iterator();
        while (bl11.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object first = item$iv$iv = bl11.next();
            collection = collection4;
            bl4 = false;
            Long l = ((CommentData)receiver).getTimeMillis();
            collection.add(l);
        }
        $this$zipWithNext$iv = (List)collection4;
        $i$f$zipWithNext = false;
        iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list2 = CollectionsKt.emptyList();
        } else {
            List list7 = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void first;
                void second;
                Object next$iv2 = iterator$iv.next();
                long item$iv$iv = ((Number)next$iv2).longValue();
                long l = ((Number)current$iv).longValue();
                collection = list7;
                boolean bl13 = false;
                Long l2 = (long)(second - first);
                collection.add(l2);
                current$iv = next$iv2;
            }
            list2 = list7;
        }
        $this$any$iv = list2;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return true;
        }
        object = $this$any$iv.iterator();
        do {
            if (!object.hasNext()) return true;
            Object e = object.next();
            long it = ((Number)e).longValue();
            boolean bl14 = false;
            if (it > this.maxTimeMillisBetweenComments) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    private final DocumentLine getLineByOffset(Document $this$getLineByOffset, int offset) {
        int lineNumber = $this$getLineByOffset.getLineNumber(offset);
        int startOffset = $this$getLineByOffset.getLineStartOffset(lineNumber);
        int endOffset = $this$getLineByOffset.getLineEndOffset(lineNumber);
        String string = $this$getLineByOffset.getText(new TextRange(startOffset, endOffset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(TextRange(startOffset, endOffset))");
        return new DocumentLine(startOffset, endOffset, string);
    }

    public LineCommentingSuggester() {
        this.id = "Comment with line comment";
        this.suggestingActionId = "CommentByLineComment";
        this.suggestingTipFileName = "CommentCode.html";
        this.minSuggestingIntervalDays = 14;
        this.maxTimeMillisBetweenComments = 5000L;
        this.numberOfCommentsToGetSuggestion = 3;
        EvictingQueue evictingQueue = EvictingQueue.create((int)this.numberOfCommentsToGetSuggestion);
        Intrinsics.checkNotNullExpressionValue((Object)evictingQueue, (String)"EvictingQueue.create(num\u2026fCommentsToGetSuggestion)");
        this.commentsHistory = (Queue)evictingQueue;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Ltraining/featuresSuggester/suggesters/LineCommentingSuggester$DocumentLine;", "", "startOffset", "", "endOffset", "text", "", "(IILjava/lang/String;)V", "getEndOffset", "()I", "getStartOffset", "getText", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.featuresTrainer"})
    private static final class DocumentLine {
        private final int startOffset;
        private final int endOffset;
        @NotNull
        private final String text;

        public final int getStartOffset() {
            return this.startOffset;
        }

        public final int getEndOffset() {
            return this.endOffset;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public DocumentLine(int startOffset, int endOffset, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.text = text2;
        }

        public final int component1() {
            return this.startOffset;
        }

        public final int component2() {
            return this.endOffset;
        }

        @NotNull
        public final String component3() {
            return this.text;
        }

        @NotNull
        public final DocumentLine copy(int startOffset, int endOffset, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return new DocumentLine(startOffset, endOffset, text2);
        }

        public static /* synthetic */ DocumentLine copy$default(DocumentLine documentLine, int n, int n2, String string, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = documentLine.startOffset;
            }
            if ((n3 & 2) != 0) {
                n2 = documentLine.endOffset;
            }
            if ((n3 & 4) != 0) {
                string = documentLine.text;
            }
            return documentLine.copy(n, n2, string);
        }

        @NotNull
        public String toString() {
            return "DocumentLine(startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", text=" + this.text + ")";
        }

        public int hashCode() {
            String string = this.text;
            return (Integer.hashCode(this.startOffset) * 31 + Integer.hashCode(this.endOffset)) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DocumentLine)) break block3;
                    DocumentLine documentLine = (DocumentLine)object;
                    if (this.startOffset != documentLine.startOffset || this.endOffset != documentLine.endOffset || !Intrinsics.areEqual((Object)this.text, (Object)documentLine.text)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Ltraining/featuresSuggester/suggesters/LineCommentingSuggester$CommentData;", "", "lineNumber", "", "documentRef", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/editor/Document;", "timeMillis", "", "(ILjava/lang/ref/WeakReference;J)V", "getDocumentRef", "()Ljava/lang/ref/WeakReference;", "getLineNumber", "()I", "getTimeMillis", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.featuresTrainer"})
    private static final class CommentData {
        private final int lineNumber;
        @NotNull
        private final WeakReference<Document> documentRef;
        private final long timeMillis;

        public final int getLineNumber() {
            return this.lineNumber;
        }

        @NotNull
        public final WeakReference<Document> getDocumentRef() {
            return this.documentRef;
        }

        public final long getTimeMillis() {
            return this.timeMillis;
        }

        public CommentData(int lineNumber, @NotNull WeakReference<Document> documentRef, long timeMillis) {
            Intrinsics.checkNotNullParameter(documentRef, (String)"documentRef");
            this.lineNumber = lineNumber;
            this.documentRef = documentRef;
            this.timeMillis = timeMillis;
        }

        public final int component1() {
            return this.lineNumber;
        }

        @NotNull
        public final WeakReference<Document> component2() {
            return this.documentRef;
        }

        public final long component3() {
            return this.timeMillis;
        }

        @NotNull
        public final CommentData copy(int lineNumber, @NotNull WeakReference<Document> documentRef, long timeMillis) {
            Intrinsics.checkNotNullParameter(documentRef, (String)"documentRef");
            return new CommentData(lineNumber, documentRef, timeMillis);
        }

        public static /* synthetic */ CommentData copy$default(CommentData commentData, int n, WeakReference weakReference, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = commentData.lineNumber;
            }
            if ((n2 & 2) != 0) {
                weakReference = commentData.documentRef;
            }
            if ((n2 & 4) != 0) {
                l = commentData.timeMillis;
            }
            return commentData.copy(n, weakReference, l);
        }

        @NotNull
        public String toString() {
            return "CommentData(lineNumber=" + this.lineNumber + ", documentRef=" + this.documentRef + ", timeMillis=" + this.timeMillis + ")";
        }

        public int hashCode() {
            WeakReference<Document> weakReference = this.documentRef;
            return (Integer.hashCode(this.lineNumber) * 31 + (weakReference != null ? weakReference.hashCode() : 0)) * 31 + Long.hashCode(this.timeMillis);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CommentData)) break block3;
                    CommentData commentData = (CommentData)object;
                    if (this.lineNumber != commentData.lineNumber || !Intrinsics.areEqual(this.documentRef, commentData.documentRef) || this.timeMillis != commentData.timeMillis) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Ltraining/featuresSuggester/suggesters/LineCommentingSuggester$CommentSymbolPlace;", "", "offset", "", "filePath", "", "(ILjava/lang/String;)V", "getFilePath", "()Ljava/lang/String;", "getOffset", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.featuresTrainer"})
    private static final class CommentSymbolPlace {
        private final int offset;
        @NotNull
        private final String filePath;

        public final int getOffset() {
            return this.offset;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        public CommentSymbolPlace(int offset, @NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.offset = offset;
            this.filePath = filePath;
        }

        public final int component1() {
            return this.offset;
        }

        @NotNull
        public final String component2() {
            return this.filePath;
        }

        @NotNull
        public final CommentSymbolPlace copy(int offset, @NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return new CommentSymbolPlace(offset, filePath);
        }

        public static /* synthetic */ CommentSymbolPlace copy$default(CommentSymbolPlace commentSymbolPlace, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = commentSymbolPlace.offset;
            }
            if ((n2 & 2) != 0) {
                string = commentSymbolPlace.filePath;
            }
            return commentSymbolPlace.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "CommentSymbolPlace(offset=" + this.offset + ", filePath=" + this.filePath + ")";
        }

        public int hashCode() {
            String string = this.filePath;
            return Integer.hashCode(this.offset) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CommentSymbolPlace)) break block3;
                    CommentSymbolPlace commentSymbolPlace = (CommentSymbolPlace)object;
                    if (this.offset != commentSymbolPlace.offset || !Intrinsics.areEqual((Object)this.filePath, (Object)commentSymbolPlace.filePath)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

