/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.function.UnaryOperator;
import org.assertj.core.annotations.Beta;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.error.ShouldBeUnmodifiable;

public abstract class AbstractCollectionAssert<SELF extends AbstractCollectionAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT>, ACTUAL extends Collection<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>>
extends AbstractIterableAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT> {
    protected AbstractCollectionAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Beta
    public SELF isUnmodifiable() {
        this.isNotNull();
        this.assertIsUnmodifiable();
        return (SELF)((AbstractCollectionAssert)this.myself);
    }

    private void assertIsUnmodifiable() {
        this.expectUnsupportedOperationException(() -> ((Collection)this.actual).add(null), "Collection.add(null)");
        this.expectUnsupportedOperationException(() -> ((Collection)this.actual).addAll(this.emptyCollection()), "Collection.addAll(emptyCollection())");
        this.expectUnsupportedOperationException(() -> ((Collection)this.actual).clear(), "Collection.clear()");
        this.expectUnsupportedOperationException(() -> ((Collection)this.actual).iterator().remove(), "Collection.iterator().remove()");
        this.expectUnsupportedOperationException(() -> ((Collection)this.actual).remove(null), "Collection.remove(null)");
        this.expectUnsupportedOperationException(() -> ((Collection)this.actual).removeAll(this.emptyCollection()), "Collection.removeAll(emptyCollection())");
        this.expectUnsupportedOperationException(() -> ((Collection)this.actual).removeIf(element -> true), "Collection.removeIf(element -> true)");
        this.expectUnsupportedOperationException(() -> ((Collection)this.actual).retainAll(this.emptyCollection()), "Collection.retainAll(emptyCollection())");
        if (this.actual instanceof List) {
            List list2 = (List)this.actual;
            this.expectUnsupportedOperationException(() -> list2.add(0, null), "List.add(0, null)");
            this.expectUnsupportedOperationException(() -> list2.addAll(0, this.emptyCollection()), "List.addAll(0, emptyCollection())");
            this.expectUnsupportedOperationException(() -> list2.listIterator().add(null), "List.listIterator().add(null)");
            this.expectUnsupportedOperationException(() -> list2.listIterator().remove(), "List.listIterator().remove()");
            this.expectUnsupportedOperationException(() -> list2.listIterator().set(null), "List.listIterator().set(null)");
            this.expectUnsupportedOperationException(() -> list2.remove(0), "List.remove(0)");
            this.expectUnsupportedOperationException(() -> list2.replaceAll(UnaryOperator.identity()), "List.replaceAll(identity())");
            this.expectUnsupportedOperationException(() -> list2.set(0, null), "List.set(0, null)");
            this.expectUnsupportedOperationException(() -> list2.sort((o1, o2) -> 0), "List.sort((o1, o2) -> 0)");
        }
        if (this.actual instanceof NavigableSet) {
            NavigableSet set = (NavigableSet)this.actual;
            this.expectUnsupportedOperationException(() -> set.descendingIterator().remove(), "NavigableSet.descendingIterator().remove()");
            this.expectUnsupportedOperationException(() -> set.pollFirst(), "NavigableSet.pollFirst()");
            this.expectUnsupportedOperationException(() -> set.pollLast(), "NavigableSet.pollLast()");
        }
    }

    private void expectUnsupportedOperationException(Runnable runnable, String method) {
        try {
            runnable.run();
            this.throwAssertionError(ShouldBeUnmodifiable.shouldBeUnmodifiable(method));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (RuntimeException e) {
            this.throwAssertionError(ShouldBeUnmodifiable.shouldBeUnmodifiable(method, e));
        }
    }

    private <E extends ELEMENT> Collection<E> emptyCollection() {
        return Collections.emptyList();
    }
}

