/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActivityImpl
implements Activity {
    private final String name;
    private String description;
    private String threadName;
    private long threadId;
    private final long start;
    private long end;
    private final ActivityImpl parent;
    @Nullable
    private final ActivityCategory category;
    @Nullable
    private final String pluginId;
    @ApiStatus.Internal
    public static volatile Consumer<ActivityImpl> listener;

    ActivityImpl(@Nullable String name, long start, @Nullable ActivityImpl parent, @Nullable String pluginId) {
        this(name, start, parent, pluginId, null);
    }

    ActivityImpl(@Nullable String name, long start, @Nullable ActivityImpl parent, @Nullable String pluginId, @Nullable ActivityCategory category) {
        this.name = name;
        this.start = start;
        this.parent = parent;
        this.pluginId = pluginId;
        this.category = category;
        this.updateThreadName();
        Consumer<ActivityImpl> listener = ActivityImpl.listener;
        if (listener != null) {
            listener.accept(this);
        }
    }

    @NotNull
    public String getThreadName() {
        String string2 = this.threadName;
        if (string2 == null) {
            ActivityImpl.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    public void updateThreadName() {
        Thread thread = Thread.currentThread();
        this.threadId = thread.getId();
        this.threadName = thread.getName();
    }

    public long getThreadId() {
        return this.threadId;
    }

    @Nullable
    public ActivityImpl getParent() {
        return this.parent;
    }

    @Nullable
    public ActivityCategory getCategory() {
        return this.category;
    }

    @Override
    @NotNull
    public ActivityImpl startChild(@NotNull String name) {
        if (name == null) {
            ActivityImpl.$$$reportNull$$$0(1);
        }
        return new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), this, this.pluginId, this.category);
    }

    @NotNull
    public String getName() {
        String string2 = this.name;
        if (string2 == null) {
            ActivityImpl.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getPluginId() {
        return this.pluginId;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    void setEnd(long end) {
        assert (this.end == 0L);
        this.end = end;
    }

    @Override
    public void end() {
        assert (this.end == 0L) : "not started or already ended";
        this.end = StartUpMeasurer.getCurrentTime();
        StartUpMeasurer.addActivity(this);
        Consumer<ActivityImpl> listener = ActivityImpl.listener;
        if (listener != null) {
            listener.accept(this);
        }
    }

    @Override
    public void setDescription(@NotNull String value) {
        if (value == null) {
            ActivityImpl.$$$reportNull$$$0(3);
        }
        this.description = value;
    }

    @Override
    @NotNull
    public Activity endAndStart(@NotNull String name) {
        if (name == null) {
            ActivityImpl.$$$reportNull$$$0(4);
        }
        this.end();
        return new ActivityImpl(name, this.end, this.parent, this.pluginId, this.category);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ActivityImpl(name=").append(this.name).append(", start=");
        ActivityImpl.nanoToString(this.start, builder);
        builder.append(", end=");
        ActivityImpl.nanoToString(this.end, builder);
        builder.append(", category=").append((Object)this.category).append(")");
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void nanoToString(long start, @NotNull StringBuilder stringBuilder) {
        void builder;
        if (stringBuilder == null) {
            ActivityImpl.$$$reportNull$$$0(5);
        }
        builder.append(TimeUnit.NANOSECONDS.toMillis(start - StartUpMeasurer.getStartTime())).append("ms (").append(TimeUnit.NANOSECONDS.toMicros(start - StartUpMeasurer.getStartTime())).append("\u03bcs)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/ActivityImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/ActivityImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startChild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "endAndStart";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "nanoToString";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

