/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.toml;

import java.time.LocalTime;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.apache.tuweni.toml.TomlParseError;
import org.apache.tuweni.toml.TomlPosition;
import org.apache.tuweni.toml.internal.TomlParser;
import org.apache.tuweni.toml.internal.TomlParserBaseVisitor;

final class LocalTimeVisitor
extends TomlParserBaseVisitor<LocalTime> {
    private LocalTime time = LocalTime.MIN;

    LocalTimeVisitor() {
    }

    @Override
    public LocalTime visitHour(TomlParser.HourContext ctx) {
        int hour;
        String text2 = ctx.getText();
        if (text2.length() != 2) {
            throw new TomlParseError("Invalid hour (valid range 00..23)", new TomlPosition(ctx));
        }
        try {
            hour = Integer.parseInt(text2);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid hour", new TomlPosition(ctx), e);
        }
        if (hour < 0 || hour > 23) {
            throw new TomlParseError("Invalid hour (valid range 00..23)", new TomlPosition(ctx));
        }
        this.time = this.time.withHour(hour);
        return this.time;
    }

    @Override
    public LocalTime visitMinute(TomlParser.MinuteContext ctx) {
        int minute;
        String text2 = ctx.getText();
        if (text2.length() != 2) {
            throw new TomlParseError("Invalid minutes (valid range 00..59)", new TomlPosition(ctx));
        }
        try {
            minute = Integer.parseInt(text2);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid minutes", new TomlPosition(ctx), e);
        }
        if (minute < 0 || minute > 59) {
            throw new TomlParseError("Invalid minutes (valid range 00..59)", new TomlPosition(ctx));
        }
        this.time = this.time.withMinute(minute);
        return this.time;
    }

    @Override
    public LocalTime visitSecond(TomlParser.SecondContext ctx) {
        int second;
        String text2 = ctx.getText();
        if (text2.length() != 2) {
            throw new TomlParseError("Invalid seconds (valid range 00..59)", new TomlPosition(ctx));
        }
        try {
            second = Integer.parseInt(text2);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid seconds", new TomlPosition(ctx), e);
        }
        if (second < 0 || second > 59) {
            throw new TomlParseError("Invalid seconds (valid range 00..59)", new TomlPosition(ctx));
        }
        this.time = this.time.withSecond(second);
        return this.time;
    }

    @Override
    public LocalTime visitSecondFraction(TomlParser.SecondFractionContext ctx) {
        int nano;
        Object text2 = ctx.getText();
        if (((String)text2).isEmpty() || ((String)text2).length() > 9) {
            throw new TomlParseError("Invalid nanoseconds (valid range 0..999999999)", new TomlPosition(ctx));
        }
        if (((String)text2).length() < 9) {
            text2 = (String)text2 + "000000000".substring(((String)text2).length());
        }
        try {
            nano = Integer.parseInt((String)text2);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid nanoseconds", new TomlPosition(ctx), e);
        }
        this.time = this.time.withNano(nano);
        return this.time;
    }

    @Override
    public LocalTime visitErrorNode(ErrorNode node) {
        return null;
    }

    @Override
    protected LocalTime aggregateResult(LocalTime aggregate, LocalTime nextResult) {
        return aggregate == null ? null : nextResult;
    }

    @Override
    protected LocalTime defaultResult() {
        return this.time;
    }
}

