/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.toml;

import java.time.DateTimeException;
import java.time.LocalDate;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.apache.tuweni.toml.TomlParseError;
import org.apache.tuweni.toml.TomlPosition;
import org.apache.tuweni.toml.internal.TomlParser;
import org.apache.tuweni.toml.internal.TomlParserBaseVisitor;

final class LocalDateVisitor
extends TomlParserBaseVisitor<LocalDate> {
    private static LocalDate INITIAL = LocalDate.parse("1900-01-01");
    private LocalDate date = INITIAL;

    LocalDateVisitor() {
    }

    @Override
    public LocalDate visitYear(TomlParser.YearContext ctx) {
        int year;
        String text2 = ctx.getText();
        if (text2.length() != 4) {
            throw new TomlParseError("Invalid year (valid range 0000..9999)", new TomlPosition(ctx));
        }
        try {
            year = Integer.parseInt(text2);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid year", new TomlPosition(ctx), e);
        }
        this.date = this.date.withYear(year);
        return this.date;
    }

    @Override
    public LocalDate visitMonth(TomlParser.MonthContext ctx) {
        int month;
        String text2 = ctx.getText();
        if (text2.length() != 2) {
            throw new TomlParseError("Invalid month (valid range 01..12)", new TomlPosition(ctx));
        }
        try {
            month = Integer.parseInt(text2);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid month", new TomlPosition(ctx), e);
        }
        if (month < 1 || month > 12) {
            throw new TomlParseError("Invalid month (valid range 01..12)", new TomlPosition(ctx));
        }
        this.date = this.date.withMonth(month);
        return this.date;
    }

    @Override
    public LocalDate visitDay(TomlParser.DayContext ctx) {
        int day;
        String text2 = ctx.getText();
        if (text2.length() != 2) {
            throw new TomlParseError("Invalid day (valid range 01..28/31)", new TomlPosition(ctx));
        }
        try {
            day = Integer.parseInt(text2);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid day", new TomlPosition(ctx), e);
        }
        if (day < 1 || day > 31) {
            throw new TomlParseError("Invalid day (valid range 01..28/31)", new TomlPosition(ctx));
        }
        try {
            this.date = this.date.withDayOfMonth(day);
        }
        catch (DateTimeException e) {
            throw new TomlParseError(e.getMessage(), new TomlPosition(ctx), e);
        }
        return this.date;
    }

    @Override
    public LocalDate visitErrorNode(ErrorNode node) {
        return null;
    }

    @Override
    protected LocalDate aggregateResult(LocalDate aggregate, LocalDate nextResult) {
        return aggregate == null ? null : nextResult;
    }

    @Override
    protected LocalDate defaultResult() {
        return this.date;
    }
}

