/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.pipenv;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyPackageRequirementsInspection;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/sdk/pipenv/PipEnvInstallQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "Companion", "intellij.python.community.impl"})
public final class PipEnvInstallQuickFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("python.sdk.install.requirements.from.pipenv.lock", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyBundle.message(\"python\u2026ements.from.pipenv.lock\")");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026lement(element) ?: return");
        Module module2 = module;
        Companion.pipEnvInstall(project, module2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/sdk/pipenv/PipEnvInstallQuickFix$Companion;", "", "()V", "pipEnvInstall", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.python.community.impl"})
    public static final class Companion {
        public final void pipEnvInstall(@NotNull Project project, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Sdk sdk = PySdkExtKt.getPythonSdk(module);
            if (sdk == null) {
                return;
            }
            Sdk sdk2 = sdk;
            if (!PipenvKt.isPipEnv(sdk2)) {
                return;
            }
            PyPackageRequirementsInspection.RunningPackagingTasksListener listener2 = new PyPackageRequirementsInspection.RunningPackagingTasksListener(module);
            PyPackageManagerUI ui2 = new PyPackageManagerUI(project, sdk2, listener2);
            ui2.install(null, CollectionsKt.listOf((Object)"--dev"));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

