/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PyVirtualEnvReader;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PySdkUtil {
    private static final Logger LOG = Logger.getInstance(PySdkUtil.class);
    public static final int SUBSTITUTE = 26;
    public static final String PATH_ENV_VARIABLE = "PATH";
    private static final Key<Map<String, String>> ENVIRONMENT_KEY = Key.create((String)"ENVIRONMENT_KEY");

    private PySdkUtil() {
    }

    public static void configureCharset(@NotNull GeneralCommandLine commandLine) {
        Charset charset;
        if (commandLine == null) {
            PySdkUtil.$$$reportNull$$$0(0);
        }
        if ((charset = commandLine.getCharset()) != Charsets.UTF_8) {
            LOG.warn("Charset " + charset + " is not UTF-8, which is likely lead to troubles");
        }
        PythonEnvUtil.setupEncodingEnvs(commandLine.getEnvironment(), charset);
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath2, @NonNls String[] command) {
        return PySdkUtil.getProcessOutput(homePath2, command, -1);
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath2, @NonNls String[] command, int timeout) {
        return PySdkUtil.getProcessOutput(homePath2, command, null, timeout);
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath2, @NonNls String[] command, @Nullable @NonNls Map<String, String> extraEnv, int timeout) {
        return PySdkUtil.getProcessOutput(homePath2, command, extraEnv, timeout, null, true);
    }

    @NotNull
    public static ProcessOutput getProcessOutput(String homePath2, @NonNls String[] command, @Nullable @NonNls Map<String, String> extraEnv, int timeout, byte @Nullable [] stdin, boolean needEOFMarker) {
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(new GeneralCommandLine(command), homePath2, extraEnv, timeout, stdin, needEOFMarker);
        if (processOutput == null) {
            PySdkUtil.$$$reportNull$$$0(1);
        }
        return processOutput;
    }

    public static ProcessOutput getProcessOutput(@NotNull GeneralCommandLine cmd, @Nullable String homePath2, @Nullable @NonNls Map<String, String> extraEnv, int timeout) {
        if (cmd == null) {
            PySdkUtil.$$$reportNull$$$0(2);
        }
        return PySdkUtil.getProcessOutput(cmd, homePath2, extraEnv, timeout, null, true);
    }

    public static ProcessOutput getProcessOutput(@NotNull GeneralCommandLine cmd, @Nullable String homePath2, @Nullable @NonNls Map<String, String> extraEnv, int timeout, byte @Nullable [] stdin, boolean needEOFMarker) {
        if (cmd == null) {
            PySdkUtil.$$$reportNull$$$0(3);
        }
        if (homePath2 == null || !new File(homePath2).exists()) {
            return new ProcessOutput();
        }
        Map<String, String> systemEnv = System.getenv();
        Map<String, String> expandedCmdEnv = PySdkUtil.mergeEnvVariables(systemEnv, cmd.getEnvironment());
        Map<String, String> env = extraEnv != null ? PySdkUtil.mergeEnvVariables(expandedCmdEnv, extraEnv) : expandedCmdEnv;
        PythonEnvUtil.resetHomePathChanges(homePath2, env);
        try {
            CommandLinePatcher cmdLinePatcher;
            GeneralCommandLine commandLine = cmd.withWorkDirectory(homePath2).withEnvironment(env);
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(commandLine.getExePath());
            CommandLinePatcher commandLinePatcher = cmdLinePatcher = flavor != null ? flavor.commandLinePatcher() : null;
            if (cmdLinePatcher != null) {
                cmdLinePatcher.patchCommandLine(cmd);
            }
            PythonEnvUtil.setupEncodingEnvs(commandLine.getEnvironment(), commandLine.getCharset());
            CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
            if (stdin != null) {
                OutputStream processInput = processHandler.getProcessInput();
                assert (processInput != null);
                processInput.write(stdin);
                if (SystemInfo.isWindows && needEOFMarker) {
                    processInput.write(26);
                    processInput.flush();
                } else {
                    processInput.close();
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                ProgressManager progressManager = ProgressManager.getInstance();
                Application application = ApplicationManager.getApplication();
                assert (application.isUnitTestMode() || application.isHeadlessEnvironment() || !application.isWriteAccessAllowed()) : "Background task can't be run under write action";
                return (ProcessOutput)progressManager.runProcessWithProgressSynchronously(() -> processHandler.runProcess(timeout), PySdkBundle.message("python.sdk.run.wait", new Object[0]), false, null);
            }
            return processHandler.runProcess();
        }
        catch (ExecutionException | IOException e) {
            return PySdkUtil.getOutputForException((Exception)e);
        }
    }

    private static ProcessOutput getOutputForException(final Exception e) {
        LOG.warn((Throwable)e);
        return new ProcessOutput(){

            @NotNull
            public String getStderr() {
                Object err = super.getStderr();
                err = !StringUtil.isEmpty((String)err) ? (String)err + "\n" + e.getMessage() : e.getMessage();
                String string = err;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/PySdkUtil$1", "getStderr"));
            }
        };
    }

    @NotNull
    public static Map<String, String> mergeEnvVariables(@NotNull Map<String, String> environment, @NotNull Map<String, String> extraEnvironment) {
        if (environment == null) {
            PySdkUtil.$$$reportNull$$$0(4);
        }
        if (extraEnvironment == null) {
            PySdkUtil.$$$reportNull$$$0(5);
        }
        HashMap<String, String> result = new HashMap<String, String>(environment);
        for (Map.Entry<String, String> entry : extraEnvironment.entrySet()) {
            String name2 = entry.getKey();
            if (PATH_ENV_VARIABLE.equals(name2) || "PYTHONPATH".equals(name2)) {
                PythonEnvUtil.addPathToEnv(result, name2, entry.getValue());
                continue;
            }
            result.put(name2, entry.getValue());
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            PySdkUtil.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    @NotNull
    public static Map<String, String> activateVirtualEnv(@NotNull Sdk sdk) {
        Map cached;
        if (sdk == null) {
            PySdkUtil.$$$reportNull$$$0(7);
        }
        if ((cached = (Map)sdk.getUserData(ENVIRONMENT_KEY)) != null) {
            Map map2 = cached;
            if (map2 == null) {
                PySdkUtil.$$$reportNull$$$0(8);
            }
            return map2;
        }
        String sdkHome = sdk.getHomePath();
        if (sdkHome == null) {
            Map<String, String> map3 = Collections.emptyMap();
            if (map3 == null) {
                PySdkUtil.$$$reportNull$$$0(9);
            }
            return map3;
        }
        Map<String, String> environment = PySdkUtil.activateVirtualEnv(sdkHome);
        sdk.putUserData(ENVIRONMENT_KEY, environment);
        Map<String, String> map4 = environment;
        if (map4 == null) {
            PySdkUtil.$$$reportNull$$$0(10);
        }
        return map4;
    }

    @NotNull
    public static Map<String, String> activateVirtualEnv(@NotNull String sdkHome) {
        PyVirtualEnvReader reader;
        if (sdkHome == null) {
            PySdkUtil.$$$reportNull$$$0(11);
        }
        if ((reader = new PyVirtualEnvReader(sdkHome)).getActivate() != null) {
            Map<String, String> map2;
            try {
                map2 = Collections.unmodifiableMap(PyVirtualEnvReader.Companion.filterVirtualEnvVars(reader.readPythonEnv()));
            }
            catch (Exception e) {
                LOG.error("Couldn't read virtualenv variables", (Throwable)e);
            }
            if (map2 == null) {
                PySdkUtil.$$$reportNull$$$0(12);
            }
            return map2;
        }
        Map<String, String> map3 = Collections.emptyMap();
        if (map3 == null) {
            PySdkUtil.$$$reportNull$$$0(13);
        }
        return map3;
    }

    @NotNull
    public static LanguageLevel getLanguageLevelForSdk(@Nullable Sdk sdk) {
        PythonSdkFlavor flavor;
        if (sdk != null && PythonSdkUtil.isPythonSdk(sdk) && (flavor = PythonSdkFlavor.getFlavor(sdk)) != null) {
            LanguageLevel languageLevel = flavor.getLanguageLevel(sdk);
            if (languageLevel == null) {
                PySdkUtil.$$$reportNull$$$0(14);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PySdkUtil.$$$reportNull$$$0(15);
        }
        return languageLevel;
    }

    @NotNull
    @NonNls
    public static String getBuiltinsFileName(@NotNull Sdk sdk) {
        if (sdk == null) {
            PySdkUtil.$$$reportNull$$$0(16);
        }
        String string = PyBuiltinCache.getBuiltinsFileName(PySdkUtil.getLanguageLevelForSdk(sdk));
        if (string == null) {
            PySdkUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    public static Sdk findSdkForDirectory(@NotNull Project project, @NotNull Path workingDirectory, boolean allowRemote) {
        Sdk sdk;
        VirtualFile workingDirectoryVirtualFile;
        if (project == null) {
            PySdkUtil.$$$reportNull$$$0(18);
        }
        if (workingDirectory == null) {
            PySdkUtil.$$$reportNull$$$0(19);
        }
        if ((workingDirectoryVirtualFile = LocalFileSystem.getInstance().findFileByNioFile(workingDirectory)) != null && (sdk = PySdkUtil.getLocalSdkForFile(project, workingDirectoryVirtualFile, allowRemote)) != null) {
            return sdk;
        }
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk2 = PythonSdkUtil.findPythonSdk(m);
            if (sdk2 == null || !allowRemote && PythonSdkUtil.isRemote(sdk2)) continue;
            return sdk2;
        }
        return null;
    }

    @Nullable
    private static Sdk getLocalSdkForFile(@NotNull Project project, @NotNull VirtualFile workingDirectoryVirtualFile, boolean allowRemote) {
        Sdk sdk;
        Module module;
        if (project == null) {
            PySdkUtil.$$$reportNull$$$0(20);
        }
        if (workingDirectoryVirtualFile == null) {
            PySdkUtil.$$$reportNull$$$0(21);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)workingDirectoryVirtualFile, (Project)project)) != null && (sdk = PythonSdkUtil.findPythonSdk(module)) != null && (allowRemote || !PythonSdkUtil.isRemote(sdk))) {
            return sdk;
        }
        return null;
    }

    @Nullable
    public static Sdk findSdkForDirectory(@NotNull Project project, String workingDirectory) {
        Sdk sdk;
        VirtualFile workingDirectoryVirtualFile;
        if (project == null) {
            PySdkUtil.$$$reportNull$$$0(22);
        }
        if ((workingDirectoryVirtualFile = LocalFileSystem.getInstance().findFileByPath(workingDirectory)) != null && (sdk = PySdkUtil.getLocalSdkForFile(project, workingDirectoryVirtualFile)) != null) {
            return sdk;
        }
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk2 = PythonSdkUtil.findPythonSdk(m);
            if (sdk2 == null || PythonSdkUtil.isRemote(sdk2)) continue;
            return sdk2;
        }
        return null;
    }

    @Nullable
    private static Sdk getLocalSdkForFile(@NotNull Project project, @NotNull VirtualFile workingDirectoryVirtualFile) {
        Sdk sdk;
        Module module;
        if (project == null) {
            PySdkUtil.$$$reportNull$$$0(23);
        }
        if (workingDirectoryVirtualFile == null) {
            PySdkUtil.$$$reportNull$$$0(24);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)workingDirectoryVirtualFile, (Project)project)) != null && (sdk = PythonSdkUtil.findPythonSdk(module)) != null && !PythonSdkUtil.isRemote(sdk)) {
            return sdk;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PySdkUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraEnvironment";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectoryVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PySdkUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeEnvVariables";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "activateVirtualEnv";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForSdk";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinsFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureCharset";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mergeEnvVariables";
                break;
            }
            case 7: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "activateVirtualEnv";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinsFileName";
                break;
            }
            case 18: 
            case 19: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findSdkForDirectory";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLocalSdkForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

