/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.library.PythonLibraryType;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.Context;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.PySdkTargetPaths;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.JythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000z\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\"\u0010\u0006\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u0007H\u0002\u001a4\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\"\u0010\u000f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u0007H\u0002\u001aG\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\"\u0010\u000f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a4\u0010\u0014\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\"\u0010\u000f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u0007H\u0002\u001a<\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\"\u0010\u0006\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u0007H\u0002\u001a,\u0010\u0016\u001a\u00020\u00012\"\u0010\u0017\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u0007H\u0002\u001a`\u0010\u0018\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 \u001aF\u0010\u0018\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u00192\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 H\u0002\u001aX\u0010\u0018\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u00192\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 H\u0002\u001a*\u0010%\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0&2\u0006\u0010'\u001a\u00020(\u001ad\u0010)\u001a\u00020\u00012(\u0010*\u001a$\u0012\u0004\u0012\u00020\n\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0+2\u0006\u0010,\u001a\u00020 2\"\u0010\u000f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u00072\u0006\u0010-\u001a\u00020.\u001a\u000e\u0010/\u001a\u0004\u0018\u000100*\u00020\u0005H\u0002\u00a8\u00061"}, d2={"addIfNeeded", "", "context", "Lcom/jetbrains/python/run/Context;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "pathList", "", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "addLibrariesFromModule", "module", "Lcom/intellij/openapi/module/Module;", "pythonPathList", "addRoots", "roots", "", "(Lcom/jetbrains/python/run/Context;Ljava/util/Collection;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "addRootsFromModule", "addToPythonPath", "appendSystemPythonPath", "pythonPath", "collectPythonPath", "", "project", "Lcom/intellij/openapi/project/Project;", "sdkHome", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "shouldAddContentRoots", "", "shouldAddSourceRoots", "isDebug", "addContentRoots", "addSourceRoots", "getAddedPaths", "", "sdkAdditionalData", "Lcom/intellij/openapi/projectRoots/SdkAdditionalData;", "initPythonPath", "envs", "", "passParentEnvs", "targetEnvironmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "toNioPathOrNull", "Ljava/nio/file/Path;", "intellij.python.community.impl"})
@JvmName(name="TargetedPythonPaths")
public final class TargetedPythonPaths {
    public static final void initPythonPath(@NotNull Map<String, Function<TargetEnvironment, String>> envs, boolean passParentEnvs, @NotNull Collection<Function<TargetEnvironment, String>> pythonPathList, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Intrinsics.checkNotNullParameter(pythonPathList, (String)"pythonPathList");
        Intrinsics.checkNotNullParameter((Object)targetEnvironmentRequest, (String)"targetEnvironmentRequest");
        if (passParentEnvs && targetEnvironmentRequest instanceof LocalTargetEnvironmentRequest && !envs.containsKey("PYTHONPATH")) {
            TargetedPythonPaths.appendSystemPythonPath(pythonPathList);
        }
        PythonScripts.appendToPythonPath(envs, pythonPathList, targetEnvironmentRequest.getTargetPlatform());
    }

    /*
     * WARNING - void declaration
     */
    private static final void appendSystemPythonPath(Collection<Function<TargetEnvironment, String>> pythonPath) {
        String syspath = System.getenv("PYTHONPATH");
        if (syspath != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list;
            ListIterator iterator$iv;
            Iterable $this$dropLastWhile$iv;
            CharSequence charSequence = syspath;
            String[] stringArray = new String[1];
            String string = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File.pathSeparator");
            stringArray[0] = string;
            List list2 = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Collection<Function<TargetEnvironment, String>> collection = pythonPath;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String p1 = (String)iterator$iv.previous();
                    boolean bl = false;
                    CharSequence charSequence2 = p1;
                    if (charSequence2.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection<Function> collection2 = list;
            $this$dropLastWhile$iv = collection2;
            boolean $i$f$map = false;
            iterator$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                String string2 = (String)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                Function function = TargetEnvironmentFunctions.constant((Object)p1);
                collection2.add(function);
            }
            collection2 = (List)destination$iv$iv;
            collection.addAll((Collection<Function<TargetEnvironment, String>>)collection2);
        }
    }

    @NotNull
    public static final Collection<Function<TargetEnvironment, String>> collectPythonPath(@NotNull Project project, @Nullable Module module, @Nullable String sdkHome, @Nullable PyRemotePathMapper pathMapper, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Sdk sdk = PythonSdkUtil.findSdkByPath(sdkHome);
        return TargetedPythonPaths.collectPythonPath(new Context(project, sdk, pathMapper), module, sdkHome, shouldAddContentRoots, shouldAddSourceRoots, isDebug);
    }

    private static final Collection<Function<TargetEnvironment, String>> collectPythonPath(Context context2, Module module, String sdkHome, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        Set pythonPath = new LinkedHashSet<Function<TargetEnvironment, String>>(TargetedPythonPaths.collectPythonPath(context2, module, shouldAddContentRoots, shouldAddSourceRoots));
        if (isDebug && PythonSdkFlavor.getFlavor(sdkHome) instanceof JythonSdkFlavor) {
            for (String helpersResource : CollectionsKt.listOf((Object[])new String[]{"pycharm", "pydev"})) {
                String helperPath = PythonHelpersLocator.getHelperPath(helpersResource);
                Path path2 = Path.of(helperPath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Path.of(helperPath)");
                Function targetHelperPath = TargetEnvironmentFunctions.targetPath((Path)path2);
                pythonPath.add(targetHelperPath);
            }
        }
        return pythonPath;
    }

    private static final Collection<Function<TargetEnvironment, String>> collectPythonPath(Context context2, Module module, boolean addContentRoots, boolean addSourceRoots) {
        Collection pythonPathList = new LinkedHashSet();
        if (module != null) {
            Set dependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)module, (Set)dependencies);
            if (addContentRoots) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                VirtualFile[] virtualFileArray = moduleRootManager.getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"ModuleRootManager.getInstance(module).contentRoots");
                TargetedPythonPaths.addRoots(context2, pythonPathList, virtualFileArray);
                for (Module dependency : dependencies) {
                    ModuleRootManager moduleRootManager2 = ModuleRootManager.getInstance((Module)dependency);
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager2, (String)"ModuleRootManager.getInstance(dependency)");
                    VirtualFile[] virtualFileArray2 = moduleRootManager2.getContentRoots();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"ModuleRootManager.getIns\u2026(dependency).contentRoots");
                    TargetedPythonPaths.addRoots(context2, pythonPathList, virtualFileArray2);
                }
            }
            if (addSourceRoots) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                VirtualFile[] virtualFileArray = moduleRootManager.getSourceRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"ModuleRootManager.getInstance(module).sourceRoots");
                TargetedPythonPaths.addRoots(context2, pythonPathList, virtualFileArray);
                for (Module dependency : dependencies) {
                    ModuleRootManager moduleRootManager3 = ModuleRootManager.getInstance((Module)dependency);
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager3, (String)"ModuleRootManager.getInstance(dependency)");
                    VirtualFile[] virtualFileArray3 = moduleRootManager3.getSourceRoots();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray3, (String)"ModuleRootManager.getIns\u2026e(dependency).sourceRoots");
                    TargetedPythonPaths.addRoots(context2, pythonPathList, virtualFileArray3);
                }
            }
            TargetedPythonPaths.addLibrariesFromModule(module, pythonPathList);
            TargetedPythonPaths.addRootsFromModule(module, pythonPathList);
            for (Module dependency : dependencies) {
                TargetedPythonPaths.addLibrariesFromModule(dependency, pythonPathList);
                TargetedPythonPaths.addRootsFromModule(dependency, pythonPathList);
            }
        }
        return pythonPathList;
    }

    @NotNull
    public static final List<Function<TargetEnvironment, String>> getAddedPaths(@NotNull SdkAdditionalData sdkAdditionalData) {
        Intrinsics.checkNotNullParameter((Object)sdkAdditionalData, (String)"sdkAdditionalData");
        List pathList = new ArrayList();
        if (sdkAdditionalData instanceof PythonSdkAdditionalData) {
            List list;
            String string;
            VirtualFile it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Iterable $this$map$iv;
            if (sdkAdditionalData instanceof RemoteSdkProperties) {
                Set<VirtualFile> set = ((PythonSdkAdditionalData)sdkAdditionalData).getAddedPathFiles();
                Intrinsics.checkNotNullExpressionValue(set, (String)"sdkAdditionalData.addedPathFiles");
                $this$map$iv = set;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    PathMappingSettings pathMappingSettings = ((RemoteSdkProperties)sdkAdditionalData).getPathMappings();
                    VirtualFile virtualFile2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it");
                    string = pathMappingSettings.convertToRemote(virtualFile2.getPath());
                    collection.add(string);
                }
                list = (List)destination$iv$iv;
            } else {
                Set<VirtualFile> set = ((PythonSdkAdditionalData)sdkAdditionalData).getAddedPathFiles();
                Intrinsics.checkNotNullExpressionValue(set, (String)"sdkAdditionalData.addedPathFiles");
                $this$map$iv = set;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (VirtualFile)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    VirtualFile virtualFile = it;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                    string = virtualFile.getPath();
                    collection.add(string);
                }
                list = (List)destination$iv$iv;
            }
            List addedPaths = list;
            Iterator iterator = addedPaths.iterator();
            while (iterator.hasNext()) {
                String file;
                String string2 = file = (String)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file");
                pathList.add(TargetEnvironmentFunctions.constant((Object)string2));
            }
        }
        return pathList;
    }

    private static final void addToPythonPath(Context context2, VirtualFile file, Collection<Function<TargetEnvironment, String>> pathList) {
        if (file.getFileSystem() instanceof JarFileSystem) {
            VirtualFile realFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
            if (realFile != null) {
                TargetedPythonPaths.addIfNeeded(context2, realFile, pathList);
            }
        } else {
            TargetedPythonPaths.addIfNeeded(context2, file, pathList);
        }
    }

    private static final void addIfNeeded(Context context2, VirtualFile file, Collection<Function<TargetEnvironment, String>> pathList) {
        Path filePath = Path.of(FileUtil.toSystemDependentName((String)file.getPath()), new String[0]);
        Project project = context2.getProject();
        Sdk sdk = context2.getSdk();
        PyRemotePathMapper pyRemotePathMapper = context2.getPathMapper();
        Path path2 = filePath;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"filePath");
        pathList.add(PySdkTargetPaths.getTargetPathForPythonConsoleExecution(project, sdk, pyRemotePathMapper, path2));
    }

    /*
     * WARNING - void declaration
     */
    private static final void addLibrariesFromModule(Module module, Collection<Function<TargetEnvironment, String>> pythonPathList) {
        OrderEntry[] entries;
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        for (OrderEntry entry : entries = moduleRootManager.getOrderEntries()) {
            void $this$mapNotNullTo$iv$iv;
            VirtualFile[] $this$mapNotNull$iv;
            String name2;
            if (!(entry instanceof LibraryOrderEntry) || (name2 = ((LibraryOrderEntry)entry).getLibraryName()) != null && StringsKt.endsWith$default((String)name2, (String)" interpreter library", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((LibraryOrderEntry)entry).getRootFiles(OrderRootType.CLASSES), (String)"entry.getRootFiles(OrderRootType.CLASSES)");
            boolean $i$f$mapNotNull2 = false;
            Object object = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Path path2;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                if (TargetedPythonPaths.toNioPathOrNull((VirtualFile)v1) == null) continue;
                Path it$iv$iv = path2;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            for (Path root : (List)destination$iv$iv) {
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (!PlatformUtils.isPyCharm()) {
                    Collection<Function<TargetEnvironment, String>> $i$f$mapNotNull2 = pythonPathList;
                    object = TargetEnvironmentFunctions.targetPath((Path)root);
                    $i$f$mapNotNull2.add((Function<TargetEnvironment, String>)object);
                    continue;
                }
                if (!(library instanceof LibraryEx)) continue;
                PersistentLibraryKind kind = ((LibraryEx)library).getKind();
                PythonLibraryType pythonLibraryType = PythonLibraryType.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)pythonLibraryType), (String)"PythonLibraryType.getInstance()");
                if (kind != pythonLibraryType.getKind()) continue;
                object = pythonPathList;
                Function function = TargetEnvironmentFunctions.targetPath((Path)root);
                object.add(function);
            }
        }
    }

    private static final Path toNioPathOrNull(VirtualFile $this$toNioPathOrNull) {
        return $this$toNioPathOrNull.getFileSystem().getNioPath($this$toNioPathOrNull);
    }

    private static final void addRootsFromModule(Module module, Collection<Function<TargetEnvironment, String>> pythonPathList) {
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension != null) {
            VirtualFile pathForTests;
            VirtualFile path2 = extension.getCompilerOutputPath();
            if (path2 != null) {
                String string = path2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.path");
                pythonPathList.add(TargetEnvironmentFunctions.constant((Object)string));
            }
            if ((pathForTests = extension.getCompilerOutputPathForTests()) != null) {
                String string = pathForTests.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathForTests.path");
                pythonPathList.add(TargetEnvironmentFunctions.constant((Object)string));
            }
        }
    }

    private static final void addRoots(Context context2, Collection<Function<TargetEnvironment, String>> pythonPathList, VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            TargetedPythonPaths.addToPythonPath(context2, root, pythonPathList);
        }
    }
}

