/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonLexer;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyStringLiteralUtil {
    public static final String PREFIX_CHARACTERS = "ubcrf";
    public static final int MAX_PREFIX_LENGTH = 3;
    private static final ImmutableList<String> QUOTES = ImmutableList.of((Object)"'''", (Object)"\"\"\"", (Object)"'", (Object)"\"");
    private static final Logger LOG = Logger.getInstance(PyStringLiteralUtil.class);

    private PyStringLiteralUtil() {
    }

    @NotNull
    public static String getStringValue(@NotNull String s) {
        if (s == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(0);
        }
        String string = PyStringLiteralUtil.getStringValueTextRange(s).substring(s);
        if (string == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static TextRange getStringValueTextRange(@NotNull String s) {
        Pair<String, String> quotes;
        if (s == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(2);
        }
        if ((quotes = PyStringLiteralUtil.getQuotes(s)) != null) {
            return TextRange.create((int)((String)quotes.getFirst()).length(), (int)(s.length() - ((String)quotes.getSecond()).length()));
        }
        return TextRange.allOf((String)s);
    }

    public static boolean isStringLiteralToken(@NotNull String text2) {
        if (text2 == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(3);
        }
        PythonLexer lexer = new PythonLexer();
        lexer.start(text2);
        return PyTokenTypes.STRING_NODES.contains(lexer.getTokenType()) && lexer.getTokenEnd() == lexer.getBufferEnd() || PyTokenTypes.FSTRING_START == lexer.getTokenType();
    }

    public static boolean isQuoted(@Nullable String text2) {
        return text2 != null && PyStringLiteralUtil.getQuotes(text2) != null;
    }

    @Nullable
    public static Pair<String, String> getQuotes(@NotNull String text2) {
        if (text2 == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(4);
        }
        String prefix = PyStringLiteralUtil.getPrefix(text2);
        String mainText = text2.substring(prefix.length());
        for (String quote : QUOTES) {
            Pair<String, String> quotes = PyStringLiteralUtil.getQuotes(mainText, prefix, quote);
            if (quotes == null) continue;
            return quotes;
        }
        return null;
    }

    @NotNull
    public static TextRange getContentRange(@NotNull String text2) {
        if (text2 == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(PyStringLiteralUtil.isStringLiteralToken(text2), (Object)"Text of a single string literal node expected");
        int startOffset = PyStringLiteralUtil.getPrefixLength(text2);
        int delimiterLength = 1;
        String afterPrefix = text2.substring(startOffset);
        if (afterPrefix.startsWith("\"\"\"") || afterPrefix.startsWith("'''")) {
            delimiterLength = 3;
        }
        String delimiter = text2.substring(startOffset, startOffset + delimiterLength);
        int endOffset = text2.length();
        if (text2.substring(startOffset += delimiterLength).endsWith(delimiter)) {
            endOffset -= delimiterLength;
        }
        return new TextRange(startOffset, endOffset);
    }

    public static int getPrefixEndOffset(@NotNull CharSequence text2, int startOffset) {
        int offset;
        if (text2 == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(6);
        }
        for (offset = startOffset; offset < Math.min(startOffset + 3, text2.length()) && PREFIX_CHARACTERS.indexOf(Character.toLowerCase(text2.charAt(offset))) >= 0; ++offset) {
        }
        return offset;
    }

    public static int getPrefixLength(@NotNull String text2) {
        if (text2 == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(7);
        }
        return PyStringLiteralUtil.getPrefixEndOffset(text2, 0);
    }

    @NotNull
    public static String getPrefix(@NotNull CharSequence text2) {
        if (text2 == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(8);
        }
        return PyStringLiteralUtil.getPrefix(text2, 0);
    }

    @NotNull
    public static String getPrefix(@NotNull CharSequence text2, int startOffset) {
        if (text2 == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(9);
        }
        String string = text2.subSequence(startOffset, PyStringLiteralUtil.getPrefixEndOffset(text2, startOffset)).toString();
        if (string == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static boolean isUnicodePrefix(@NotNull String prefix) {
        if (prefix == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(11);
        }
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'u', (int)0) >= 0;
    }

    public static boolean isBytesPrefix(@NotNull String prefix) {
        if (prefix == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(12);
        }
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'b', (int)0) >= 0;
    }

    public static boolean isRawPrefix(@NotNull String prefix) {
        if (prefix == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(13);
        }
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'r', (int)0) >= 0;
    }

    public static boolean isFormattedPrefix(@NotNull String prefix) {
        if (prefix == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(14);
        }
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'f', (int)0) >= 0;
    }

    public static char flipQuote(char quote) {
        return quote == '\"' ? (char)'\'' : '\"';
    }

    @Nullable
    private static Pair<String, String> getQuotes(@NotNull String text2, @NotNull String prefix, @NotNull String quote) {
        int n;
        int length;
        if (text2 == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(15);
        }
        if (prefix == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(16);
        }
        if (quote == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(17);
        }
        if ((length = text2.length()) >= 2 * (n = quote.length()) && text2.startsWith(quote) && text2.endsWith(quote)) {
            return Pair.create((Object)(prefix + text2.substring(0, n)), (Object)text2.substring(length - n));
        }
        return null;
    }

    public static TextRange getTextRange(PsiElement element) {
        if (element instanceof PyStringLiteralExpression) {
            List<TextRange> ranges = ((PyStringLiteralExpression)element).getStringValueTextRanges();
            return ranges.get(0);
        }
        return new TextRange(0, element.getTextLength());
    }

    @Nullable
    public static String getText(@Nullable PyExpression ex) {
        if (ex == null) {
            return null;
        }
        return ex.getText();
    }

    @Nullable
    public static String getStringValue(@Nullable PsiElement o) {
        if (o == null) {
            return null;
        }
        if (o instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression literalExpression = (PyStringLiteralExpression)o;
            return literalExpression.getStringValue();
        }
        return o.getText();
    }

    public static String stripQuotesAroundValue(String text2) {
        Pair<String, String> quotes = PyStringLiteralUtil.getQuotes(text2);
        if (quotes == null) {
            return text2;
        }
        return text2.substring(((String)quotes.first).length(), text2.length() - ((String)quotes.second).length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyStringLiteralUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyStringLiteralUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringValue";
                break;
            }
            case 1: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStringValueTextRange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteralToken";
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getQuotes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContentRange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixEndOffset";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixLength";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUnicodePrefix";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isBytesPrefix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isRawPrefix";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFormattedPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

