/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.lexer;

import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PyStringLiteralLexerBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0014J\b\u0010\u000b\u001a\u00020\tH\u0014J\b\u0010\f\u001a\u00020\tH\u0014J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/lexer/PyFStringLiteralLexer;", "Lcom/jetbrains/python/lexer/PyStringLiteralLexerBase;", "fStringTextToken", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)V", "getEscapeSequenceType", "getState", "", "isDoubleCurley", "", "isEscape", "isRaw", "isUnicodeMode", "locateToken", "start", "intellij.python.psi.impl"})
public final class PyFStringLiteralLexer
extends PyStringLiteralLexerBase {
    /*
     * WARNING - void declaration
     */
    @Override
    protected int locateToken(int start) {
        int n;
        if (start >= this.myBufferEnd) {
            n = this.myBufferEnd;
        } else if (this.myBuffer.charAt(start) == '\\') {
            n = this.locateEscapeSequence(start);
        } else if (this.isDoubleCurley()) {
            n = start + 2;
        } else {
            void $this$filterTo$iv$iv;
            int nextBackslashOffset = CharArrayUtil.indexOf((CharSequence)this.myBuffer, (CharSequence)"\\", (int)(start + 1), (int)this.myBufferEnd);
            int nextLCurleyOffset = CharArrayUtil.indexOf((CharSequence)this.myBuffer, (CharSequence)"{{", (int)(start + 1), (int)this.myBufferEnd);
            int nextRCurleyOffset = CharArrayUtil.indexOf((CharSequence)this.myBuffer, (CharSequence)"}}", (int)(start + 1), (int)this.myBufferEnd);
            Iterable $this$filter$iv = SetsKt.setOf((Object[])new Integer[]{nextBackslashOffset, nextLCurleyOffset, nextRCurleyOffset});
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!(it >= 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Integer n2 = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
            n = n2 != null ? n2 : this.myBufferEnd;
        }
        return n;
    }

    @Override
    protected boolean isRaw() {
        return Intrinsics.areEqual((Object)this.myOriginalLiteralToken, (Object)((Object)PyTokenTypes.FSTRING_RAW_TEXT));
    }

    @Override
    protected boolean isUnicodeMode() {
        return true;
    }

    public int getState() {
        return this.myBaseLexerState;
    }

    @Override
    protected boolean isEscape() {
        return this.isDoubleCurley() || super.isEscape();
    }

    @Override
    @NotNull
    public IElementType getEscapeSequenceType() {
        IElementType iElementType;
        if (this.isDoubleCurley()) {
            IElementType iElementType2 = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            iElementType = iElementType2;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN");
        } else {
            IElementType iElementType3 = super.getEscapeSequenceType();
            iElementType = iElementType3;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"super.getEscapeSequenceType()");
        }
        return iElementType;
    }

    private final boolean isDoubleCurley() {
        return this.myBufferEnd > this.myStart + 1 && (this.myBuffer.charAt(this.myStart) == '{' && this.myBuffer.charAt(this.myStart + 1) == '{' || this.myBuffer.charAt(this.myStart) == '}' && this.myBuffer.charAt(this.myStart + 1) == '}');
    }

    public PyFStringLiteralLexer(@NotNull IElementType fStringTextToken) {
        Intrinsics.checkNotNullParameter((Object)fStringTextToken, (String)"fStringTextToken");
        super(fStringTextToken);
        boolean bl = PyTokenTypes.FSTRING_TEXT_TOKENS.contains(fStringTextToken);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }
}

