/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.unusedLocal;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveAssignmentStatementTargetQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveExceptionTargetQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveParameterQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveStatementQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveWithTargetQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyExceptPartNavigator;
import com.jetbrains.python.psi.impl.PyForStatementNavigator;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import com.jetbrains.python.psi.impl.PyTypeDeclarationStatementNavigator;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyUnusedLocalInspectionVisitor
extends PyInspectionVisitor {
    private final boolean myIgnoreTupleUnpacking;
    private final boolean myIgnoreLambdaParameters;
    private final boolean myIgnoreRangeIterationVariables;
    private final boolean myIgnoreVariablesStartingWithUnderscore;
    private final HashSet<PsiElement> myUnusedElements;
    private final HashSet<PsiElement> myUsedElements;

    public PyUnusedLocalInspectionVisitor(@NotNull ProblemsHolder holder, boolean ignoreTupleUnpacking, boolean ignoreLambdaParameters, boolean ignoreRangeIterationVariables, boolean ignoreVariablesStartingWithUnderscore, @NotNull TypeEvalContext context2) {
        if (holder == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(1);
        }
        super(holder, context2);
        this.myIgnoreTupleUnpacking = ignoreTupleUnpacking;
        this.myIgnoreLambdaParameters = ignoreLambdaParameters;
        this.myIgnoreRangeIterationVariables = ignoreRangeIterationVariables;
        this.myIgnoreVariablesStartingWithUnderscore = ignoreVariablesStartingWithUnderscore;
        this.myUnusedElements = new HashSet();
        this.myUsedElements = new HashSet();
    }

    @Override
    public void visitPyFunction(@NotNull PyFunction node) {
        if (node == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(2);
        }
        if (!PyiUtil.isOverload(node, this.myTypeEvalContext)) {
            this.processScope(node);
        }
    }

    @Override
    public void visitPyLambdaExpression(@NotNull PyLambdaExpression node) {
        if (node == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(3);
        }
        this.processScope(node);
    }

    @Override
    public void visitPyClass(@NotNull PyClass node) {
        if (node == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(4);
        }
        this.processScope(node);
    }

    private void processScope(ScopeOwner owner) {
        if (owner.getContainingFile() instanceof PyExpressionCodeFragment) {
            return;
        }
        if (!(owner instanceof PyClass) && !PyUnusedLocalInspectionVisitor.callsLocals(owner)) {
            this.collectAllWrites(owner);
        }
        this.collectUsedReads(owner);
    }

    @Override
    public void visitPyStringLiteralExpression(final @NotNull PyStringLiteralExpression pyString) {
        ScopeOwner owner;
        if (pyString == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(5);
        }
        if ((owner = ScopeUtil.getScopeOwner(pyString)) != null && !(owner instanceof PsiFile)) {
            PsiElement instrAnchor = PyUnusedLocalInspectionVisitor.getControlFlowAnchorForString(pyString);
            if (instrAnchor == null) {
                return;
            }
            final Instruction[] instructions = ControlFlowCache.getControlFlow(owner).getInstructions();
            final int startInstruction = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)instrAnchor);
            if (startInstruction < 0) {
                return;
            }
            Project project = pyString.getProject();
            List pairs = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)pyString);
            if (pairs != null) {
                for (Pair pair : pairs) {
                    ((PsiElement)pair.getFirst()).accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

                        @Override
                        public void visitPyReferenceExpression(@NotNull PyReferenceExpression expr) {
                            PyExpression qualifier;
                            if (expr == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if ((qualifier = expr.getQualifier()) != null) {
                                qualifier.accept(this);
                                return;
                            }
                            String name2 = expr.getName();
                            if (name2 != null) {
                                PyUnusedLocalInspectionVisitor.this.analyzeReadsInScope(name2, owner, instructions, startInstruction, pyString);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/python/inspections/unusedLocal/PyUnusedLocalInspectionVisitor$1", "visitPyReferenceExpression"));
                        }
                    });
                }
            }
        }
    }

    @Nullable
    private static PsiElement getControlFlowAnchorForString(@NotNull PyStringLiteralExpression host) {
        PsiElement comprehensionPart;
        if (host == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(6);
        }
        if ((comprehensionPart = PsiTreeUtil.findFirstParent((PsiElement)host, element -> element instanceof PyExpression && element.getParent() instanceof PyComprehensionElement)) != null) {
            return comprehensionPart;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)host, PyStatement.class);
    }

    private void collectAllWrites(ScopeOwner owner) {
        Instruction[] instructions;
        for (Instruction instruction : instructions = ControlFlowCache.getControlFlow(owner).getInstructions()) {
            ReadWriteInstruction readWriteInstruction;
            ReadWriteInstruction.ACCESS access;
            PsiElement element = instruction.getElement();
            if (element instanceof PyFunction && owner instanceof PyFunction) {
                if (PyKnownDecoratorUtil.hasUnknownDecorator((PyFunction)element, this.myTypeEvalContext) || this.myUsedElements.contains(element)) continue;
                this.myUnusedElements.add(element);
                continue;
            }
            if (!(instruction instanceof ReadWriteInstruction) || !(access = (readWriteInstruction = (ReadWriteInstruction)instruction).getAccess()).isWriteAccess()) continue;
            String name2 = readWriteInstruction.getName();
            Scope scope = ControlFlowCache.getScope(owner);
            if (name2 == null || "_".equals(name2) || scope.isGlobal(name2) || scope.isNonlocal(name2) || element instanceof PyTargetExpression && ((PyTargetExpression)element).isQualified() || name2.startsWith("_") && element instanceof PyParameter || element == null || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)element, (boolean)false) || PyImportStatementNavigator.getImportStatementByElement(element) != null || PyAugAssignmentStatementNavigator.getStatementByTarget(element) != null || PyUnusedLocalInspectionVisitor.parameterInMethodWithFixedSignature(owner, element) || PyTypeDeclarationStatementNavigator.isTypeDeclarationTarget(element) || this.myUsedElements.contains(element)) continue;
            this.myUnusedElements.add(element);
        }
    }

    private static boolean parameterInMethodWithFixedSignature(@NotNull ScopeOwner owner, @NotNull PsiElement element) {
        if (owner == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(7);
        }
        if (element == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(8);
        }
        if (owner instanceof PyFunction && element instanceof PyParameter) {
            PyFunction function = (PyFunction)owner;
            String functionName = function.getName();
            LanguageLevel level = LanguageLevel.forElement(function);
            Map<String, PyNames.BuiltinDescription> builtinMethods = function.getContainingClass() != null ? PyNames.getBuiltinMethods(level) : PyNames.getModuleBuiltinMethods(level);
            return functionName != null && !"__init__".equals(functionName) && builtinMethods.containsKey(functionName);
        }
        return false;
    }

    private void collectUsedReads(ScopeOwner owner) {
        Instruction[] instructions = ControlFlowCache.getControlFlow(owner).getInstructions();
        for (int i = 0; i < instructions.length; ++i) {
            int startInstruction;
            PsiElement element;
            String name2;
            ReadWriteInstruction readWriteInstruction;
            ReadWriteInstruction.ACCESS access;
            Instruction instruction = instructions[i];
            if (!(instruction instanceof ReadWriteInstruction) || !(access = (readWriteInstruction = (ReadWriteInstruction)instruction).getAccess()).isReadAccess() || (name2 = readWriteInstruction.getName()) == null || (element = instruction.getElement()) == null || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)element, (boolean)false)) continue;
            if (access.isWriteAccess()) {
                PyAugAssignmentStatement augAssignmentStatement = PyAugAssignmentStatementNavigator.getStatementByTarget(element);
                startInstruction = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)augAssignmentStatement);
            } else {
                startInstruction = i;
            }
            this.analyzeReadsInScope(name2, owner, instructions, startInstruction, (PsiElement)PyUtil.as(element, PyReferenceExpression.class));
        }
    }

    private void analyzeReadsInScope(@NotNull String name2, @NotNull ScopeOwner owner, Instruction @NotNull [] instructions, int startInstruction, @Nullable PsiElement scopeAnchor) {
        ScopeOwner declOwner;
        if (name2 == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(9);
        }
        if (owner == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(10);
        }
        if (instructions == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(11);
        }
        if (scopeAnchor != null && (declOwner = ScopeUtil.getDeclarationScopeOwner(scopeAnchor, name2)) != null && declOwner != owner) {
            List<PsiElement> writeElements = ScopeUtil.getElementsOfAccessType(name2, declOwner, ReadWriteInstruction.ACCESS.WRITE);
            for (PsiElement e : writeElements) {
                this.myUsedElements.add(e);
                this.myUnusedElements.remove(e);
            }
        }
        ControlFlowUtil.iteratePrev((int)startInstruction, (Instruction[])instructions, inst -> {
            ReadWriteInstruction rwInstruction;
            PsiElement instElement = inst.getElement();
            if (instElement instanceof PyFunction) {
                if (name2.equals(((PyFunction)instElement).getName())) {
                    this.myUsedElements.add(instElement);
                    this.myUnusedElements.remove(instElement);
                    return ControlFlowUtil.Operation.CONTINUE;
                }
            } else if (inst instanceof ReadWriteInstruction && (rwInstruction = (ReadWriteInstruction)((Object)inst)).getAccess().isWriteAccess() && name2.equals(rwInstruction.getName())) {
                if (instElement != null && PyTypeDeclarationStatementNavigator.isTypeDeclarationTarget(instElement)) {
                    return ControlFlowUtil.Operation.NEXT;
                }
                if (instElement != null && PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)instElement, (boolean)false)) {
                    this.myUsedElements.add(instElement);
                    this.myUnusedElements.remove(instElement);
                }
                return ControlFlowUtil.Operation.CONTINUE;
            }
            return ControlFlowUtil.Operation.NEXT;
        });
    }

    private static boolean callsLocals(ScopeOwner owner) {
        try {
            owner.acceptChildren(new PyRecursiveElementVisitor(){

                @Override
                public void visitPyCallExpression(@NotNull PyCallExpression node) {
                    PyExpression callee;
                    if (node == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((callee = node.getCallee()) != null && "locals".equals(callee.getName())) {
                        throw new DontPerformException();
                    }
                    node.acceptChildren(this);
                }

                @Override
                public void visitPyFunction(@NotNull PyFunction node) {
                    if (node == null) {
                        2.$$$reportNull$$$0(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "node";
                    objectArray2[1] = "com/jetbrains/python/inspections/unusedLocal/PyUnusedLocalInspectionVisitor$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyCallExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyFunction";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        catch (DontPerformException e) {
            return true;
        }
        return false;
    }

    public void registerProblems() {
        List filters = PyInspectionExtension.EP_NAME.getExtensionList();
        HashSet<PyFunction> functionsWithInheritors = new HashSet<PyFunction>();
        HashMap<PyFunction, Boolean> emptyFunctions = new HashMap<PyFunction, Boolean>();
        for (PsiElement element : this.myUnusedElements) {
            boolean ignoreUnused = false;
            for (PyInspectionExtension filter : filters) {
                if (!filter.ignoreUnused(element, this.myTypeEvalContext)) continue;
                ignoreUnused = true;
            }
            if (ignoreUnused) continue;
            if (element instanceof PyFunction) {
                PsiElement nameIdentifier = ((PyFunction)element).getNameIdentifier();
                this.registerWarning(nameIdentifier == null ? element : nameIdentifier, PyPsiBundle.message("INSP.unused.locals.local.function.isnot.used", ((PyFunction)element).getName()), new PyRemoveStatementQuickFix());
                continue;
            }
            if (element instanceof PyClass) {
                PyClass cls = (PyClass)element;
                PsiElement name2 = cls.getNameIdentifier();
                this.registerWarning(name2 != null ? name2 : element, PyPsiBundle.message("INSP.unused.locals.local.class.isnot.used", cls.getName()), new PyRemoveStatementQuickFix());
                continue;
            }
            String name3 = element.getText();
            if (element instanceof PyNamedParameter || element.getParent() instanceof PyNamedParameter) {
                PyNamedParameter namedParameter = element instanceof PyNamedParameter ? (PyNamedParameter)element : (PyNamedParameter)element.getParent();
                name3 = namedParameter.getName();
                if (namedParameter.isSelf() || this.myIgnoreLambdaParameters && PsiTreeUtil.getParentOfType((PsiElement)element, PyCallable.class) instanceof PyLambdaExpression) continue;
                boolean mayBeField = false;
                PyClass containingClass = null;
                PyParameterList paramList = (PyParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PyParameterList.class);
                if (paramList != null && paramList.getParent() instanceof PyFunction) {
                    PyFunction func = (PyFunction)paramList.getParent();
                    containingClass = func.getContainingClass();
                    if (containingClass != null && PyUtil.isInitMethod(func) && !namedParameter.isKeywordContainer() && !namedParameter.isPositionalContainer()) {
                        mayBeField = true;
                    } else if (this.ignoreUnusedParameters(func, functionsWithInheritors)) continue;
                    if (func.asMethod() != null) {
                        Boolean isEmpty = (Boolean)emptyFunctions.get(func);
                        if (isEmpty == null) {
                            isEmpty = PyUtil.isEmptyFunction(func);
                            emptyFunctions.put(func, isEmpty);
                        }
                        if (isEmpty.booleanValue() && !mayBeField) continue;
                    }
                }
                boolean canRemove = !(PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, PyParameter.class) instanceof PySingleStarParameter) || PsiTreeUtil.getNextSiblingOfType((PsiElement)element, PyParameter.class) != null;
                ArrayList<Object> fixes = new ArrayList<Object>();
                if (mayBeField) {
                    fixes.add(new AddFieldQuickFix(name3, name3, containingClass.getName(), false));
                }
                if (canRemove) {
                    fixes.add(new PyRemoveParameterQuickFix());
                }
                this.registerWarning(element, PyPsiBundle.message("INSP.unused.locals.parameter.isnot.used", name3), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                continue;
            }
            if (this.myIgnoreVariablesStartingWithUnderscore && element.getText().startsWith("_") || this.myIgnoreTupleUnpacking && this.isTupleUnpacking(element)) continue;
            String warningMsg = PyPsiBundle.message("INSP.unused.locals.local.variable.isnot.used", name3);
            PyForStatement forStatement = PyForStatementNavigator.getPyForStatementByIterable(element);
            if (forStatement != null) {
                if (this.myIgnoreRangeIterationVariables && this.isRangeIteration(forStatement)) continue;
                this.registerWarning(element, warningMsg, new ReplaceWithWildCard());
                continue;
            }
            if (PyUnusedLocalInspectionVisitor.isComprehensionTarget(element)) {
                this.registerWarning(element, warningMsg, new ReplaceWithWildCard());
                continue;
            }
            PyExceptPart exceptPart = PyExceptPartNavigator.getPyExceptPartByTarget(element);
            if (exceptPart != null) {
                this.registerWarning(element, warningMsg, new PyRemoveExceptionTargetQuickFix());
                continue;
            }
            PyWithItem withItem = (PyWithItem)PsiTreeUtil.getParentOfType((PsiElement)element, PyWithItem.class);
            if (withItem != null && PsiTreeUtil.isAncestor((PsiElement)withItem.getTarget(), (PsiElement)element, (boolean)false)) {
                if (withItem.getTarget() == element) {
                    this.registerWarning(element, warningMsg, new PyRemoveWithTargetQuickFix());
                    continue;
                }
                this.registerWarning(element, warningMsg, new ReplaceWithWildCard());
                continue;
            }
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class);
            if (assignmentStatement != null && !PsiTreeUtil.isAncestor((PsiElement)assignmentStatement.getAssignedValue(), (PsiElement)element, (boolean)false)) {
                if (assignmentStatement.getLeftHandSideExpression() == element) {
                    this.registerWarning(element, warningMsg, new PyRemoveAssignmentStatementTargetQuickFix(), new PyRemoveStatementQuickFix());
                    continue;
                }
                if (ArrayUtil.contains((Object)element, (Object[])assignmentStatement.getRawTargets())) {
                    this.registerWarning(element, warningMsg, new PyRemoveAssignmentStatementTargetQuickFix());
                    continue;
                }
                this.registerWarning(element, warningMsg, new ReplaceWithWildCard());
                continue;
            }
            this.registerWarning(element, warningMsg, new LocalQuickFix[0]);
        }
    }

    private static boolean isComprehensionTarget(@NotNull PsiElement element) {
        PyComprehensionElement comprehensionExpr;
        if (element == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(12);
        }
        if ((comprehensionExpr = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)element, PyComprehensionElement.class)) == null) {
            return false;
        }
        return ContainerUtil.exists(comprehensionExpr.getForComponents(), it -> PsiTreeUtil.isAncestor((PsiElement)it.getIteratorVariable(), (PsiElement)element, (boolean)false));
    }

    private boolean isRangeIteration(@NotNull PyForStatement forStatement) {
        PyExpression source;
        if (forStatement == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(13);
        }
        if (!((source = forStatement.getForPart().getSource()) instanceof PyCallExpression)) {
            return false;
        }
        PyCallExpression expr = (PyCallExpression)source;
        if (expr.isCalleeText("range", "xrange")) {
            PyResolveContext resolveContext = PyResolveContext.defaultContext(this.myTypeEvalContext);
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(forStatement);
            return ContainerUtil.exists(expr.multiResolveCalleeFunction(resolveContext), builtinCache::isBuiltin);
        }
        return false;
    }

    private boolean ignoreUnusedParameters(PyFunction func, Set<PyFunction> functionsWithInheritors) {
        if (functionsWithInheritors.contains(func)) {
            return true;
        }
        if (!PyUtil.isInitMethod(func) && PySuperMethodsSearch.search(func, this.myTypeEvalContext).findFirst() != null || PyOverridingMethodsSearch.search(func, true).findFirst() != null) {
            functionsWithInheritors.add(func);
            return true;
        }
        return false;
    }

    private boolean isTupleUnpacking(PsiElement element) {
        if (!(element instanceof PyTargetExpression)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PyStarExpression) {
            element = parent;
            parent = element.getParent();
        }
        if (parent instanceof PyTupleExpression) {
            PyTupleExpression tuple = (PyTupleExpression)parent;
            for (PyExpression expression : tuple.getElements()) {
                if (!(expression instanceof PyStarExpression ? !this.myUnusedElements.contains(((PyStarExpression)expression).getExpression()) : !this.myUnusedElements.contains(expression))) continue;
                return true;
            }
        }
        return false;
    }

    private void registerWarning(@NotNull PsiElement element, @InspectionMessage String msg, LocalQuickFix ... quickfixes) {
        if (element == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(14);
        }
        if (quickfixes == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(15);
        }
        this.registerProblem(element, msg, ProblemHighlightType.LIKE_UNUSED_SYMBOL, null, quickfixes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyString";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickfixes";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/unusedLocal/PyUnusedLocalInspectionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyFunction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyLambdaExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyStringLiteralExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getControlFlowAnchorForString";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "parameterInMethodWithFixedSignature";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeReadsInScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isComprehensionTarget";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isRangeIteration";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "registerWarning";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReplaceWithWildCard
    implements LocalQuickFix {
        private ReplaceWithWildCard() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("INSP.unused.locals.replace.with.wildcard", new Object[0]);
            if (string == null) {
                ReplaceWithWildCard.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement;
            PyFile pyFile;
            PyExpression target;
            if (project == null) {
                ReplaceWithWildCard.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceWithWildCard.$$$reportNull$$$0(2);
            }
            if ((target = ((PyForStatement)(pyFile = (PyFile)PyElementGenerator.getInstance((psiElement = descriptor2.getPsiElement()).getProject()).createDummyFile(LanguageLevel.getDefault(), "for _ in tuples:\n  pass")).getStatements().get(0)).getForPart().getTarget()) != null) {
                psiElement.replace((PsiElement)target);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/unusedLocal/PyUnusedLocalInspectionVisitor$ReplaceWithWildCard";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/unusedLocal/PyUnusedLocalInspectionVisitor$ReplaceWithWildCard";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DontPerformException
    extends RuntimeException {
        DontPerformException() {
        }
    }
}

