/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyJoinLinesHandler
implements JoinRawLinesHandlerDelegate {
    private static final Joiner[] JOINERS = new Joiner[]{new OpenBracketJoiner(), new CloseBracketJoiner(), new StringLiteralJoiner(), new StmtJoiner(), new BinaryExprJoiner(), new StripBackslashJoiner()};

    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        if (document == null) {
            PyJoinLinesHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PyJoinLinesHandler.$$$reportNull$$$0(1);
        }
        return -1;
    }

    public int tryJoinRawLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        if (document == null) {
            PyJoinLinesHandler.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PyJoinLinesHandler.$$$reportNull$$$0(3);
        }
        if (!(file instanceof PyFile)) {
            return -1;
        }
        CharSequence text2 = document.getCharsSequence();
        if (start >= 0 && text2.charAt(start) == '\n') {
            --start;
        }
        if (start >= 0 && text2.charAt(start) == '\\') {
            --start;
        }
        while (start >= 0 && (text2.charAt(start) == ' ' || text2.charAt(start) == '\t')) {
            --start;
        }
        if (start < 0) {
            return -1;
        }
        PsiElement leftElement = file.findElementAt(start);
        PsiElement rightElement = file.findElementAt(end);
        if (leftElement != null && rightElement != null) {
            PyExpression leftExpr = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)leftElement, PyExpression.class);
            PyExpression rightExpr = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)rightElement, PyExpression.class);
            Request request = new Request(document, start, end, leftElement, leftExpr, rightElement, rightExpr);
            for (Joiner joiner : JOINERS) {
                Result res = joiner.join(request);
                if (res == null) continue;
                int cutStart = start + 1 - res.cutFromLeft;
                document.replaceString(cutStart, end + res.cutIntoRight, (CharSequence)res.replacement);
                return cutStart + res.caretOffset;
            }
        }
        return -1;
    }

    private static String findReplacement(String text2, int maxLength) {
        String word;
        if (text2.length() < maxLength) {
            return "";
        }
        List words = StringUtil.split((String)text2, (String)" ");
        StringBuilder builder = new StringBuilder();
        boolean delimiterLength = true;
        int wordsLength = 0;
        Iterator iterator = words.iterator();
        while (iterator.hasNext() && (wordsLength += (word = (String)iterator.next()).length() + 1) < maxLength) {
            builder.append(word);
            builder.append(" ");
        }
        return builder.toString();
    }

    private static int getStringToJoinMaxLength(Request request, int symbolsToSkip) {
        int leftLineStartOffset = PyJoinLinesHandler.getLeftLineStartOffset(request);
        int margin = CodeStyle.getSettings((PsiFile)request.leftElem.getContainingFile()).getRightMargin((Language)PythonLanguage.getInstance());
        int leftLineLength = request.document.getLineEndOffset(request.document.getLineNumber(leftLineStartOffset)) - leftLineStartOffset;
        return margin - leftLineLength - symbolsToSkip;
    }

    private static int getLeftLineStartOffset(@NotNull Request req) {
        if (req == null) {
            PyJoinLinesHandler.$$$reportNull$$$0(4);
        }
        int lineNumber = req.document.getLineNumber(req.firstLineEndOffset);
        return req.document.getLineStartOffset(lineNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "req";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/editor/PyJoinLinesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryJoinLines";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryJoinRawLines";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLeftLineStartOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StripBackslashJoiner
    implements Joiner {
        static final TokenSet SINGLE_QUOTED_STRINGS = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.SINGLE_QUOTED_STRING, PyTokenTypes.SINGLE_QUOTED_UNICODE});

        private StripBackslashJoiner() {
        }

        @Override
        @Nullable
        public Result join(@NotNull Request req) {
            String gap;
            int index;
            if (req == null) {
                StripBackslashJoiner.$$$reportNull$$$0(0);
            }
            if ((index = (gap = req.document.getText(new TextRange(req.firstLineEndOffset + 1, req.secondLineStartOffset))).indexOf(92)) >= 0) {
                if (req.leftElem == req.rightElem && SINGLE_QUOTED_STRINGS.contains(req.leftElem.getNode().getElementType())) {
                    return new Result(gap.replaceFirst("\\\\\\n", ""), 0);
                }
                return new Result(gap.substring(0, index), 0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$StripBackslashJoiner", "join"));
        }
    }

    private static class StringLiteralJoiner
    implements Joiner {
        private StringLiteralJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            if (req == null) {
                StringLiteralJoiner.$$$reportNull$$$0(0);
            }
            PyStringElement leftStringElem = (PyStringElement)PsiTreeUtil.getParentOfType((PsiElement)req.leftElem, PyStringElement.class, (boolean)false);
            PyStringElement rightStringElem = (PyStringElement)PsiTreeUtil.getParentOfType((PsiElement)req.rightElem, PyStringElement.class, (boolean)false);
            if (leftStringElem != null && rightStringElem != null && leftStringElem != rightStringElem) {
                PsiElement parent = rightStringElem.getParent();
                if ((leftStringElem.getParent() == parent && parent instanceof PyStringLiteralExpression || req.leftExpr instanceof PyStringLiteralExpression && req.rightExpr instanceof PyStringLiteralExpression) && leftStringElem.isTerminated() && rightStringElem.isTerminated() && StringLiteralJoiner.haveSamePrefixes(leftStringElem, rightStringElem)) {
                    String leftElemQuotes = leftStringElem.getQuote();
                    String rightElemQuotes = rightStringElem.getQuote();
                    int quotesMaxLength = Math.max(leftElemQuotes.length(), rightElemQuotes.length());
                    int stringToJoinMaxLength = PyJoinLinesHandler.getStringToJoinMaxLength(req, quotesMaxLength);
                    String replacement = PyJoinLinesHandler.findReplacement(rightStringElem.getContent(), stringToJoinMaxLength);
                    if (leftElemQuotes.equals(rightElemQuotes)) {
                        return StringLiteralJoiner.getResultAndSplitStringIfTooLong(req, leftStringElem, rightStringElem, replacement, leftElemQuotes);
                    }
                    return StringLiteralJoiner.processStringsWithDifferentQuotes(req, leftStringElem, rightStringElem, replacement);
                }
            }
            return null;
        }

        @Nullable
        private static Result processStringsWithDifferentQuotes(@NotNull Request req, @NotNull PyStringElement leftElem, @NotNull PyStringElement rightElem, @NotNull String replacement) {
            if (req == null) {
                StringLiteralJoiner.$$$reportNull$$$0(1);
            }
            if (leftElem == null) {
                StringLiteralJoiner.$$$reportNull$$$0(2);
            }
            if (rightElem == null) {
                StringLiteralJoiner.$$$reportNull$$$0(3);
            }
            if (replacement == null) {
                StringLiteralJoiner.$$$reportNull$$$0(4);
            }
            if (!leftElem.isTripleQuoted() && !rightElem.isTripleQuoted()) {
                if (!rightElem.getContent().contains(leftElem.getQuote())) {
                    int quotePos = rightElem.getTextOffset() + rightElem.getContentRange().getEndOffset();
                    String quote = leftElem.getQuote();
                    req.document.replaceString(quotePos, quotePos + 1, (CharSequence)quote);
                    return StringLiteralJoiner.getResultAndSplitStringIfTooLong(req, leftElem, rightElem, replacement, quote);
                }
                if (!leftElem.getContent().contains(rightElem.getQuote())) {
                    int quotePos = leftElem.getTextOffset() + leftElem.getContentRange().getStartOffset() - 1;
                    String quote = rightElem.getQuote();
                    req.document.replaceString(quotePos, quotePos + 1, (CharSequence)quote);
                    return StringLiteralJoiner.getResultAndSplitStringIfTooLong(req, leftElem, rightElem, replacement, quote);
                }
            }
            return null;
        }

        @NotNull
        private static Result getResultAndSplitStringIfTooLong(@NotNull Request req, @NotNull PyStringElement leftElem, @NotNull PyStringElement rightElem, @NotNull String replacement, @NotNull String quote) {
            if (req == null) {
                StringLiteralJoiner.$$$reportNull$$$0(5);
            }
            if (leftElem == null) {
                StringLiteralJoiner.$$$reportNull$$$0(6);
            }
            if (rightElem == null) {
                StringLiteralJoiner.$$$reportNull$$$0(7);
            }
            if (replacement == null) {
                StringLiteralJoiner.$$$reportNull$$$0(8);
            }
            if (quote == null) {
                StringLiteralJoiner.$$$reportNull$$$0(9);
            }
            int cutIntoRight = rightElem.getContentRange().getStartOffset();
            Object lineEnd = "";
            if (!replacement.isEmpty()) {
                cutIntoRight = replacement.length() + rightElem.getQuote().length();
                int contentWithQuoteStartColumn = leftElem.getTextOffset() + leftElem.getPrefixLength() - PyJoinLinesHandler.getLeftLineStartOffset(req);
                int quotePos = rightElem.getTextOffset() + rightElem.getContentRange().getStartOffset() + replacement.length();
                req.document.insertString(quotePos, (CharSequence)rightElem.getQuote());
                req.document.insertString(quotePos, (CharSequence)StringUtil.repeat((String)" ", (int)contentWithQuoteStartColumn));
                lineEnd = quote + "\\\n";
            }
            return new Result(replacement + (String)lineEnd, 0, leftElem.getQuote().length(), cutIntoRight);
        }

        private static boolean haveSamePrefixes(@NotNull PyStringElement leftNodeInfo, @NotNull PyStringElement rightNodeInfo) {
            if (leftNodeInfo == null) {
                StringLiteralJoiner.$$$reportNull$$$0(10);
            }
            if (rightNodeInfo == null) {
                StringLiteralJoiner.$$$reportNull$$$0(11);
            }
            return leftNodeInfo.isUnicode() == rightNodeInfo.isUnicode() && leftNodeInfo.isRaw() == rightNodeInfo.isRaw() && leftNodeInfo.isBytes() == rightNodeInfo.isBytes() && leftNodeInfo.isFormatted() == rightNodeInfo.isFormatted();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "req";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftElem";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightElem";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "quote";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftNodeInfo";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightNodeInfo";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/editor/PyJoinLinesHandler$StringLiteralJoiner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "join";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processStringsWithDifferentQuotes";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getResultAndSplitStringIfTooLong";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "haveSamePrefixes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StmtJoiner
    implements Joiner {
        private StmtJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            PyStatement rightStmt;
            PyStatement leftStmt;
            if (req == null) {
                StmtJoiner.$$$reportNull$$$0(0);
            }
            if ((leftStmt = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)req.leftExpr, PyStatement.class)) != null && (rightStmt = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)req.rightExpr, PyStatement.class)) != null && rightStmt != leftStmt) {
                return new Result("; ", 1);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$StmtJoiner", "join"));
        }
    }

    private static class BinaryExprJoiner
    implements Joiner {
        private BinaryExprJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            if (req == null) {
                BinaryExprJoiner.$$$reportNull$$$0(0);
            }
            if (req.leftExpr instanceof PyBinaryExpression || req.rightExpr instanceof PyBinaryExpression) {
                return new Result(" ", 1);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$BinaryExprJoiner", "join"));
        }
    }

    private static class CloseBracketJoiner
    implements Joiner {
        private static final TokenSet CLOSES = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.RBRACKET, PyTokenTypes.RBRACE, PyTokenTypes.RPAR});

        private CloseBracketJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            if (req == null) {
                CloseBracketJoiner.$$$reportNull$$$0(0);
            }
            if (CLOSES.contains(req.rightElem.getNode().getElementType())) {
                return new Result("", 0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$CloseBracketJoiner", "join"));
        }
    }

    private static class OpenBracketJoiner
    implements Joiner {
        private static final TokenSet OPENS = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LBRACKET, PyTokenTypes.LBRACE, PyTokenTypes.LPAR});

        private OpenBracketJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            if (req == null) {
                OpenBracketJoiner.$$$reportNull$$$0(0);
            }
            if (OPENS.contains(req.leftElem.getNode().getElementType())) {
                return new Result("", 0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$OpenBracketJoiner", "join"));
        }
    }

    private static interface Joiner {
        @Nullable
        public Result join(@NotNull Request var1);
    }

    private static final class Request {
        final Document document;
        final PsiElement leftElem;
        final PsiElement rightElem;
        final PyExpression leftExpr;
        final PyExpression rightExpr;
        final int secondLineStartOffset;
        final int firstLineEndOffset;

        private Request(@NotNull Document document, int firstLineEndOffset, int secondLineStartOffset, @NotNull PsiElement leftElem, @Nullable PyExpression leftExpr, @NotNull PsiElement rightElem, @Nullable PyExpression rightExpr) {
            if (document == null) {
                Request.$$$reportNull$$$0(0);
            }
            if (leftElem == null) {
                Request.$$$reportNull$$$0(1);
            }
            if (rightElem == null) {
                Request.$$$reportNull$$$0(2);
            }
            this.document = document;
            this.firstLineEndOffset = firstLineEndOffset;
            this.secondLineStartOffset = secondLineStartOffset;
            this.leftElem = leftElem;
            this.rightElem = rightElem;
            this.leftExpr = leftExpr;
            this.rightExpr = rightExpr;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leftElem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rightElem";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/editor/PyJoinLinesHandler$Request";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Result {
        final String replacement;
        final int caretOffset;
        final int cutFromLeft;
        final int cutIntoRight;

        Result(@NotNull String replacement, int cursorOffset) {
            if (replacement == null) {
                Result.$$$reportNull$$$0(0);
            }
            this(replacement, cursorOffset, 0, 0);
        }

        Result(@NotNull String replacement, int cursorOffset, int cutFromLeft, int cutIntoRight) {
            if (replacement == null) {
                Result.$$$reportNull$$$0(1);
            }
            this.cutFromLeft = cutFromLeft;
            this.cutIntoRight = cutIntoRight;
            this.replacement = replacement;
            this.caretOffset = cursorOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/jetbrains/python/editor/PyJoinLinesHandler$Result", "<init>"));
        }
    }
}

