/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.python.documentation.docstrings.DocStringUpdater;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocStringBuilder;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SectionBasedDocStringUpdater
extends DocStringUpdater<SectionBasedDocString> {
    private static final ImmutableList<String> CANONICAL_SECTION_ORDER = ImmutableList.of((Object)"parameters", (Object)"keyword arguments", (Object)"other parameters", (Object)"yields", (Object)"returns", (Object)"raises");
    private final List<AddParameter> myAddParameterRequests;

    public SectionBasedDocStringUpdater(@NotNull SectionBasedDocString docString, @NotNull String minContentIndent) {
        if (docString == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(0);
        }
        if (minContentIndent == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(1);
        }
        super(docString, minContentIndent);
        this.myAddParameterRequests = new ArrayList<AddParameter>();
    }

    @Override
    public final void addParameter(@NotNull String name2, @Nullable String type) {
        if (name2 == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(2);
        }
        this.myAddParameterRequests.add(new AddParameter(name2, type));
    }

    @Override
    public final void addReturnValue(@Nullable String type) {
        if (StringUtil.isEmpty((String)type)) {
            return;
        }
        Substring typeSub = ((SectionBasedDocString)this.myOriginalDocString).getReturnTypeSubstring();
        if (typeSub != null) {
            this.replace(typeSub.getTextRange(), type);
            return;
        }
        SectionBasedDocString.Section returnSection = this.findFirstReturnSection();
        if (returnSection != null) {
            List<SectionBasedDocString.SectionField> fields = returnSection.getFields();
            if (!fields.isEmpty()) {
                SectionBasedDocString.SectionField firstField = fields.get(0);
                String newLine = this.createReturnLine(type, this.getSectionIndent(returnSection), this.getFieldIndent(returnSection, firstField));
                this.insertBeforeLine(this.getFieldStartLine(firstField), newLine);
            } else {
                String newLine = this.createReturnLine(type, this.getSectionIndent(returnSection), this.getExpectedFieldIndent());
                this.insertAfterLine(this.getSectionTitleLastLine(returnSection), newLine);
            }
        } else {
            SectionBasedDocStringBuilder builder = this.createBuilder().withSectionIndent(this.getExpectedFieldIndent()).startReturnsSection().addReturnValue(null, type, "");
            this.insertNewSection(builder, "returns");
        }
    }

    @Override
    public void removeParameter(@NotNull String name2) {
        if (name2 == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(3);
        }
        block0: for (SectionBasedDocString.Section section : ((SectionBasedDocString)this.myOriginalDocString).getParameterSections()) {
            List<SectionBasedDocString.SectionField> sectionFields = section.getFields();
            for (SectionBasedDocString.SectionField field : sectionFields) {
                Substring nameSub = (Substring)ContainerUtil.find(field.getNamesAsSubstrings(), substring -> substring.toString().equals(name2));
                if (nameSub == null) continue;
                if (field.getNamesAsSubstrings().size() == 1) {
                    int endLine = this.getFieldEndLine(field);
                    if (sectionFields.size() == 1) {
                        this.removeLinesAndSpacesAfter(this.getSectionStartLine(section), endLine + 1);
                        continue block0;
                    }
                    int startLine = this.getFieldStartLine(field);
                    if (ContainerUtil.getLastItem(sectionFields) == field) {
                        this.removeLines(startLine, endLine + 1);
                        continue block0;
                    }
                    this.removeLinesAndSpacesAfter(startLine, endLine + 1);
                    continue block0;
                }
                Substring wholeParamName = SectionBasedDocStringUpdater.expandParamNameSubstring(nameSub);
                this.remove(wholeParamName.getStartOffset(), wholeParamName.getEndOffset());
                continue block0;
            }
        }
    }

    @NotNull
    private static Substring expandParamNameSubstring(@NotNull Substring name2) {
        if (name2 == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(4);
        }
        String superString = name2.getSuperString();
        int startWithStars = name2.getStartOffset();
        int prevNonWhitespace = SectionBasedDocStringUpdater.skipSpacesBackward(superString, name2.getStartOffset() - 1);
        if (prevNonWhitespace >= 0 && superString.charAt(prevNonWhitespace) == '*') {
            startWithStars = CharArrayUtil.shiftBackward((CharSequence)superString, (int)prevNonWhitespace, (String)"*") + 1;
            prevNonWhitespace = SectionBasedDocStringUpdater.skipSpacesBackward(superString, startWithStars - 1);
        }
        if (prevNonWhitespace >= 0 && superString.charAt(prevNonWhitespace) == ',') {
            return new Substring(superString, prevNonWhitespace, name2.getEndOffset());
        }
        int nextNonWhitespace = SectionBasedDocStringUpdater.skipSpacesForward(superString, name2.getEndOffset());
        if (nextNonWhitespace < superString.length() && superString.charAt(nextNonWhitespace) == ',') {
            return new Substring(superString, startWithStars, SectionBasedDocStringUpdater.skipSpacesForward(superString, nextNonWhitespace + 1));
        }
        Substring substring = name2;
        if (substring == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(5);
        }
        return substring;
    }

    private static int skipSpacesForward(@NotNull String superString, int offset) {
        if (superString == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(6);
        }
        return CharArrayUtil.shiftForward((CharSequence)superString, (int)offset, (String)" \t");
    }

    private static int skipSpacesBackward(@NotNull String superString, int offset) {
        if (superString == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(7);
        }
        return CharArrayUtil.shiftBackward((CharSequence)superString, (int)offset, (String)" \t");
    }

    @Override
    protected void beforeApplyingModifications() {
        ArrayList<AddParameter> newParams = new ArrayList<AddParameter>();
        for (AddParameter param : this.myAddParameterRequests) {
            if (param.type != null) {
                Substring typeSub = ((SectionBasedDocString)this.myOriginalDocString).getParamTypeSubstring(param.name);
                if (typeSub != null) {
                    this.replace(typeSub.getTextRange(), param.type);
                    continue;
                }
                Substring nameSub = this.findParamNameSubstring(param.name);
                if (nameSub != null) {
                    this.updateParamDeclarationWithType(nameSub, param.type);
                    continue;
                }
            }
            newParams.add(param);
        }
        if (!newParams.isEmpty()) {
            SectionBasedDocStringBuilder paramBlockBuilder = this.createBuilder();
            SectionBasedDocString.Section firstParamSection = this.findFirstParametersSection();
            if (firstParamSection == null) {
                paramBlockBuilder.startParametersSection();
                SectionBasedDocStringBuilder builder = SectionBasedDocStringUpdater.addParametersInBlock(paramBlockBuilder, newParams, this.getExpectedFieldIndent());
                this.insertNewSection(builder, "parameters");
            } else {
                String blockText;
                SectionBasedDocString.SectionField firstParamField = (SectionBasedDocString.SectionField)ContainerUtil.getFirstItem(firstParamSection.getFields());
                if (firstParamField == null) {
                    blockText = SectionBasedDocStringUpdater.buildBlock(paramBlockBuilder, newParams, this.getExpectedFieldIndent(), this.getSectionIndent(firstParamSection));
                    this.insertAfterLine(this.getSectionTitleLastLine(firstParamSection), blockText);
                } else {
                    blockText = SectionBasedDocStringUpdater.buildBlock(paramBlockBuilder, newParams, this.getFieldIndent(firstParamSection, firstParamField), this.getSectionIndent(firstParamSection));
                    this.insertBeforeLine(this.getFieldStartLine(firstParamField), blockText);
                }
            }
        }
    }

    @NotNull
    private static String buildBlock(@NotNull SectionBasedDocStringBuilder builder, @NotNull List<AddParameter> params, @NotNull String sectionIndent, @NotNull String indent) {
        if (builder == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(8);
        }
        if (params == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(9);
        }
        if (sectionIndent == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(10);
        }
        if (indent == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(11);
        }
        String string = SectionBasedDocStringUpdater.addParametersInBlock(builder, params, sectionIndent).buildContent(indent, true);
        if (string == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static SectionBasedDocStringBuilder addParametersInBlock(@NotNull SectionBasedDocStringBuilder builder, @NotNull List<AddParameter> params, @NotNull String sectionIndent) {
        if (builder == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(13);
        }
        if (params == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(14);
        }
        if (sectionIndent == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(15);
        }
        builder.withSectionIndent(sectionIndent);
        for (AddParameter param : params) {
            builder.addParameter(param.name, param.type, "");
        }
        return builder;
    }

    private void insertNewSection(@NotNull SectionBasedDocStringBuilder builder, @NotNull String sectionTitle) {
        Pair<Integer, Boolean> pos;
        if (builder == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(16);
        }
        if (sectionTitle == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(17);
        }
        if (((Boolean)(pos = this.findPreferredSectionLine(sectionTitle)).getSecond()).booleanValue()) {
            if (!((SectionBasedDocString)this.myOriginalDocString).isEmpty((Integer)pos.getFirst())) {
                builder.addEmptyLine(0);
            }
            this.insertAfterLine((Integer)pos.getFirst(), builder.buildContent(this.getExpectedSectionIndent(), true));
        } else {
            if (!((SectionBasedDocString)this.myOriginalDocString).isEmpty((Integer)pos.getFirst())) {
                builder.addEmptyLine();
            }
            this.insertBeforeLine((Integer)pos.getFirst(), builder.buildContent(this.getExpectedSectionIndent(), true));
        }
    }

    private Pair<Integer, Boolean> findPreferredSectionLine(@NotNull String sectionTitle) {
        int i;
        String normalized;
        int index;
        if (sectionTitle == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(18);
        }
        if ((index = CANONICAL_SECTION_ORDER.indexOf((Object)(normalized = SectionBasedDocString.getNormalizedSectionTitle(sectionTitle)))) < 0) {
            return Pair.create((Object)this.findLastNonEmptyLine(), (Object)true);
        }
        HashMap<String, SectionBasedDocString.Section> namedSections = new HashMap<String, SectionBasedDocString.Section>();
        for (SectionBasedDocString.Section section : ((SectionBasedDocString)this.myOriginalDocString).getSections()) {
            String normalizedTitle = section.getNormalizedTitle();
            if (namedSections.containsKey(normalizedTitle)) continue;
            namedSections.put(normalizedTitle, section);
        }
        for (i = index - 1; i >= 0; --i) {
            SectionBasedDocString.Section previous = (SectionBasedDocString.Section)namedSections.get(CANONICAL_SECTION_ORDER.get(i));
            if (previous == null) continue;
            return Pair.create((Object)this.getSectionEndLine(previous), (Object)true);
        }
        for (i = index + 1; i < CANONICAL_SECTION_ORDER.size(); ++i) {
            SectionBasedDocString.Section next = (SectionBasedDocString.Section)namedSections.get(CANONICAL_SECTION_ORDER.get(i));
            if (next == null) continue;
            return Pair.create((Object)this.getSectionStartLine(next), (Object)false);
        }
        return Pair.create((Object)this.findLastNonEmptyLine(), (Object)true);
    }

    protected abstract void updateParamDeclarationWithType(@NotNull Substring var1, @NotNull String var2);

    @NotNull
    protected abstract SectionBasedDocStringBuilder createBuilder();

    @Nullable
    private Substring findParamNameSubstring(@NotNull String name2) {
        if (name2 == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(19);
        }
        return (Substring)ContainerUtil.find(((SectionBasedDocString)this.myOriginalDocString).getParameterSubstrings(), substring -> substring.toString().equals(name2));
    }

    protected int getSectionTitleLastLine(@NotNull SectionBasedDocString.Section paramSection) {
        if (paramSection == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(20);
        }
        return this.getSectionStartLine(paramSection);
    }

    protected String createReturnLine(@NotNull String type, @NotNull String docStringIndent, @NotNull String sectionIndent) {
        if (type == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(21);
        }
        if (docStringIndent == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(22);
        }
        if (sectionIndent == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(23);
        }
        return this.createBuilder().withSectionIndent(sectionIndent).addReturnValue(null, type, "").buildContent(docStringIndent, true);
    }

    @Nullable
    protected SectionBasedDocString.Section findFirstParametersSection() {
        return (SectionBasedDocString.Section)ContainerUtil.find(((SectionBasedDocString)this.myOriginalDocString).getSections(), section -> section.getNormalizedTitle().equals("parameters"));
    }

    @Nullable
    protected SectionBasedDocString.Section findFirstReturnSection() {
        return (SectionBasedDocString.Section)ContainerUtil.find(((SectionBasedDocString)this.myOriginalDocString).getSections(), section -> section.getNormalizedTitle().equals("returns"));
    }

    @NotNull
    protected String getExpectedSectionIndent() {
        SectionBasedDocString.Section first = (SectionBasedDocString.Section)ContainerUtil.getFirstItem(((SectionBasedDocString)this.myOriginalDocString).getSections());
        String string = first != null ? this.getSectionIndent(first) : this.myMinContentIndent;
        if (string == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    protected String getExpectedFieldIndent() {
        for (SectionBasedDocString.Section section : ((SectionBasedDocString)this.myOriginalDocString).getSections()) {
            List<SectionBasedDocString.SectionField> fields = section.getFields();
            if (fields.isEmpty()) continue;
            String string = this.getFieldIndent(section, fields.get(0));
            if (string == null) {
                SectionBasedDocStringUpdater.$$$reportNull$$$0(25);
            }
            return string;
        }
        String string = this.createBuilder().mySectionIndent;
        if (string == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    protected String getFieldIndent(@NotNull SectionBasedDocString.Section section, @NotNull SectionBasedDocString.SectionField field) {
        if (section == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(27);
        }
        if (field == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(28);
        }
        String titleIndent = this.getSectionIndent(section);
        String fieldIndent = this.getLineIndent(this.getFieldStartLine(field));
        int diffSize = Math.max(0, PyIndentUtil.getLineIndentSize(fieldIndent) - PyIndentUtil.getLineIndentSize(titleIndent));
        String string = StringUtil.repeatSymbol((char)' ', (int)diffSize);
        if (string == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    protected String getSectionIndent(@NotNull SectionBasedDocString.Section section) {
        if (section == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(30);
        }
        String string = this.getLineIndent(this.getSectionStartLine(section));
        if (string == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(31);
        }
        return string;
    }

    protected int getSectionStartLine(@NotNull SectionBasedDocString.Section section) {
        if (section == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(32);
        }
        return section.getTitleAsSubstring().getStartLine();
    }

    protected int getSectionEndLine(@NotNull SectionBasedDocString.Section section) {
        List<SectionBasedDocString.SectionField> fields;
        if (section == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(33);
        }
        return (fields = section.getFields()).isEmpty() ? this.getSectionTitleLastLine(section) : this.getFieldEndLine((SectionBasedDocString.SectionField)ContainerUtil.getLastItem(fields));
    }

    protected int getFieldStartLine(@NotNull SectionBasedDocString.SectionField field) {
        if (field == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(34);
        }
        return SectionBasedDocStringUpdater.chooseFirstNotNull(field.getNameAsSubstring(), field.getTypeAsSubstring(), field.getDescriptionAsSubstring()).getStartLine();
    }

    protected int getFieldEndLine(@NotNull SectionBasedDocString.SectionField field) {
        if (field == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(35);
        }
        return SectionBasedDocStringUpdater.chooseFirstNotNull(field.getDescriptionAsSubstring(), field.getTypeAsSubstring(), field.getNameAsSubstring()).getEndLine();
    }

    @NotNull
    private static <T> T chooseFirstNotNull(T ... values) {
        if (values == null) {
            SectionBasedDocStringUpdater.$$$reportNull$$$0(36);
        }
        for (T value : values) {
            if (value == null) continue;
            T t = value;
            if (t == null) {
                SectionBasedDocStringUpdater.$$$reportNull$$$0(37);
            }
            return t;
        }
        throw new NullPointerException("At least one of values must be not null");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 12: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minContentIndent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 12: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocStringUpdater";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superString";
                break;
            }
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 10: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionIndent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionTitle";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramSection";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docStringIndent";
                break;
            }
            case 27: 
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 28: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocStringUpdater";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "expandParamNameSubstring";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildBlock";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedSectionIndent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFieldIndent";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldIndent";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSectionIndent";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseFirstNotNull";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeParameter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "expandParamNameSubstring";
                break;
            }
            case 5: 
            case 12: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 37: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "skipSpacesForward";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipSpacesBackward";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildBlock";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addParametersInBlock";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "insertNewSection";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findPreferredSectionLine";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findParamNameSubstring";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSectionTitleLastLine";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createReturnLine";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFieldIndent";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSectionIndent";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSectionStartLine";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSectionEndLine";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getFieldStartLine";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFieldEndLine";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "chooseFirstNotNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 12: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddParameter {
        @NotNull
        final String name;
        @Nullable
        final String type;

        AddParameter(@NotNull String name2, @Nullable String type) {
            if (name2 == null) {
                AddParameter.$$$reportNull$$$0(0);
            }
            this.name = name2;
            this.type = type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/documentation/docstrings/SectionBasedDocStringUpdater$AddParameter", "<init>"));
        }
    }
}

