/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentPaths;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.remote.PyRemotePathMapper;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/debugger/PyTargetPathMapper;", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "targetEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "pathMappingSettings", "Lcom/intellij/util/PathMappingSettings;", "(Lcom/intellij/execution/target/TargetEnvironment;Lcom/intellij/util/PathMappingSettings;)V", "convertToLocal", "", "remotePath", "convertToRemote", "localPath", "isEmpty", "", "intellij.python.community.impl"})
final class PyTargetPathMapper
extends PyRemotePathMapper {
    private final TargetEnvironment targetEnvironment;
    private final PathMappingSettings pathMappingSettings;

    @Override
    @NotNull
    public String convertToLocal(@NotNull String remotePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        String string2 = AbstractPathMapper.convertToLocal((String)remotePath, (Iterable)this.pathMappingSettings.getPathMappings());
        if (string2 == null) {
            string2 = string = (String)CollectionsKt.firstOrNull((List)TargetEnvironmentPaths.getLocalPaths((TargetEnvironment)this.targetEnvironment, (String)remotePath));
        }
        if (string2 == null) {
            String string3 = super.convertToLocal(remotePath);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"super.convertToLocal(remotePath)");
        }
        return string;
    }

    @Override
    @NotNull
    public String convertToRemote(@NotNull String localPath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        String string2 = AbstractPathMapper.convertToRemote((String)localPath, (Collection)this.pathMappingSettings.getPathMappings());
        if (string2 == null) {
            String string3 = FileUtil.toSystemDependentName((String)localPath);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FileUtil.toSystemDependentName(localPath)");
            string2 = string = (String)CollectionsKt.firstOrNull((List)TargetEnvironmentPaths.getTargetPaths((TargetEnvironment)this.targetEnvironment, (String)string3));
        }
        if (string2 == null) {
            String string4 = super.convertToRemote(localPath);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"super.convertToRemote(localPath)");
        }
        return string;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public PyTargetPathMapper(@NotNull TargetEnvironment targetEnvironment, @NotNull PathMappingSettings pathMappingSettings) {
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Intrinsics.checkNotNullParameter((Object)pathMappingSettings, (String)"pathMappingSettings");
        this.targetEnvironment = targetEnvironment;
        this.pathMappingSettings = pathMappingSettings;
    }
}

