/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.completion;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.console.completion.PydevConsoleElement;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.PyCodeCompletionImages;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PydevConsoleReference
extends PsiPolyVariantReferenceBase<PyReferenceExpression> {
    private final ConsoleCommunication myCommunication;
    private final String myPrefix;
    private final boolean myAllowRemoteResolve;

    public PydevConsoleReference(PyReferenceExpression expression, ConsoleCommunication communication, String prefix, boolean allowRemoteResolve) {
        super((PsiElement)expression, true);
        this.myCommunication = communication;
        this.myPrefix = prefix;
        this.myAllowRemoteResolve = allowRemoteResolve;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiElement resolved;
        PsiReference redirectedRef;
        if (!this.myAllowRemoteResolve) {
            if (RatedResolveResult.EMPTY_ARRAY == null) {
                PydevConsoleReference.$$$reportNull$$$0(0);
            }
            return RatedResolveResult.EMPTY_ARRAY;
        }
        PyExpression pyExpression = this.resolveToDummyDescription();
        if (pyExpression == null) {
            if (RatedResolveResult.EMPTY_ARRAY == null) {
                PydevConsoleReference.$$$reportNull$$$0(1);
            }
            return RatedResolveResult.EMPTY_ARRAY;
        }
        if (pyExpression instanceof PyReferenceExpression && (redirectedRef = pyExpression.getReference()) != null && (resolved = redirectedRef.resolve()) != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new RatedResolveResult(1000, resolved)};
            if (resolveResultArray == null) {
                PydevConsoleReference.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        if (RatedResolveResult.EMPTY_ARRAY == null) {
            PydevConsoleReference.$$$reportNull$$$0(3);
        }
        return RatedResolveResult.EMPTY_ARRAY;
    }

    public PyElement getDocumentationElement() {
        return this.resolveToDummyDescription();
    }

    private PyExpression resolveToDummyDescription() {
        List<PyStatement> statements;
        PyStatement pyStatement;
        String description;
        String qualifiedName = ((PyReferenceExpression)this.myElement).getText();
        if (qualifiedName == null) {
            return null;
        }
        try {
            description = this.myCommunication.getDescription(qualifiedName);
            if (Strings.isNullOrEmpty((String)description)) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(((PyReferenceExpression)this.myElement).getProject());
        PyFile dummyFile = (PyFile)generator.createDummyFile(LanguageLevel.forElement(this.myElement), description);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        if (module != null) {
            dummyFile.putUserData(ModuleUtilCore.KEY_MODULE, module);
        }
        return (pyStatement = (statements = dummyFile.getStatements()).get(statements.size() - 1)) instanceof PyExpressionStatement ? ((PyExpressionStatement)pyStatement).getExpression() : null;
    }

    public Object @NotNull [] getVariants() {
        HashMap variants = Maps.newHashMap();
        try {
            List<PydevCompletionVariant> completions = this.myCommunication.getCompletions(this.getText(), this.myPrefix);
            for (PydevCompletionVariant completion : completions) {
                PsiManager manager = ((PyReferenceExpression)this.myElement).getManager();
                String name2 = completion.getName();
                int type = completion.getType();
                LookupElementBuilder builder = LookupElementBuilder.create((PsiNamedElement)new PydevConsoleElement(manager, name2, completion.getDescription())).withIcon(PyCodeCompletionImages.getImageForType(type));
                String args2 = completion.getArgs();
                if (args2.equals("(%)")) {
                    builder = builder.withPresentableText("%" + completion.getName());
                    builder = builder.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
                            if (context2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (item == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            Editor editor2 = context2.getEditor();
                            Document document = editor2.getDocument();
                            int offset = context2.getStartOffset();
                            if (offset == 0 || !"%".equals(document.getText(TextRange.from((int)(offset - 1), (int)1)))) {
                                document.insertString(offset, (CharSequence)"%");
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "context";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "item";
                                    break;
                                }
                            }
                            objectArray[1] = "com/jetbrains/python/console/completion/PydevConsoleReference$1";
                            objectArray[2] = "handleInsert";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    args2 = "";
                } else if (!StringUtil.isEmptyOrSpaces((String)args2)) {
                    builder = builder.withTailText(args2);
                }
                if (type == 2 || args2.endsWith(")")) {
                    builder = builder.withInsertHandler((InsertHandler)ParenthesesInsertHandler.WITH_PARAMETERS);
                }
                variants.put(name2, builder);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] objectArray = variants.values().toArray();
        if (objectArray == null) {
            PydevConsoleReference.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    private String getText() {
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyFile.class);
        if (element != null) {
            return element.getText().replace("IntellijIdeaRulezzz ", "");
        }
        return this.myPrefix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/console/completion/PydevConsoleReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

