/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.console.protocol.ArrayHeaders;
import com.jetbrains.python.console.protocol.ColHeader;
import com.jetbrains.python.console.protocol.DebugValue;
import com.jetbrains.python.console.protocol.GetArrayResponse;
import com.jetbrains.python.console.protocol.RowHeader;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.ArrayChunkBuilder;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyFrameAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005\u001a&\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"createArrayChunk", "Lcom/jetbrains/python/debugger/ArrayChunk;", "response", "Lcom/jetbrains/python/console/protocol/GetArrayResponse;", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "createPyDebugValue", "Lcom/jetbrains/python/debugger/PyDebugValue;", "value", "Lcom/jetbrains/python/console/protocol/DebugValue;", "parseVars", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "vars", "", "parent", "intellij.python.community.impl"})
@JvmName(name="PydevConsoleCommunicationUtil")
public final class PydevConsoleCommunicationUtil {
    @NotNull
    public static final XValueChildrenList parseVars(@NotNull List<? extends DebugValue> vars, @Nullable PyDebugValue parent, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        XValueChildrenList list = new XValueChildrenList(vars.size());
        for (DebugValue debugValue : vars) {
            PyDebugValue pyDebugValue = PydevConsoleCommunicationUtil.createPyDebugValue(debugValue, frameAccessor);
            if (parent != null) {
                pyDebugValue.setParent(parent);
            }
            list.add(pyDebugValue.getVisibleName(), (XValue)pyDebugValue);
        }
        return list;
    }

    @NotNull
    public static final PyDebugValue createPyDebugValue(@NotNull DebugValue value, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        String string = value.name;
        String string2 = value.type;
        String string3 = value.qualifier;
        String string4 = value.value;
        if (string4 == null) {
            string4 = "";
        }
        return new PyDebugValue(string, string2, string3, string4, value.isContainer, value.shape, value.isReturnedValue, value.isIPythonHidden, value.isErrorOnEval, value.typeRendererId, frameAccessor);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ArrayChunk createArrayChunk(@NotNull GetArrayResponse response, @NotNull PyFrameAccessor frameAccessor) {
        boolean bl;
        Object object;
        Iterator iterator;
        Object it;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        ArrayChunkBuilder result = new ArrayChunkBuilder();
        result.setSlicePresentation(response.slice);
        result.setRows(response.rows);
        result.setColumns(response.cols);
        result.setFormat(response.format);
        result.setType(response.type);
        result.setMax(response.max);
        result.setMin(response.min);
        result.setValue(new PyDebugValue(response.slice, null, null, null, false, null, false, false, false, null, frameAccessor));
        ArrayList<String> rowHeaders = new ArrayList<String>();
        ArrayList<ArrayChunk.ColHeader> colHeaders = new ArrayList<ArrayChunk.ColHeader>();
        Object object3 = response.headers;
        if (object3 != null && (object3 = ((ArrayHeaders)object3).colHeaders) != null) {
            it = object2 = object3;
            boolean bl2 = false;
            iterator = it.iterator();
            while (iterator.hasNext()) {
                ColHeader colHeader = (ColHeader)iterator.next();
                colHeaders.add(new ArrayChunk.ColHeader(colHeader.label, colHeader.type, colHeader.format, colHeader.max, colHeader.min));
            }
        }
        if ((object = response.headers) != null && (object = ((ArrayHeaders)object).rowHeaders) != null) {
            it = object2 = object;
            bl = false;
            iterator = it.iterator();
            while (iterator.hasNext()) {
                RowHeader rowHeader = (RowHeader)iterator.next();
                rowHeaders.add(rowHeader.label);
            }
        }
        result.setColHeaders((List<ArrayChunk.ColHeader>)colHeaders);
        result.setRowLabels((List<String>)rowHeaders);
        List<List<String>> responseData = response.data.data;
        Object[][] data = new Object[responseData.size()][];
        bl = false;
        List<List<String>> list = responseData;
        Intrinsics.checkNotNullExpressionValue(list, (String)"responseData");
        for (List responseRowArray : (Iterable)list) {
            void rowIndex;
            Object[] rowValues = new Object[responseRowArray.size()];
            boolean bl3 = false;
            List list2 = responseRowArray;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"responseRowArray");
            for (String responseColArray : (Iterable)list2) {
                void colIndex;
                rowValues[colIndex] = responseColArray;
                ++colIndex;
            }
            data[rowIndex] = rowValues;
            ++rowIndex;
        }
        result.setData(data);
        ArrayChunk arrayChunk = result.createArrayChunk();
        Intrinsics.checkNotNullExpressionValue((Object)arrayChunk, (String)"result.createArrayChunk()");
        return arrayChunk;
    }
}

