/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.NullableConsumer;
import com.intellij.util.NullableFunction;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.EditSdkDialog;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.PyRemotePathEditor;
import com.jetbrains.python.configuration.PythonPathDialog;
import com.jetbrains.python.configuration.PythonPathEditor;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkDetailsDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(PythonSdkDetailsDialog.class);
    private boolean myModified;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Module myModule;
    @NotNull
    private final NullableConsumer<? super Sdk> mySelectedSdkCallback;
    @NotNull
    private final Consumer<Boolean> myCancelCallback;
    @NotNull
    private final SdkModel.Listener mySdkModelListener;
    @NotNull
    private final PyConfigurableInterpreterList myInterpreterList;
    @NotNull
    private final ProjectSdksModel myProjectSdksModel;
    @NotNull
    private final JBList<Sdk> mySdkList;
    @NotNull
    private final JPanel myMainPanel;
    private boolean myHideOtherProjectVirtualenvs;

    public PythonSdkDetailsDialog(@NotNull Project project, @Nullable Module module, @NotNull NullableConsumer<? super Sdk> selectedSdkCallback, @NotNull Consumer<Boolean> cancelCallback) {
        if (project == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(0);
        }
        if (selectedSdkCallback == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(1);
        }
        if (cancelCallback == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myModified = false;
        this.myHideOtherProjectVirtualenvs = false;
        this.setTitle(PyBundle.message("sdk.details.dialog.title", new Object[0]));
        this.myProject = project;
        this.myModule = module;
        this.mySelectedSdkCallback = selectedSdkCallback;
        this.myCancelCallback = cancelCallback;
        this.mySdkModelListener = new MySdkModelListener();
        this.myInterpreterList = PyConfigurableInterpreterList.getInstance(this.myProject);
        this.myProjectSdksModel = this.myInterpreterList.getModel();
        this.myProjectSdksModel.addListener(this.mySdkModelListener);
        this.mySdkList = PythonSdkDetailsDialog.buildSdkList(e -> this.updateOkButton());
        this.myMainPanel = PythonSdkDetailsDialog.buildPanel(this.mySdkList, new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PythonSdkDetailsDialog.this.addSdk();
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }, new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PythonSdkDetailsDialog.this.editSdk();
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }, new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PythonSdkDetailsDialog.this.removeSdk();
                PythonSdkDetailsDialog.this.updateOkButton();
            }
        }, new AnActionButton[]{new ToggleVirtualEnvFilterButton(), new ShowPathButton()});
        this.init();
        this.refreshSdkList();
        this.updateOkButton();
    }

    protected void dispose() {
        this.myProjectSdksModel.removeListener(this.mySdkModelListener);
        super.dispose();
    }

    @NotNull
    private static JBList<Sdk> buildSdkList(@NotNull ListSelectionListener selectionListener) {
        if (selectionListener == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(3);
        }
        JBList result = new JBList();
        result.setCellRenderer((ListCellRenderer)((Object)new PySdkListCellRenderer()));
        result.setSelectionMode(2);
        result.addListSelectionListener(selectionListener);
        new ListSpeedSearch((JList)result);
        JBList jBList = result;
        if (jBList == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(4);
        }
        return jBList;
    }

    @NotNull
    private static JPanel buildPanel(@NotNull JBList<Sdk> sdkList, @NotNull AnActionButtonRunnable addAction, @NotNull AnActionButtonRunnable editAction, @NotNull AnActionButtonRunnable removeAction, AnActionButton ... extraActions) {
        if (sdkList == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(5);
        }
        if (addAction == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(6);
        }
        if (editAction == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(7);
        }
        if (removeAction == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(8);
        }
        if (extraActions == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(9);
        }
        JPanel jPanel = ToolbarDecorator.createDecorator(sdkList).disableUpDownActions().setAddAction(addAction).setEditAction(editAction).setRemoveAction(removeAction).addExtraActions(extraActions).setPreferredSize(new Dimension(600, 500)).createPanel();
        if (jPanel == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySdkList;
    }

    private void updateOkButton() {
        super.setOKActionEnabled(this.myModified || this.myProjectSdksModel.isModified() || this.isAnotherSdkSelected());
    }

    private boolean isAnotherSdkSelected() {
        if (this.mySdkList.getSelectedValuesList().size() > 1) {
            return false;
        }
        Sdk originalSelectedSdk = this.getOriginalSelectedSdk();
        return originalSelectedSdk != null && originalSelectedSdk != this.getSdk();
    }

    protected void doOKAction() {
        this.apply();
        super.doOKAction();
    }

    public void doCancelAction() {
        boolean modified;
        boolean bl = modified = this.myModified || this.myProjectSdksModel.isModified();
        if (modified) {
            this.myProjectSdksModel.reset(this.myProject);
        }
        this.myModified = false;
        this.myCancelCallback.accept(modified);
        super.doCancelAction();
    }

    private void apply() {
        try {
            this.myProjectSdksModel.apply();
        }
        catch (ConfigurationException e) {
            LOG.error((Throwable)e);
        }
        this.myModified = false;
        Sdk sdk = this.getOriginalSelectedSdk();
        this.mySelectedSdkCallback.consume((Object)sdk);
        if (sdk != null) {
            PyPackageManagers.getInstance().clearCache(sdk);
        }
        Disposer.dispose((Disposable)this.getDisposable());
    }

    @Nullable
    private Sdk getOriginalSelectedSdk() {
        Sdk editableSdk = this.getEditableSelectedSdk();
        return editableSdk == null ? null : this.myProjectSdksModel.findSdk(editableSdk);
    }

    @Nullable
    private Sdk getEditableSelectedSdk() {
        return (Sdk)PythonSdkDetailsDialog.getTheOnlyItemOrNull(this.mySdkList.getSelectedValuesList());
    }

    @Nullable
    private static <T> T getTheOnlyItemOrNull(@NotNull List<T> collection) {
        if (collection == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(11);
        }
        if (collection.size() == 1) {
            return collection.get(0);
        }
        return null;
    }

    private void refreshSdkList() {
        List<Sdk> allPythonSdks = this.myInterpreterList.getAllPythonSdks(this.myProject);
        Sdk projectSdk = this.getSdk();
        List<Sdk> notAssociatedWithOtherProjects = ((StreamEx)StreamEx.of(allPythonSdks).filter(sdk -> !PySdkExtKt.isAssociatedWithAnotherModule(sdk, this.myModule))).toList();
        List<Sdk> pythonSdks = this.myHideOtherProjectVirtualenvs ? notAssociatedWithOtherProjects : allPythonSdks;
        this.mySdkList.setModel((ListModel)new CollectionListModel(pythonSdks));
        if (projectSdk != null) {
            projectSdk = this.myProjectSdksModel.findSdk(projectSdk.getName());
            this.mySdkList.clearSelection();
            this.mySdkList.setSelectedValue((Object)projectSdk, true);
            this.mySdkList.updateUI();
        }
    }

    @Nullable
    private Sdk getSdk() {
        if (this.myModule == null) {
            return ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
        return rootManager.getSdk();
    }

    private void addSdk() {
        PyAddSdkDialog.show(this.myProject, this.myModule, Arrays.asList(this.myProjectSdksModel.getSdks()), new SdkAddedCallback());
    }

    private void setSelectedSdk(@Nullable Sdk selectedSdk) {
        this.mySdkList.setSelectedValue(selectedSdk == null ? null : this.myProjectSdksModel.findSdk(selectedSdk.getName()), true);
    }

    private void editSdk() {
        Sdk currentSdk = this.getEditableSelectedSdk();
        if (currentSdk != null) {
            if (currentSdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData) {
                this.editRemoteSdk(currentSdk);
            } else {
                this.editSdk(currentSdk);
            }
        }
    }

    private void editRemoteSdk(Sdk currentSdk) {
        PythonRemoteInterpreterManager remoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
        if (remoteInterpreterManager != null) {
            SdkModificator modificator = currentSdk.getSdkModificator();
            HashSet existingSdks2 = Sets.newHashSet((Object[])this.myProjectSdksModel.getSdks());
            existingSdks2.remove(currentSdk);
            if (remoteInterpreterManager.editSdk(this.myProject, modificator, existingSdks2)) {
                this.commitAndRefresh(modificator);
            }
        }
    }

    private void editSdk(Sdk currentSdk) {
        SdkModificator modificator = currentSdk.getSdkModificator();
        EditSdkDialog dialog2 = new EditSdkDialog(this.myProject, modificator, (NullableFunction<? super String, String>)((NullableFunction)s -> {
            if (this.isDuplicateSdkName((String)s, currentSdk)) {
                return PyBundle.message("sdk.details.dialog.error.duplicate.name", new Object[0]);
            }
            return null;
        }));
        if (dialog2.showAndGet()) {
            boolean pathChanged;
            boolean bl = pathChanged = !Objects.equals(currentSdk.getHomePath(), dialog2.getHomePath());
            if (!modificator.getName().equals(dialog2.getName()) || pathChanged || dialog2.isAssociateChanged()) {
                modificator.setName(dialog2.getName());
                modificator.setHomePath(dialog2.getHomePath());
                if (dialog2.isAssociateChanged()) {
                    this.setSdkAssociated(modificator, dialog2.associateWithProject());
                }
                this.commitAndRefresh(modificator);
                if (pathChanged) {
                    this.reloadSdk(currentSdk);
                }
            }
        }
    }

    private void setSdkAssociated(SdkModificator modificator, boolean isAssociated) {
        PythonSdkAdditionalData additionalData = (PythonSdkAdditionalData)modificator.getSdkAdditionalData();
        if (additionalData == null) {
            additionalData = new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor(modificator.getHomePath()));
            modificator.setSdkAdditionalData((SdkAdditionalData)additionalData);
        }
        if (isAssociated && this.myModule != null) {
            additionalData.associateWithModule(this.myModule);
        } else if (isAssociated) {
            additionalData.setAssociatedModulePath(this.myProject.getBasePath());
        } else {
            additionalData.resetAssociatedModulePath();
        }
    }

    private boolean isDuplicateSdkName(String s, Sdk sdk) {
        for (Sdk existingSdk : this.myProjectSdksModel.getSdks()) {
            if (existingSdk == sdk || !existingSdk.getName().equals(s)) continue;
            return true;
        }
        return false;
    }

    private void removeSdk() {
        List selectedSdks = this.mySdkList.getSelectedValuesList();
        if (!selectedSdks.isEmpty()) {
            selectedSdks.forEach(selectedSdk -> this.myProjectSdksModel.removeSdk(selectedSdk));
            this.refreshSdkList();
            Sdk currentSdk = this.getSdk();
            if (currentSdk != null) {
                this.mySdkList.setSelectedValue((Object)currentSdk, true);
            }
        }
    }

    private void reloadSdk() {
        Sdk currentSdk = this.getEditableSelectedSdk();
        if (currentSdk != null) {
            this.reloadSdk(currentSdk);
        }
    }

    private void reloadSdk(@NotNull Sdk currentSdk) {
        if (currentSdk == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(12);
        }
        PythonSdkUpdater.updateVersionAndPathsSynchronouslyAndScheduleRemaining(currentSdk, this.myProject);
    }

    private void commitAndRefresh(@NotNull SdkModificator modificator) {
        if (modificator == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(13);
        }
        modificator.commitChanges();
        this.myModified = true;
        this.refreshSdkList();
    }

    @NotNull
    private PythonPathEditor createPathEditor(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(14);
        }
        PythonPathEditor pathEditor = PythonSdkUtil.isRemote(sdk) ? new PyRemotePathEditor(this.myProject, sdk) : new PythonPathEditor(PyBundle.message("python.sdk.configuration.tab.title", new Object[0]), OrderRootType.CLASSES, FileChooserDescriptorFactory.createAllButJarContentsDescriptor());
        pathEditor.addReloadPathsActionCallback(this::reloadSdk);
        PythonPathEditor pythonPathEditor = pathEditor;
        if (pythonPathEditor == null) {
            PythonSdkDetailsDialog.$$$reportNull$$$0(15);
        }
        return pythonPathEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedSdkCallback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelCallback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionListener";
                break;
            }
            case 4: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/configuration/PythonSdkDetailsDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraActions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/configuration/PythonSdkDetailsDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSdkList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPanel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildSdkList";
                break;
            }
            case 4: 
            case 10: 
            case 15: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildPanel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTheOnlyItemOrNull";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reloadSdk";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "commitAndRefresh";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPathEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SdkAddedCallback
    implements Consumer<Sdk> {
        private SdkAddedCallback() {
        }

        @Override
        public void accept(@Nullable Sdk sdk) {
            if (sdk != null && PythonSdkDetailsDialog.this.myProjectSdksModel.findSdk(sdk.getName()) == null) {
                PythonSdkDetailsDialog.this.myProjectSdksModel.addSdk(sdk);
                PythonSdkDetailsDialog.this.setSelectedSdk(sdk);
            }
        }
    }

    private class MySdkModelListener
    implements SdkModel.Listener {
        private MySdkModelListener() {
        }

        public void sdkAdded(@NotNull Sdk sdk) {
            if (sdk == null) {
                MySdkModelListener.$$$reportNull$$$0(0);
            }
            PythonSdkDetailsDialog.this.refreshSdkList();
        }

        public void sdkChanged(@NotNull Sdk sdk, String previousName) {
            if (sdk == null) {
                MySdkModelListener.$$$reportNull$$$0(1);
            }
            PythonSdkDetailsDialog.this.refreshSdkList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "sdk";
            objectArray2[1] = "com/jetbrains/python/configuration/PythonSdkDetailsDialog$MySdkModelListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowPathButton
    extends AnActionButton
    implements DumbAware {
        ShowPathButton() {
            super(PyBundle.messagePointer("sdk.details.dialog.show.interpreter.paths", new Object[0]), AllIcons.Actions.ShowAsTree);
        }

        public boolean isEnabled() {
            return PythonSdkDetailsDialog.this.getEditableSelectedSdk() != null;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Sdk sdk;
            if (e == null) {
                ShowPathButton.$$$reportNull$$$0(0);
            }
            if ((sdk = PythonSdkDetailsDialog.this.getEditableSelectedSdk()) == null) {
                return;
            }
            PythonPathEditor pathEditor = PythonSdkDetailsDialog.this.createPathEditor(sdk);
            SdkModificator sdkModificator = sdk.getSdkModificator();
            PythonPathDialog dialog2 = new PythonPathDialog(PythonSdkDetailsDialog.this.myProject, pathEditor);
            pathEditor.reset(sdkModificator);
            if (dialog2.showAndGet() && pathEditor.isModified()) {
                pathEditor.apply(sdkModificator);
                PythonSdkDetailsDialog.this.commitAndRefresh(sdkModificator);
                PythonSdkDetailsDialog.this.reloadSdk(sdk);
            }
            PythonSdkDetailsDialog.this.updateOkButton();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/configuration/PythonSdkDetailsDialog$ShowPathButton", "actionPerformed"));
        }
    }

    private class ToggleVirtualEnvFilterButton
    extends ToggleActionButton
    implements DumbAware {
        ToggleVirtualEnvFilterButton() {
            super(PyBundle.messagePointer("sdk.details.dialog.hide.all.virtual.envs", new Object[0]), AllIcons.General.Filter);
        }

        public boolean isSelected(AnActionEvent e) {
            return PythonSdkDetailsDialog.this.myHideOtherProjectVirtualenvs;
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            PythonSdkDetailsDialog.this.myHideOtherProjectVirtualenvs = state2;
            PythonSdkDetailsDialog.this.refreshSdkList();
            PythonSdkDetailsDialog.this.updateOkButton();
        }
    }
}

