/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PyDictKeyNamesCompletionContributor
extends CompletionContributor
implements DumbAware {
    public PyDictKeyNamesCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside(PySubscriptionExpression.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                PsiElement original = parameters.getOriginalPosition();
                int offset = parameters.getOffset();
                if (original == null) {
                    return;
                }
                CompletionResultSet dictCompletion = PyDictKeyNamesCompletionContributor.createResult(original, result, offset);
                PySubscriptionExpression subscription = (PySubscriptionExpression)PsiTreeUtil.getParentOfType((PsiElement)original, PySubscriptionExpression.class);
                if (subscription == null) {
                    return;
                }
                PyExpression operand = subscription.getOperand();
                if (PyDictKeyNamesCompletionContributor.addCompletionIfOperandIsTypedDict(operand, dictCompletion)) {
                    return;
                }
                if (operand instanceof PyReferenceExpression) {
                    PyExpression resolvedElement = PyResolveUtil.fullResolveLocally((PyReferenceExpression)operand);
                    if (resolvedElement instanceof PyDictLiteralExpression) {
                        PyDictKeyNamesCompletionContributor.addDictLiteralKeys((PyDictLiteralExpression)resolvedElement, dictCompletion);
                        PyDictKeyNamesCompletionContributor.addAdditionalKeys(parameters.getOriginalFile(), (PsiElement)operand, dictCompletion);
                    }
                    if (resolvedElement instanceof PyCallExpression) {
                        PyDictKeyNamesCompletionContributor.addDictConstructorKeys((PyCallExpression)resolvedElement, dictCompletion);
                        PyDictKeyNamesCompletionContributor.addAdditionalKeys(parameters.getOriginalFile(), (PsiElement)operand, dictCompletion);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/codeInsight/completion/PyDictKeyNamesCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean addCompletionIfOperandIsTypedDict(@NotNull PyExpression operand, @NotNull CompletionResultSet dictCompletion) {
        TypeEvalContext typeEvalContext;
        PyType type;
        if (operand == null) {
            PyDictKeyNamesCompletionContributor.$$$reportNull$$$0(0);
        }
        if (dictCompletion == null) {
            PyDictKeyNamesCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((type = (typeEvalContext = TypeEvalContext.codeCompletion(operand.getProject(), operand.getContainingFile())).getType(operand)) instanceof PyTypedDictType && !((PyTypedDictType)type).isInferred()) {
            for (String key : ((PyTypedDictType)type).getFields().keySet()) {
                dictCompletion.addElement((LookupElement)PyDictKeyNamesCompletionContributor.createElement("'" + key + "'"));
            }
            return true;
        }
        return false;
    }

    private static CompletionResultSet createResult(@NotNull PsiElement original, @NotNull CompletionResultSet result, int offset) {
        ASTNode prevNode;
        PyStringLiteralExpression prevElement;
        if (original == null) {
            PyDictKeyNamesCompletionContributor.$$$reportNull$$$0(2);
        }
        if (result == null) {
            PyDictKeyNamesCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((prevElement = (PyStringLiteralExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)original, PyStringLiteralExpression.class)) != null && (prevNode = prevElement.getNode()) != null && prevNode.getElementType() != PyTokenTypes.LBRACKET) {
            return result.withPrefixMatcher(PyDictKeyNamesCompletionContributor.findPrefix(prevElement, offset));
        }
        PsiElement parentElement = original.getParent();
        if (parentElement != null && parentElement instanceof PyStringLiteralExpression) {
            return result.withPrefixMatcher(PyDictKeyNamesCompletionContributor.findPrefix((PyElement)parentElement, offset));
        }
        PyNumericLiteralExpression number = (PyNumericLiteralExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)original.getContainingFile(), (int)(offset - 1), PyNumericLiteralExpression.class, (boolean)false);
        if (number != null) {
            return result.withPrefixMatcher(PyDictKeyNamesCompletionContributor.findPrefix(number, offset));
        }
        return result;
    }

    private static String findPrefix(PyElement element, int offset) {
        return TextRange.create((int)element.getTextRange().getStartOffset(), (int)offset).substring(element.getContainingFile().getText());
    }

    private static void addDictConstructorKeys(PyCallExpression dictConstructor, CompletionResultSet result) {
        TypeEvalContext context2;
        PyType type;
        PyExpression callee = dictConstructor.getCallee();
        if (callee == null) {
            return;
        }
        String name2 = callee.getText();
        if ("dict".equals(name2) && (type = (context2 = TypeEvalContext.codeCompletion(callee.getProject(), callee.getContainingFile())).getType(dictConstructor)) != null && type.isBuiltin()) {
            PyExpression[] argumentList;
            PyArgumentList list = dictConstructor.getArgumentList();
            if (list == null) {
                return;
            }
            for (PyExpression argument : argumentList = list.getArguments()) {
                if (!(argument instanceof PyKeywordArgument)) continue;
                result.addElement((LookupElement)PyDictKeyNamesCompletionContributor.createElement("'" + ((PyKeywordArgument)argument).getKeyword() + "'"));
            }
        }
    }

    private static void addAdditionalKeys(PsiFile file, PsiElement operand, CompletionResultSet result) {
        Collection subscriptionExpressions = PsiTreeUtil.findChildrenOfType((PsiElement)file, PySubscriptionExpression.class);
        for (PySubscriptionExpression expr : subscriptionExpressions) {
            PyExpression key;
            PsiElement parent;
            if (!expr.getOperand().getText().equals(operand.getText()) || !((parent = expr.getParent()) instanceof PyAssignmentStatement) || !expr.equals(((PyAssignmentStatement)parent).getLeftHandSideExpression()) || (key = expr.getIndexExpression()) == null) continue;
            boolean addHandler = PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)key.getTextRange().getStartOffset(), (int)key.getTextRange().getEndOffset(), PyStringLiteralExpression.class) != null;
            result.addElement((LookupElement)PyDictKeyNamesCompletionContributor.createElement(key.getText(), addHandler));
        }
    }

    public static void addDictLiteralKeys(PyDictLiteralExpression dict, CompletionResultSet result) {
        PyKeyValueExpression[] keyValues;
        for (PyKeyValueExpression expression : keyValues = dict.getElements()) {
            boolean addHandler = PsiTreeUtil.findElementOfClassAtRange((PsiFile)dict.getContainingFile(), (int)expression.getTextRange().getStartOffset(), (int)expression.getTextRange().getEndOffset(), PyStringLiteralExpression.class) != null;
            result.addElement((LookupElement)PyDictKeyNamesCompletionContributor.createElement(expression.getKey().getText(), addHandler));
        }
    }

    private static LookupElementBuilder createElement(String key) {
        return PyDictKeyNamesCompletionContributor.createElement(key, true);
    }

    private static LookupElementBuilder createElement(String key, boolean addHandler) {
        LookupElementBuilder item = LookupElementBuilder.create((String)key).withTypeText("dict key").withIcon(PlatformIcons.PARAMETER_ICON);
        if (addHandler) {
            item = item.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
                    PyStringLiteralExpression str;
                    if (context2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (item == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if ((str = (PyStringLiteralExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context2.getFile(), (int)context2.getStartOffset(), PyStringLiteralExpression.class, (boolean)false)) != null) {
                        boolean isDictKeys;
                        boolean bl = isDictKeys = PsiTreeUtil.getParentOfType((PsiElement)str, PySubscriptionExpression.class) != null;
                        if (isDictKeys) {
                            boolean badQuoting;
                            int off = context2.getStartOffset() + str.getTextLength();
                            PsiElement element = context2.getFile().findElementAt(off);
                            boolean atRBrace = element == null || element.getNode().getElementType() == PyTokenTypes.RBRACKET;
                            boolean bl2 = badQuoting = !(StringUtil.startsWithChar((CharSequence)str.getText(), (char)'\'') && StringUtil.endsWithChar((CharSequence)str.getText(), (char)'\'') || StringUtil.startsWithChar((CharSequence)str.getText(), (char)'\"') && StringUtil.endsWithChar((CharSequence)str.getText(), (char)'\"'));
                            if (badQuoting || !atRBrace) {
                                Document document = context2.getEditor().getDocument();
                                int offset = context2.getTailOffset();
                                document.deleteString(offset - 1, offset);
                            }
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "item";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/python/codeInsight/completion/PyDictKeyNamesCompletionContributor$2";
                    objectArray[2] = "handleInsert";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        return item;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictCompletion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/completion/PyDictKeyNamesCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletionIfOperandIsTypedDict";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

