/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.actions.PyExecuteInConsole;
import com.jetbrains.python.console.PyExecuteConsoleCustomizer;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.run.PythonRunConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExecuteSelectionAction
extends DumbAwareAction {
    public PyExecuteSelectionAction() {
        super(PyBundle.messagePointer("python.execute.selection.action.execute.selection.in.console", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor2;
        if (e == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(0);
        }
        if ((editor2 = (Editor)e.getData(CommonDataKeys.EDITOR)) instanceof EditorImpl) {
            PyExecuteConsoleCustomizer.Companion.getInstance().notifySciCellGutterExecuted((EditorImpl)editor2, "ExecuteInPyConsoleAction");
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (editor2 != null && project != null) {
            PythonRunConfiguration config = PyExecuteConsoleCustomizer.Companion.getInstance().getContextConfig(e.getDataContext());
            String selectionText = PyExecuteSelectionAction.getSelectionText(editor2);
            if (!PyExecuteInConsole.checkIfAvailableAndShowHint(editor2)) {
                return;
            }
            if (selectionText != null) {
                PyExecuteInConsole.executeCodeInConsole(project, selectionText, editor2, true, true, false, config);
            } else {
                String line2 = PyExecuteSelectionAction.getLineUnderCaret(editor2);
                if (line2 != null) {
                    PyExecuteInConsole.executeCodeInConsole(project, line2.trim(), editor2, true, true, false, config);
                    PyExecuteSelectionAction.moveCaretDown(editor2);
                }
            }
        }
    }

    private static void moveCaretDown(Editor editor2) {
        VisualPosition pos = editor2.getCaretModel().getVisualPosition();
        Pair lines = EditorUtil.calcSurroundingRange((Editor)editor2, (VisualPosition)pos, (VisualPosition)pos);
        int offset = editor2.getCaretModel().getOffset();
        LogicalPosition lineStart = (LogicalPosition)lines.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines.second;
        int start = editor2.logicalPositionToOffset(lineStart);
        int end = editor2.logicalPositionToOffset(nextLineStart);
        Document document = editor2.getDocument();
        if (nextLineStart.line < document.getLineCount()) {
            int newOffset = end + offset - start;
            int nextLineEndOffset = document.getLineEndOffset(nextLineStart.line);
            if (newOffset >= nextLineEndOffset) {
                newOffset = nextLineEndOffset;
            }
            editor2.getCaretModel().moveToOffset(newOffset);
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private static String getLineUnderCaret(Editor editor2) {
        VisualPosition caretPos = editor2.getCaretModel().getVisualPosition();
        Pair lines = EditorUtil.calcSurroundingRange((Editor)editor2, (VisualPosition)caretPos, (VisualPosition)caretPos);
        LogicalPosition lineStart = (LogicalPosition)lines.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines.second;
        int start = editor2.logicalPositionToOffset(lineStart);
        int end = editor2.logicalPositionToOffset(nextLineStart);
        if (end <= start) {
            return null;
        }
        return editor2.getDocument().getCharsSequence().subSequence(start, end).toString();
    }

    @Nullable
    private static String getSelectionText(@NotNull Editor editor2) {
        if (editor2 == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(1);
        }
        if (editor2.getSelectionModel().hasSelection()) {
            SelectionModel model = editor2.getSelectionModel();
            return model.getSelectedText();
        }
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(2);
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        Presentation presentation = e.getPresentation();
        boolean enabled = false;
        if (PyExecuteSelectionAction.isPython(editor2)) {
            String text2 = PyExecuteSelectionAction.getSelectionText(editor2);
            if (text2 != null) {
                presentation.setText(PyBundle.message("python.execute.selection.action.execute.selection.in.console", new Object[0]));
            } else {
                text2 = PyExecuteSelectionAction.getLineUnderCaret(editor2);
                if (text2 != null) {
                    presentation.setText(PyBundle.message("python.execute.selection.action.execute.line.in.console", new Object[0]));
                }
            }
            enabled = !StringUtil.isEmpty((String)text2);
        }
        presentation.setEnabledAndVisible(enabled);
    }

    public static boolean isPython(Editor editor2) {
        if (editor2 == null) {
            return false;
        }
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        PsiFile psi = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        return psi instanceof PyFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/actions/PyExecuteSelectionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectionText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

