"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRadiusFn = exports.getPointStyleOverrides = exports.renderPoints = void 0;
var common_1 = require("../../../utils/common");
var geometry_1 = require("../../../utils/geometry");
var indexed_geometry_map_1 = require("../utils/indexed_geometry_map");
var specs_1 = require("../utils/specs");
var point_style_1 = require("./point_style");
var utils_1 = require("./utils");
function renderPoints(shift, dataSeries, xScale, yScale, panel, color, pointStyle, hasY0Accessors, markSizeOptions, styleAccessor, spatial) {
    if (spatial === void 0) { spatial = false; }
    var indexedGeometryMap = new indexed_geometry_map_1.IndexedGeometryMap();
    var getRadius = markSizeOptions.enabled
        ? getRadiusFn(dataSeries.data, pointStyle.strokeWidth, markSizeOptions.ratio)
        : function () { return 0; };
    var geometryType = spatial ? indexed_geometry_map_1.GeometryType.spatial : indexed_geometry_map_1.GeometryType.linear;
    var y1Fn = utils_1.getY1ScaledValueOrThrowFn(yScale);
    var y0Fn = utils_1.getY0ScaledValueOrThrowFn(yScale);
    var yDefined = utils_1.isYValueDefinedFn(yScale, xScale);
    var pointGeometries = dataSeries.data.reduce(function (acc, datum, dataIndex) {
        var xValue = datum.x, mark = datum.mark;
        var prev = dataSeries.data[dataIndex - 1];
        var next = dataSeries.data[dataIndex + 1];
        if (!xScale.isValueInDomain(xValue)) {
            return acc;
        }
        if (utils_1.isDatumFilled(datum)) {
            return acc;
        }
        var x = xScale.scale(xValue);
        if (x === null) {
            return acc;
        }
        var points = [];
        var yDatumKeyNames = hasY0Accessors ? ['y0', 'y1'] : ['y1'];
        yDatumKeyNames.forEach(function (yDatumKeyName, keyIndex) {
            var _a;
            var valueAccessor = utils_1.getYDatumValueFn(yDatumKeyName);
            var y;
            try {
                y = yDatumKeyName === 'y1' ? y1Fn(datum) : y0Fn(datum);
                if (y === null) {
                    return;
                }
            }
            catch (_b) {
                return;
            }
            var originalY = getDatumYValue(datum, keyIndex === 0, hasY0Accessors, dataSeries.stackMode);
            var seriesIdentifier = {
                key: dataSeries.key,
                specId: dataSeries.specId,
                yAccessor: dataSeries.yAccessor,
                splitAccessors: dataSeries.splitAccessors,
                seriesKeys: dataSeries.seriesKeys,
                smVerticalAccessorValue: dataSeries.smVerticalAccessorValue,
                smHorizontalAccessorValue: dataSeries.smHorizontalAccessorValue,
            };
            var styleOverrides = getPointStyleOverrides(datum, seriesIdentifier, styleAccessor);
            var style = point_style_1.buildPointGeometryStyles(color, pointStyle, styleOverrides);
            var orphan = isOrphanDataPoint(dataIndex, dataSeries.data.length, yDefined, prev, next);
            var radius = markSizeOptions.enabled
                ? Math.max(getRadius(mark), pointStyle.radius)
                : (_a = styleOverrides === null || styleOverrides === void 0 ? void 0 : styleOverrides.radius) !== null && _a !== void 0 ? _a : pointStyle.radius;
            var pointGeometry = {
                x: x,
                y: y,
                radius: radius,
                color: color,
                style: style,
                value: {
                    x: xValue,
                    y: originalY,
                    mark: mark,
                    accessor: hasY0Accessors && keyIndex === 0 ? geometry_1.BandedAccessorType.Y0 : geometry_1.BandedAccessorType.Y1,
                    datum: datum.datum,
                },
                transform: {
                    x: shift,
                    y: 0,
                },
                seriesIdentifier: seriesIdentifier,
                panel: panel,
                orphan: orphan,
            };
            indexedGeometryMap.set(pointGeometry, geometryType);
            if (yDefined(datum, valueAccessor)) {
                points.push(pointGeometry);
            }
        });
        return __spread(acc, points);
    }, []);
    return {
        pointGeometries: pointGeometries,
        indexedGeometryMap: indexedGeometryMap,
    };
}
exports.renderPoints = renderPoints;
function getPointStyleOverrides(datum, seriesIdentifier, pointStyleAccessor) {
    var styleOverride = pointStyleAccessor && pointStyleAccessor(datum, seriesIdentifier);
    if (!styleOverride) {
        return;
    }
    if (typeof styleOverride === 'string') {
        return {
            stroke: styleOverride,
        };
    }
    return styleOverride;
}
exports.getPointStyleOverrides = getPointStyleOverrides;
function getDatumYValue(_a, lookingForY0, isBandChart, stackMode) {
    var y1 = _a.y1, y0 = _a.y0, initialY1 = _a.initialY1, initialY0 = _a.initialY0;
    if (isBandChart) {
        return stackMode === specs_1.StackMode.Percentage
            ?
                lookingForY0
                    ? y0
                    : y1
            :
                lookingForY0
                    ? initialY0
                    : initialY1;
    }
    return stackMode === specs_1.StackMode.Percentage ? (y1 !== null && y1 !== void 0 ? y1 : 0) - (y0 !== null && y0 !== void 0 ? y0 : 0) : initialY1;
}
function getRadiusFn(data, lineWidth, markSizeRatio) {
    if (markSizeRatio === void 0) { markSizeRatio = 50; }
    if (data.length === 0) {
        return function () { return 0; };
    }
    var _a = data.reduce(function (acc, _a) {
        var mark = _a.mark;
        return mark === null
            ? acc
            : {
                min: Math.min(acc.min, mark / 2),
                max: Math.max(acc.max, mark / 2),
            };
    }, { min: Infinity, max: -Infinity }), min = _a.min, max = _a.max;
    var adjustedMarkSizeRatio = Math.min(Math.max(markSizeRatio, 0), 100);
    var radiusStep = (max - min || max * 100) / Math.pow(adjustedMarkSizeRatio, 2);
    return function getRadius(mark, defaultRadius) {
        if (defaultRadius === void 0) { defaultRadius = 0; }
        if (mark === null) {
            return defaultRadius;
        }
        var circleRadius = (mark / 2 - min) / radiusStep;
        var baseMagicNumber = 2;
        return circleRadius ? Math.sqrt(circleRadius + baseMagicNumber) + lineWidth : lineWidth;
    };
}
exports.getRadiusFn = getRadiusFn;
function yAccessorForOrphanCheck(datum) {
    var _a;
    return ((_a = datum.filled) === null || _a === void 0 ? void 0 : _a.y1) ? null : datum.y1;
}
function isOrphanDataPoint(index, length, yDefined, prev, next) {
    if (index === 0 && (common_1.isNil(next) || !yDefined(next, yAccessorForOrphanCheck))) {
        return true;
    }
    if (index === length - 1 && (common_1.isNil(prev) || !yDefined(prev, yAccessorForOrphanCheck))) {
        return true;
    }
    return ((common_1.isNil(prev) || !yDefined(prev, yAccessorForOrphanCheck)) &&
        (common_1.isNil(next) || !yDefined(next, yAccessorForOrphanCheck)));
}
//# sourceMappingURL=points.js.map